/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos;

import ca.nrc.cadc.vos.Direction;
import ca.nrc.cadc.vos.Protocol;
import ca.nrc.cadc.vos.View;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transfer {
    private static Logger log = Logger.getLogger(Transfer.class);
    public int version = 20;
    private URI target;
    private Direction direction;
    private View view;
    private Long contentLength;
    private List<Protocol> protocols;
    private boolean keepBytes = true;
    private boolean quickTransfer = false;

    protected Transfer() {
    }

    public Transfer(URI target, Direction direction, List<Protocol> protocols) {
        this.target = target;
        this.direction = direction;
        this.protocols = protocols;
        if (this.protocols == null) {
            this.protocols = new ArrayList<Protocol>();
        }
    }

    public Transfer(URI target, URI destination, boolean keepBytes) {
        this.target = target;
        this.direction = new Direction(destination.toASCIIString());
        this.keepBytes = keepBytes;
        this.protocols = new ArrayList<Protocol>();
    }

    public Transfer(URI target, Direction direction, View view, List<Protocol> protocols) {
        this.target = target;
        this.direction = direction;
        this.view = view;
        this.protocols = protocols;
        if (this.protocols == null) {
            this.protocols = new ArrayList<Protocol>();
        }
    }

    Transfer(URI target, Direction direction, View view, List<Protocol> protocols, boolean keepBytes) {
        this.target = target;
        this.direction = direction;
        this.view = view;
        this.protocols = protocols;
        this.keepBytes = keepBytes;
        if (this.protocols == null) {
            this.protocols = new ArrayList<Protocol>();
        }
    }

    public boolean isQuickTransfer() {
        return this.quickTransfer;
    }

    public void setQuickTransfer(boolean quickTransfer) {
        this.quickTransfer = quickTransfer;
    }

    public String getEndpoint() {
        Iterator<Protocol> iterator;
        if (this.protocols != null && (iterator = this.protocols.iterator()).hasNext()) {
            Protocol p = iterator.next();
            return p.getEndpoint();
        }
        return null;
    }

    public String getEndpoint(String strProtocol) {
        String rtn = null;
        if (this.protocols != null) {
            for (Protocol p : this.protocols) {
                if (!p.getUri().equalsIgnoreCase(strProtocol)) continue;
                rtn = p.getEndpoint();
                break;
            }
        }
        return rtn;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public List<String> getAllEndpoints(String strProtocol) {
        ArrayList<String> rtn = new ArrayList<String>();
        if (this.protocols != null) {
            for (Protocol p : this.protocols) {
                if (!p.getUri().equalsIgnoreCase(strProtocol)) continue;
                rtn.add(p.getEndpoint());
            }
        }
        return rtn;
    }

    public List<String> getAllEndpoints() {
        ArrayList<String> rtn = new ArrayList<String>();
        if (this.protocols != null) {
            for (Protocol p : this.protocols) {
                rtn.add(p.getEndpoint());
            }
        }
        return rtn;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public URI getTarget() {
        return this.target;
    }

    public View getView() {
        return this.view;
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }

    public boolean isKeepBytes() {
        return this.keepBytes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Transfer[");
        sb.append(this.target);
        sb.append(",");
        sb.append(this.direction);
        sb.append(",");
        sb.append(this.view);
        if (this.protocols != null) {
            for (Protocol p : this.protocols) {
                sb.append(",");
                sb.append(p);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

