/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.web.restlet.validators;

import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.util.StringUtil;
import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.JobAttribute;
import ca.nrc.cadc.uws.web.validators.FormValidator;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.restlet.data.Form;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobFormValidatorImpl
implements FormValidator {
    final Form form;

    public JobFormValidatorImpl(Form form) {
        this.form = form;
    }

    @Override
    public Map<String, String> validate() {
        String destruction;
        HashMap<String, String> errors = new HashMap<String, String>();
        Map valuesMap = this.getForm().getValuesMap();
        if (valuesMap.containsKey(JobAttribute.EXECUTION_PHASE.getAttributeName().toUpperCase())) {
            try {
                ExecutionPhase.valueOf(((String)valuesMap.get(JobAttribute.EXECUTION_PHASE.getAttributeName().toUpperCase())).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                errors.put(JobAttribute.EXECUTION_PHASE.getAttributeName().toUpperCase(), "Execution Phase is mandatory.");
            }
        }
        if (StringUtil.hasText(destruction = (String)valuesMap.get(JobAttribute.DESTRUCTION_TIME.getAttributeName().toUpperCase())) && !this.isValidDate(destruction)) {
            errors.put(JobAttribute.DESTRUCTION_TIME.getAttributeName().toUpperCase(), "Destruction Time is a mandatory date in the format yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
        return errors;
    }

    protected boolean isValidDate(String dateString) {
        try {
            DateFormat df = DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", DateUtil.UTC);
            df.parse(dateString);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public Form getForm() {
        return this.form;
    }
}

