/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.web.restlet.resources;

import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.uws.Result;
import ca.nrc.cadc.uws.server.JobNotFoundException;
import ca.nrc.cadc.uws.server.JobPersistenceException;
import ca.nrc.cadc.uws.web.restlet.InvalidResourceException;
import ca.nrc.cadc.uws.web.restlet.resources.BaseJobResource;
import java.io.IOException;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jdom2.Document;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;

public class ResultResource
extends BaseJobResource {
    @Get
    public Representation represent() {
        Subject subject = this.getSubject();
        if (subject == null) {
            return this.doRepresent();
        }
        return (Representation)Subject.doAs(subject, new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return ResultResource.this.doRepresent();
            }
        });
    }

    private Representation doRepresent() {
        try {
            String resultID = this.getRequestAttribute("resultID");
            if (this.job == null) {
                this.job = this.getJobManager().get(this.jobID);
            }
            for (Result result : this.job.getResultsList()) {
                if (!result.getName().equals(resultID)) continue;
                this.redirectSeeOther(result.getURI().toASCIIString());
                return null;
            }
            throw new InvalidResourceException("not found: " + this.jobID + "/results/" + resultID);
        }
        catch (JobNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (TransientException t) {
            return this.generateRetryRepresentation(t);
        }
        catch (JobPersistenceException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void buildXML(Document document) throws IOException {
    }
}

