/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.web.restlet;

import ca.nrc.cadc.auth.DelegationToken;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.InvalidDelegationTokenException;
import ca.nrc.cadc.auth.PrincipalExtractor;
import ca.nrc.cadc.auth.SSOCookieCredential;
import ca.nrc.cadc.auth.SSOCookieManager;
import ca.nrc.cadc.auth.X509CertificateChain;
import ca.nrc.cadc.net.NetUtil;
import ca.nrc.cadc.util.StringUtil;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.restlet.Request;
import org.restlet.data.Cookie;
import org.restlet.data.Form;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestletPrincipalExtractor
implements PrincipalExtractor {
    private static final Logger log = Logger.getLogger(RestletPrincipalExtractor.class);
    private final Request request;
    private X509CertificateChain chain;
    private DelegationToken token;
    private SSOCookieCredential cookieCredential;
    private Principal cookiePrincipal;

    RestletPrincipalExtractor() {
        this.request = null;
    }

    public RestletPrincipalExtractor(Request req) {
        this.request = req;
    }

    private void init() {
        Series cookies;
        Form headers;
        String tokenValue;
        Collection requestCertificates;
        if (this.chain == null && (requestCertificates = (Collection)this.getRequest().getAttributes().get("org.restlet.https.clientCertificates")) != null && !requestCertificates.isEmpty()) {
            this.chain = new X509CertificateChain(requestCertificates);
        }
        if (this.token == null && StringUtil.hasText(tokenValue = (headers = (Form)this.getRequest().getAttributes().get("org.restlet.http.headers")).getFirstValue("X-CADC-DelegationToken"))) {
            try {
                this.token = DelegationToken.parse(tokenValue, this.request.getResourceRef().getPath());
            }
            catch (InvalidDelegationTokenException ex) {
                log.debug("invalid DelegationToken: " + tokenValue, ex);
                throw new AccessControlException("invalid delegation token");
            }
            catch (RuntimeException ex) {
                log.debug("invalid DelegationToken: " + tokenValue, ex);
                throw new AccessControlException("invalid delegation token");
            }
        }
        if ((cookies = this.getRequest().getCookies()) == null || cookies.size() == 0) {
            return;
        }
        for (Cookie ssoCookie : cookies) {
            if (!"CADC_SSO".equals(ssoCookie.getName()) || !StringUtil.hasText(ssoCookie.getValue())) continue;
            SSOCookieManager ssoCookieManager = new SSOCookieManager();
            try {
                this.cookiePrincipal = ssoCookieManager.parse(ssoCookie.getValue());
                this.cookieCredential = new SSOCookieCredential(ssoCookie.getValue(), NetUtil.getDomainName(this.getRequest().getResourceRef().toUrl()));
            }
            catch (IOException e) {
                log.info("Cannot use SSO Cookie. Reason: " + e.getMessage());
            }
            catch (InvalidDelegationTokenException e) {
                log.info("Cannot use SSO Cookie. Reason: " + e.getMessage());
            }
        }
    }

    @Override
    public X509CertificateChain getCertificateChain() {
        this.init();
        return this.chain;
    }

    @Override
    public Set<Principal> getPrincipals() {
        this.init();
        HashSet<Principal> principals = new HashSet<Principal>();
        this.addPrincipals(principals);
        return principals;
    }

    @Override
    public DelegationToken getDelegationToken() {
        this.init();
        return this.token;
    }

    protected void addPrincipals(Set<Principal> principals) {
        this.addHTTPPrincipal(principals);
        this.addX500Principal(principals);
    }

    protected void addHTTPPrincipal(Set<Principal> principals) {
        String httpUser = this.getAuthenticatedUsername();
        if (StringUtil.hasText(httpUser)) {
            principals.add(new HttpPrincipal(httpUser));
        } else if (this.cookiePrincipal != null) {
            principals.add(this.cookiePrincipal);
        } else if (this.token != null) {
            principals.add(this.token.getUser());
        }
    }

    protected void addX500Principal(Set<Principal> principals) {
        this.init();
        if (this.chain != null) {
            principals.add(this.chain.getPrincipal());
        }
    }

    protected String getAuthenticatedUsername() {
        String username = !this.getRequest().getClientInfo().getPrincipals().isEmpty() ? ((Principal)this.getRequest().getClientInfo().getPrincipals().get(0)).getName() : null;
        return username;
    }

    public Request getRequest() {
        return this.request;
    }

    @Override
    public SSOCookieCredential getSSOCookieCredential() {
        return this.cookieCredential;
    }
}

