/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.server;

import ca.nrc.cadc.net.HttpDownload;
import ca.nrc.cadc.util.Base64;
import ca.nrc.cadc.uws.ErrorSummary;
import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.Result;
import ca.nrc.cadc.uws.server.JobNotFoundException;
import ca.nrc.cadc.uws.server.JobPersistenceException;
import ca.nrc.cadc.uws.server.JobUpdater;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteJobUpdater
implements JobUpdater {
    private static final Logger log = Logger.getLogger(RemoteJobUpdater.class);
    private URL baseURL;

    public RemoteJobUpdater(URL baseURL) {
        this.baseURL = baseURL;
    }

    @Override
    public ExecutionPhase getPhase(String jobID) throws JobNotFoundException, JobPersistenceException {
        try {
            URL u = new URL(this.baseURL.toExternalForm() + "/" + jobID);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            HttpDownload get = new HttpDownload(u, out);
            get.setUserAgent(this.getClass().getName());
            get.run();
            if (get.getThrowable() != null) {
                if (get.getThrowable().getMessage().contains("not found")) {
                    throw new JobNotFoundException("not found: " + jobID);
                }
                throw new JobPersistenceException("failed to get " + jobID, get.getThrowable());
            }
            String phase = out.toString().trim();
            log.debug("phase: " + phase);
            ExecutionPhase ret = ExecutionPhase.toValue(phase);
            return ret;
        }
        catch (MalformedURLException bug) {
            throw new RuntimeException("BUG - failed to create valid URL", bug);
        }
    }

    public void setPhase(String jobID, ExecutionPhase ep) throws JobNotFoundException, JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecutionPhase setPhase(String jobID, ExecutionPhase start, ExecutionPhase end) throws JobNotFoundException, JobPersistenceException {
        return this.setPhase(jobID, start, end, null);
    }

    @Override
    public ExecutionPhase setPhase(String jobID, ExecutionPhase start, ExecutionPhase end, Date date) throws JobNotFoundException, JobPersistenceException {
        ErrorSummary es = null;
        return this.setPhase(jobID, start, end, es, date);
    }

    @Override
    public ExecutionPhase setPhase(String jobID, ExecutionPhase start, ExecutionPhase end, List<Result> results, Date date) throws JobNotFoundException, JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecutionPhase setPhase(String jobID, ExecutionPhase start, ExecutionPhase end, ErrorSummary error, Date date) throws JobNotFoundException, JobPersistenceException {
        if (start == null) {
            throw new IllegalArgumentException("start phase cannot be null");
        }
        if (end == null) {
            throw new IllegalArgumentException("end phase cannot be null");
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(this.baseURL.toExternalForm());
            sb.append("/");
            sb.append(jobID);
            sb.append("/");
            sb.append(start.getValue());
            sb.append("/");
            sb.append(end.getValue());
            if (error != null) {
                String msg = Base64.encodeString(error.getSummaryMessage());
                String et = error.getErrorType().name();
                sb.append("/");
                sb.append(msg);
                sb.append("/");
                sb.append(et);
            }
            URL u = new URL(sb.toString());
            log.debug("POST: " + u);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            con.setRequestMethod("POST");
            int code = con.getResponseCode();
            String msg = con.getResponseMessage();
            if (code == 200) {
                return end;
            }
            if (code == 404) {
                throw new JobNotFoundException(msg);
            }
            throw new JobPersistenceException("failed to update job " + jobID + ", reason: [" + code + "] " + msg);
        }
        catch (MalformedURLException bug) {
            throw new RuntimeException("BUG - failed to create valid URL", bug);
        }
        catch (IOException ex) {
            throw new JobPersistenceException("failed to update job " + jobID, ex);
        }
    }
}

