/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.server;

import ca.nrc.cadc.auth.IdentityManager;
import ca.nrc.cadc.auth.X500IdentityManager;
import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.uws.ErrorSummary;
import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.JobRef;
import ca.nrc.cadc.uws.Parameter;
import ca.nrc.cadc.uws.Result;
import ca.nrc.cadc.uws.server.JobNotFoundException;
import ca.nrc.cadc.uws.server.JobPersistence;
import ca.nrc.cadc.uws.server.JobPersistenceUtil;
import ca.nrc.cadc.uws.server.JobUpdater;
import ca.nrc.cadc.uws.server.RandomStringGenerator;
import ca.nrc.cadc.uws.server.StringIDGenerator;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryJobPersistence
implements JobPersistence,
JobUpdater {
    private static final Logger log = Logger.getLogger(MemoryJobPersistence.class);
    protected StringIDGenerator idGenerator;
    protected IdentityManager identityManager;
    private Thread jobCleaner;
    private DateFormat dateFormat = DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", DateUtil.UTC);
    protected final Map<String, Job> jobs = new HashMap<String, Job>();

    public MemoryJobPersistence() {
        this(new RandomStringGenerator(16), new X500IdentityManager(), 30000L);
    }

    public MemoryJobPersistence(StringIDGenerator idGenerator, IdentityManager identityManager, long JobCleanerCheckInterval) {
        this.idGenerator = idGenerator;
        this.identityManager = identityManager;
        this.setJobCleaner(JobCleanerCheckInterval);
    }

    public final void setJobCleaner(long checkInterval) {
        this.terminate();
        if (checkInterval > 0L) {
            this.jobCleaner = new Thread(new JobCleaner(checkInterval));
            this.jobCleaner.setDaemon(true);
            this.jobCleaner.start();
        }
    }

    @Override
    public final void terminate() {
        if (this.jobCleaner != null) {
            try {
                log.info("terminating JobCleaner...");
                this.jobCleaner.interrupt();
                this.jobCleaner.join();
                log.info("terminating JobCleaner... [OK]");
            }
            catch (Throwable t) {
                log.error("failed to terminate jobCleaner thread", t);
            }
            finally {
                this.jobCleaner = null;
            }
        }
    }

    @Override
    public void addParameters(String jobID, List<Parameter> params) throws JobNotFoundException {
        this.expectNotNull("jobID", jobID);
        this.expectNotNull("params", params);
        Job job = this.getJobFromMap(jobID);
        job.getParameterList().addAll(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String jobID) {
        this.expectNotNull("jobID", jobID);
        Map<String, Job> map = this.jobs;
        synchronized (map) {
            this.jobs.remove(jobID);
        }
    }

    @Override
    public Job get(String jobID) throws JobNotFoundException {
        this.expectNotNull("jobID", jobID);
        Job job = this.getJobFromMap(jobID);
        Job ret = JobPersistenceUtil.deepCopy(job);
        ret.ownerSubject = job.ownerSubject;
        return ret;
    }

    @Override
    public void getDetails(Job job) {
    }

    @Override
    public ExecutionPhase getPhase(String jobID) throws JobNotFoundException {
        this.expectNotNull("jobID", jobID);
        Job job = this.getJobFromMap(jobID);
        return job.getExecutionPhase();
    }

    @Override
    public Iterator<JobRef> iterator(String appname) {
        return this.iterator(appname);
    }

    @Override
    public Iterator<JobRef> iterator(String appName, List<ExecutionPhase> phases) {
        return this.iterator(appName, phases, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<JobRef> iterator(String appname, List<ExecutionPhase> phases, Date after, Integer last) {
        TreeMap<Date, JobRef> tmp = new TreeMap<Date, JobRef>();
        boolean skipArchived = phases == null || phases.isEmpty();
        boolean filterOnPhase = phases != null && !phases.isEmpty();
        Date nullStartTime = new Date(0L);
        Date startDate = null;
        Map<String, Job> map = this.jobs;
        synchronized (map) {
            for (Job j : this.jobs.values()) {
                if (appname != null && !j.getRequestPath().startsWith(appname) || (!skipArchived || ExecutionPhase.ARCHIVED.equals((Object)j.getExecutionPhase())) && (!filterOnPhase || !phases.contains((Object)j.getExecutionPhase()))) continue;
                startDate = j.getStartTime();
                if (startDate == null) {
                    startDate = nullStartTime;
                }
                if (after != null && j.getStartTime() != null) {
                    if (!after.before(j.getStartTime())) continue;
                    tmp.put(startDate, new JobRef(j.getID(), j.getExecutionPhase()));
                    continue;
                }
                tmp.put(startDate, new JobRef(j.getID(), j.getExecutionPhase()));
            }
        }
        if (last != null && last >= 0) {
            ArrayList all = new ArrayList(tmp.values());
            List lastN = all.subList(0, last);
            return lastN.iterator();
        }
        return tmp.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Job put(Job job) {
        this.expectNotNull("job", job);
        AccessControlContext acContext = AccessController.getContext();
        Subject caller = Subject.getSubject(acContext);
        String ownerID = null;
        if (caller != null) {
            ownerID = this.identityManager.toOwnerString(caller);
        }
        job.setOwnerID(ownerID);
        if (job.getID() == null) {
            JobPersistenceUtil.assignID(job, this.idGenerator.getID());
        }
        Job keep = JobPersistenceUtil.deepCopy(job);
        if (ownerID != null) {
            keep.ownerSubject = caller;
        }
        Map<String, Job> map = this.jobs;
        synchronized (map) {
            this.jobs.put(keep.getID(), keep);
        }
        return job;
    }

    public void setPhase(String jobID, ExecutionPhase ep) throws JobNotFoundException {
        this.setPhase(jobID, null, ep);
    }

    @Override
    public ExecutionPhase setPhase(String jobID, ExecutionPhase start, ExecutionPhase end) throws JobNotFoundException {
        return this.setPhase(jobID, start, end, null, null, null);
    }

    @Override
    public ExecutionPhase setPhase(String jobID, ExecutionPhase start, ExecutionPhase end, Date date) throws JobNotFoundException {
        return this.setPhase(jobID, start, end, null, null, date);
    }

    @Override
    public ExecutionPhase setPhase(String jobID, ExecutionPhase start, ExecutionPhase end, List<Result> results, Date date) throws JobNotFoundException {
        return this.setPhase(jobID, start, end, results, null, date);
    }

    @Override
    public ExecutionPhase setPhase(String jobID, ExecutionPhase start, ExecutionPhase end, ErrorSummary error, Date date) throws JobNotFoundException {
        return this.setPhase(jobID, start, end, null, error, date);
    }

    private ExecutionPhase setPhase(String jobID, ExecutionPhase start, ExecutionPhase end, List<Result> results, ErrorSummary error, Date date) throws JobNotFoundException {
        Job job = this.getJobFromMap(jobID);
        this.expectNotNull("end", (Object)end);
        if (start == null || job.getExecutionPhase().equals((Object)start)) {
            job.setExecutionPhase(end);
            if (results != null) {
                job.setResultsList(results);
            }
            if (error != null) {
                job.setErrorSummary(error);
            }
            if (date != null) {
                if (ExecutionPhase.EXECUTING.equals((Object)end)) {
                    job.setStartTime(date);
                } else if (JobPersistenceUtil.isFinalPhase(end)) {
                    job.setEndTime(date);
                }
            }
            return end;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job getJobFromMap(String jobID) throws JobNotFoundException {
        if (jobID == null) {
            throw new IllegalArgumentException("jobID cannot be null");
        }
        Map<String, Job> map = this.jobs;
        synchronized (map) {
            Job job = this.jobs.get(jobID);
            if (job == null) {
                throw new JobNotFoundException("not found: " + jobID);
            }
            return job;
        }
    }

    private void expectNotNull(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    private class JobCleaner
    implements Runnable {
        long dt = 6000L;

        JobCleaner(long dt) {
            this.dt = dt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Date now = new Date();
                try {
                    Map<String, Job> map = MemoryJobPersistence.this.jobs;
                    synchronized (map) {
                        log.debug("looking for old jobs...");
                        Iterator<Map.Entry<String, Job>> iter = MemoryJobPersistence.this.jobs.entrySet().iterator();
                        while (iter.hasNext()) {
                            if (Thread.interrupted()) {
                                return;
                            }
                            Map.Entry<String, Job> me = iter.next();
                            Date t = me.getValue().getDestructionTime();
                            if (now.compareTo(t) <= 0) continue;
                            log.debug("delete: " + me.getKey() + ", destruction = " + t);
                            iter.remove();
                        }
                    }
                }
                catch (ConcurrentModificationException ex) {
                    log.debug("caught ConcurrentModificationException, ignoring");
                }
                catch (Throwable t) {
                    log.error("ignoring failure while cleaning job list", t);
                }
                try {
                    Thread.sleep(this.dt);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        }
    }
}

