/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.server;

import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.Job;
import java.lang.reflect.Field;
import java.util.Date;
import org.apache.log4j.Logger;

public class JobPersistenceUtil {
    private static Logger log = Logger.getLogger(JobPersistenceUtil.class);

    public static void assignID(Job job, String jobID) {
        try {
            Field f = Job.class.getDeclaredField("jobID");
            f.setAccessible(true);
            f.set(job, jobID);
        }
        catch (NoSuchFieldException fex) {
            throw new RuntimeException("BUG", fex);
        }
        catch (IllegalAccessException bug) {
            throw new RuntimeException("BUG", bug);
        }
    }

    public static boolean isFinalPhase(ExecutionPhase ep) {
        if (ExecutionPhase.ABORTED.equals((Object)ep)) {
            return true;
        }
        if (ExecutionPhase.COMPLETED.equals((Object)ep)) {
            return true;
        }
        return ExecutionPhase.ERROR.equals((Object)ep);
    }

    public static void constraintPhaseTransition(ExecutionPhase start, ExecutionPhase end) throws IllegalArgumentException {
        if (ExecutionPhase.PENDING.equals((Object)start) || ExecutionPhase.HELD.equals((Object)start)) {
            if (ExecutionPhase.QUEUED.equals((Object)end)) {
                return;
            }
            if (ExecutionPhase.ERROR.equals((Object)end)) {
                return;
            }
            if (ExecutionPhase.ABORTED.equals((Object)end)) {
                return;
            }
            throw new IllegalArgumentException("cannot change from " + (Object)((Object)start) + " -> " + (Object)((Object)end));
        }
        if (ExecutionPhase.QUEUED.equals((Object)start)) {
            if (ExecutionPhase.EXECUTING.equals((Object)end)) {
                return;
            }
            if (ExecutionPhase.ERROR.equals((Object)end)) {
                return;
            }
            if (ExecutionPhase.ABORTED.equals((Object)end)) {
                return;
            }
            throw new IllegalArgumentException("cannot change from " + (Object)((Object)start) + " -> " + (Object)((Object)end));
        }
        if (ExecutionPhase.EXECUTING.equals((Object)start)) {
            if (ExecutionPhase.EXECUTING.equals((Object)end)) {
                return;
            }
            if (ExecutionPhase.COMPLETED.equals((Object)end)) {
                return;
            }
            if (ExecutionPhase.ERROR.equals((Object)end)) {
                return;
            }
            if (ExecutionPhase.ABORTED.equals((Object)end)) {
                return;
            }
            throw new IllegalArgumentException("cannot change from " + (Object)((Object)start) + " -> " + (Object)((Object)end));
        }
        if (ExecutionPhase.ERROR.equals((Object)start)) {
            throw new IllegalArgumentException("cannot change from " + (Object)((Object)start) + " -> " + (Object)((Object)end));
        }
        if (ExecutionPhase.ABORTED.equals((Object)start)) {
            throw new IllegalArgumentException("cannot change from " + (Object)((Object)start) + " -> " + (Object)((Object)end));
        }
        if (ExecutionPhase.UNKNOWN.equals((Object)start)) {
            return;
        }
        throw new RuntimeException("BUG: found unexpected phase: " + (Object)((Object)start));
    }

    public static void constrainDestruction(Job job, long minDestruction, long maxDestruction) {
        Date orig;
        Date d = orig = job.getDestructionTime();
        Date now = new Date();
        long min = now.getTime() + 1000L * minDestruction;
        long max = now.getTime() + 1000L * maxDestruction;
        if (d == null) {
            d = new Date(now.getTime() + 1000L * maxDestruction);
        } else if (d.getTime() < min) {
            d = new Date(min);
        } else if (d.getTime() > max) {
            d = new Date(max);
        }
        log.debug("constrainDestruction: " + minDestruction + "," + maxDestruction + "," + orig + " -> " + d);
        job.setDestructionTime(d);
    }

    public static void constrainDuration(Job job, long minDuration, long maxDuration) {
        Long orig = job.getExecutionDuration();
        Long dur = orig;
        if (dur == null) {
            dur = maxDuration;
        } else if (dur < minDuration) {
            dur = minDuration;
        } else if (dur > maxDuration) {
            dur = maxDuration;
        }
        log.debug("constrainDuration: " + minDuration + "," + maxDuration + "," + orig + " -> " + dur);
        job.setExecutionDuration(dur);
    }

    public static void constrainQuote(Job job, long minQuote, long maxQuote) {
        Date orig;
        Date d = orig = job.getQuote();
        Date now = new Date();
        long min = now.getTime() + 1000L * minQuote;
        long max = now.getTime() + 1000L * maxQuote;
        if (d == null) {
            d = new Date(max);
        } else if (d.getTime() < min) {
            d = new Date(min);
        } else if (d.getTime() > max) {
            d = new Date(max);
        }
        log.debug("constrainQuote: " + minQuote + "," + maxQuote + "," + orig + " -> " + d);
        job.setQuote(d);
    }

    public static Job deepCopy(Job job) {
        Job ret = new Job(job);
        JobPersistenceUtil.assignID(ret, job.getID());
        return ret;
    }
}

