/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.server;

import ca.nrc.cadc.auth.IdentityManager;
import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.db.DBUtil;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.profiler.Profiler;
import ca.nrc.cadc.uws.ErrorSummary;
import ca.nrc.cadc.uws.ErrorType;
import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.JobInfo;
import ca.nrc.cadc.uws.JobRef;
import ca.nrc.cadc.uws.Parameter;
import ca.nrc.cadc.uws.Result;
import ca.nrc.cadc.uws.server.JobNotFoundException;
import ca.nrc.cadc.uws.server.JobPersistenceException;
import ca.nrc.cadc.uws.server.JobPersistenceUtil;
import ca.nrc.cadc.uws.server.StringIDGenerator;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobDAO {
    private static Logger log = Logger.getLogger(JobDAO.class);
    private static final int BATCH_SIZE = 1000;
    private static final String TYPE_PARAMETER = "P";
    private static final String TYPE_RESULT = "R";
    private static String[] JOB_COLUMNS = new String[]{"jobID", "executionPhase", "executionDuration", "destructionTime", "quote", "startTime", "endTime", "error_summaryMessage", "error_type", "error_documentURL", "ownerID", "runID", "requestPath", "remoteIP", "jobInfo_content", "jobInfo_contentType", "jobInfo_valid", "lastModified"};
    private static String[] DETAIL_COLUMNS = new String[]{"jobID", "type", "name", "value"};
    private JobSchema jobSchema;
    private IdentityManager identManager;
    private StringIDGenerator idGenerator;
    private JdbcTemplate jdbc;
    private DataSourceTransactionManager transactionManager;
    private DefaultTransactionDefinition defaultTransactionDef;
    private TransactionStatus transactionStatus;
    private boolean inTransaction = false;
    private DateFormat idFormat = DateUtil.getDateFormat("yyyy-MM-dd", DateUtil.UTC);
    private DateFormat dateFormat = DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", DateUtil.UTC);
    private DateFormat isoDateFormat = DateUtil.getDateFormat("yyyy-MM-dd HH:mm:ss.SSS", DateUtil.UTC);
    private Calendar cal = Calendar.getInstance(DateUtil.UTC);
    private Profiler prof = new Profiler(JobDAO.class);

    public JobDAO(DataSource dataSource, JobSchema jobSchema, IdentityManager identManager, StringIDGenerator idGenerator) {
        this.jobSchema = jobSchema;
        this.identManager = identManager;
        this.idGenerator = idGenerator;
        this.defaultTransactionDef = new DefaultTransactionDefinition();
        this.defaultTransactionDef.setIsolationLevel(4);
        this.transactionManager = new DataSourceTransactionManager(dataSource);
        this.jdbc = new JdbcTemplate(dataSource);
    }

    protected void startTransaction() {
        if (this.transactionStatus != null) {
            throw new IllegalStateException("transaction already in progress");
        }
        log.debug("startTransaction");
        this.transactionStatus = this.transactionManager.getTransaction(this.defaultTransactionDef);
        this.inTransaction = true;
        log.debug("startTransaction: OK");
    }

    protected void commitTransaction() {
        if (this.transactionStatus == null) {
            throw new IllegalStateException("no transaction in progress");
        }
        log.debug("commitTransaction");
        this.transactionManager.commit(this.transactionStatus);
        this.transactionStatus = null;
        this.inTransaction = false;
        log.debug("commit: OK");
    }

    protected void rollbackTransaction() {
        if (!this.inTransaction) {
            throw new IllegalStateException("no transaction in progress");
        }
        if (this.transactionStatus == null) {
            return;
        }
        log.debug("rollbackTransaction");
        this.transactionManager.rollback(this.transactionStatus);
        this.transactionStatus = null;
        this.inTransaction = false;
        log.debug("rollback: OK");
    }

    public Job get(String jobID) throws JobNotFoundException, JobPersistenceException, TransientException {
        log.debug("get: " + jobID);
        try {
            JobSelectStatementCreator sc = new JobSelectStatementCreator();
            sc.setJobID(jobID);
            Job ret = (Job)this.jdbc.query((PreparedStatementCreator)sc, (ResultSetExtractor)new JobExtractor(this.jobSchema));
            this.prof.checkpoint("JobSelectStatementCreator");
            if (ret != null) {
                if (ret.appData != null) {
                    Subject s = this.identManager.toSubject(ret.appData);
                    ret.setOwnerID(this.identManager.toOwnerString(s));
                    ret.ownerSubject = s;
                    ret.appData = null;
                    this.prof.checkpoint("IdentityManager.toSubject");
                }
                return ret;
            }
        }
        catch (Throwable t) {
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to get job: " + jobID, t);
            }
            throw new JobPersistenceException("failed to get job: " + jobID, t);
        }
        throw new JobNotFoundException(jobID);
    }

    public void getDetails(Job job) throws JobPersistenceException, TransientException {
        log.debug("getDetails: " + job.getID());
        this.expectPersistentJob(job);
        try {
            JobDetailSelectStatementCreator sc = new JobDetailSelectStatementCreator();
            sc.setJobID(job.getID());
            this.jdbc.query((PreparedStatementCreator)sc, (ResultSetExtractor)new DetailExtractor(this.jobSchema, job));
            this.prof.checkpoint("JobDetailSelectStatementCreator");
        }
        catch (Throwable t) {
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to get job details: " + job.getID(), t);
            }
            throw new JobPersistenceException("failed to get job details: " + job.getID(), t);
        }
    }

    public ExecutionPhase getPhase(String jobID) throws JobNotFoundException, JobPersistenceException, TransientException {
        log.debug("getPhase: " + jobID);
        try {
            JobPhaseSelectStatementCreator sc = new JobPhaseSelectStatementCreator();
            sc.setJobID(jobID);
            ExecutionPhase ret = (ExecutionPhase)((Object)this.jdbc.query((PreparedStatementCreator)sc, (ResultSetExtractor)new PhaseExtractor()));
            this.prof.checkpoint("JobPhaseSelectStatementCreator");
            if (ret != null) {
                return ret;
            }
        }
        catch (Throwable t) {
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to get job phase: " + jobID, t);
            }
            throw new JobPersistenceException("failed to get job phase: " + jobID, t);
        }
        throw new JobNotFoundException(jobID);
    }

    public void set(String jobID, ExecutionPhase ep) throws JobNotFoundException, JobPersistenceException, TransientException {
        this.set(jobID, null, ep, null, null, null);
    }

    public ExecutionPhase set(String jobID, ExecutionPhase start, ExecutionPhase end, Date date) throws JobNotFoundException, JobPersistenceException, TransientException {
        log.debug("set: " + jobID + "," + (Object)((Object)start) + "," + (Object)((Object)end) + "," + date);
        return this.set(jobID, start, end, null, null, date);
    }

    public ExecutionPhase set(String jobID, ExecutionPhase start, ExecutionPhase end, List<Result> results, Date date) throws JobNotFoundException, JobPersistenceException, TransientException {
        log.debug("set: " + jobID + "," + (Object)((Object)start) + "," + (Object)((Object)end) + ", <results>," + date);
        return this.set(jobID, start, end, null, results, date);
    }

    public ExecutionPhase set(String jobID, ExecutionPhase start, ExecutionPhase end, ErrorSummary error, Date date) throws JobNotFoundException, JobPersistenceException, TransientException {
        log.debug("set: " + jobID + "," + (Object)((Object)start) + "," + (Object)((Object)end) + ", <error>," + date);
        return this.set(jobID, start, end, error, null, date);
    }

    public ExecutionPhase set(String jobID, ExecutionPhase start, ExecutionPhase end, ErrorSummary error, List<Result> results, Date date) throws JobNotFoundException, JobPersistenceException, TransientException {
        log.debug("set: " + jobID + "," + (Object)((Object)start) + "," + (Object)((Object)end) + ", <error>, <results>, " + date);
        boolean txn = false;
        if (results != null && results.size() > 0) {
            txn = true;
        }
        try {
            ExecutionPhase executionPhase;
            if (txn) {
                this.startTransaction();
            }
            JobPhaseUpdateStatementCreator sc = new JobPhaseUpdateStatementCreator();
            sc.setValues(jobID, start, end, error, date);
            int n = this.jdbc.update(sc);
            this.prof.checkpoint("JobPhaseUpdateStatementCreator");
            if (n == 1 && results != null && results.size() > 0) {
                DetailInsertStatementCreator disc = new DetailInsertStatementCreator();
                for (Result r : results) {
                    disc.setValues(jobID, r);
                    this.jdbc.update(disc);
                    this.prof.checkpoint("DetailInsertStatementCreator");
                }
            }
            if (txn) {
                this.commitTransaction();
                this.prof.checkpoint("commit.JobPhaseUpdateStatementCreator");
            }
            if (n == 1) {
                executionPhase = end;
                return executionPhase;
            }
            executionPhase = null;
            return executionPhase;
        }
        catch (Throwable t) {
            log.error("rollback for job: " + jobID, t);
            try {
                if (txn) {
                    this.rollbackTransaction();
                    this.prof.checkpoint("rollback.JobPhaseUpdateStatementCreator");
                }
            }
            catch (Throwable oops) {
                log.error("failed to rollback transaction", oops);
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to persist job: " + jobID, t);
            }
            throw new JobPersistenceException("failed to persist job: " + jobID, t);
        }
        finally {
            if (this.transactionStatus != null) {
                try {
                    log.warn("put: BUG - transaction still open in finally... calling rollback");
                    if (txn) {
                        this.rollbackTransaction();
                    }
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction in finally", oops);
                }
            }
        }
    }

    public Iterator<JobRef> iterator(String appname, List<ExecutionPhase> phases, Date after, Integer last) throws TransientException, JobPersistenceException {
        AccessControlContext acContext = AccessController.getContext();
        Subject subject = Subject.getSubject(acContext);
        return this.iterator(subject, appname, phases, after, last);
    }

    public Iterator<JobRef> iterator(Subject subject, String appname, List<ExecutionPhase> phases, Date after, Integer last) throws TransientException, JobPersistenceException {
        Object owner = this.identManager.toOwner(subject);
        log.debug("iterator(" + owner + ")");
        try {
            JobListIterator jobListIterator = new JobListIterator(this.jdbc, owner, appname, phases, after, last);
            this.prof.checkpoint("JobListStatementCreator");
            return jobListIterator;
        }
        catch (Throwable t) {
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to get job list for owner: " + owner, t);
            }
            throw new JobPersistenceException("failed to get job list for owner: " + owner, t);
        }
    }

    public Job put(Job job, Subject owner) throws JobPersistenceException, TransientException {
        try {
            boolean update;
            boolean bl = update = job.getID() != null;
            if (!update) {
                JobPersistenceUtil.assignID(job, this.idGenerator.getID());
            }
            log.debug("put: " + job.getID());
            if (owner != null) {
                job.appData = this.identManager.toOwner(owner);
                this.prof.checkpoint("IdentityManager.toOwner");
            }
            this.startTransaction();
            this.prof.checkpoint("start.JobPutStatementCreator");
            JobPutStatementCreator npsc = new JobPutStatementCreator(update);
            npsc.setValues(job);
            this.jdbc.update(npsc);
            this.prof.checkpoint("JobPutStatementCreator");
            int numP = 0;
            if (job.getParameterList() != null) {
                numP = job.getParameterList().size();
            }
            int numR = 0;
            if (job.getResultsList() != null) {
                numR = job.getResultsList().size();
            }
            if (numP + numR > 0) {
                DetailDeleteStatementCreator dd = new DetailDeleteStatementCreator();
                dd.setJobID(job.getID());
                this.jdbc.update(dd);
                this.prof.checkpoint("DetailDeleteStatementCreator");
            }
            DetailInsertStatementCreator disc = new DetailInsertStatementCreator();
            if (numP > 0) {
                for (Parameter param : job.getParameterList()) {
                    disc.setValues(job.getID(), param);
                    this.jdbc.update(disc);
                    this.prof.checkpoint("DetailInsertStatementCreator");
                }
            }
            if (numR > 0) {
                for (Result res : job.getResultsList()) {
                    disc.setValues(job.getID(), res);
                    this.jdbc.update(disc);
                    this.prof.checkpoint("DetailInsertStatementCreator");
                }
            }
            this.commitTransaction();
            this.prof.checkpoint("commit.JobPutStatementCreator");
            job.ownerSubject = owner;
            job.setOwnerID(this.identManager.toOwnerString(owner));
            this.prof.checkpoint("IdentityManager.toOwnerString");
            Job job2 = job;
            return job2;
        }
        catch (Throwable t) {
            log.error("rollback for job: " + job.getID(), t);
            try {
                this.rollbackTransaction();
                this.prof.checkpoint("rollback.JobPutStatementCreator");
            }
            catch (Throwable oops) {
                log.error("failed to rollback transaction", oops);
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to persist job: " + job.getID(), t);
            }
            throw new JobPersistenceException("failed to persist job: " + job.getID(), t);
        }
        finally {
            if (this.transactionStatus != null) {
                try {
                    log.warn("put: BUG - transaction still open in finally... calling rollback");
                    this.rollbackTransaction();
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction in finally", oops);
                }
            }
        }
    }

    public void addParameters(String jobID, List<Parameter> params) throws JobNotFoundException, JobPersistenceException, TransientException {
        log.debug("addParameters: " + jobID);
        try {
            if (params != null && params.size() > 0) {
                this.startTransaction();
                DetailInsertStatementCreator disc = new DetailInsertStatementCreator();
                for (Parameter p : params) {
                    disc.setValues(jobID, p);
                    this.jdbc.update(disc);
                    this.prof.checkpoint("DetailInsertStatementCreator");
                }
                this.commitTransaction();
                this.prof.checkpoint("commit.DetailInsertStatementCreator");
            }
        }
        catch (DataIntegrityViolationException notFound) {
            throw new JobNotFoundException("not found: " + jobID);
        }
        catch (Throwable t) {
            log.error("rollback for job: " + jobID, t);
            try {
                this.rollbackTransaction();
                this.prof.checkpoint("rollback.DetailInsertStatementCreator");
            }
            catch (Throwable oops) {
                log.error("failed to rollback transaction", oops);
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to persist job parameters: " + jobID, t);
            }
            throw new JobPersistenceException("failed to persist job parameters: " + jobID, t);
        }
        finally {
            if (this.transactionStatus != null) {
                try {
                    log.warn("put: BUG - transaction still open in finally... calling rollback");
                    this.rollbackTransaction();
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction in finally", oops);
                }
            }
        }
    }

    public void delete(String jobID) throws JobPersistenceException, TransientException {
        log.debug("delete: " + jobID);
        try {
            JobDeleteStatementCreator jdl = new JobDeleteStatementCreator();
            jdl.setJobID(jobID);
            this.jdbc.update(jdl);
            this.prof.checkpoint("JobDeleteStatementCreator");
        }
        catch (Throwable t) {
            log.error("failed to delete job", t);
            if (this.transactionStatus != null) {
                try {
                    this.rollbackTransaction();
                    this.prof.checkpoint("rollback.DetailInsertStatementCreator");
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction", oops);
                }
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to delete job: " + jobID, t);
            }
            throw new JobPersistenceException("failed to delete job: " + jobID, t);
        }
        finally {
            if (this.transactionStatus != null) {
                try {
                    log.warn("delete - BUG - transaction still open in finally... calling rollback");
                    this.rollbackTransaction();
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction in finally", oops);
                }
            }
        }
    }

    protected void expectPersistentJob(Job job) {
        if (job == null) {
            throw new IllegalArgumentException("job cannot be null");
        }
        if (job.getLastModified() == null) {
            throw new IllegalArgumentException("node is not a persistent job: has null lastModified");
        }
    }

    private void appendColumnNames(StringBuilder sb, List<String> arr, int start) {
        for (int c = start; c < arr.size(); ++c) {
            String col = arr.get(c);
            if (c > start) {
                sb.append(",");
            }
            sb.append(col);
        }
    }

    private void appendStatementParams(StringBuilder sb, int num) {
        for (int c = 0; c < num; ++c) {
            if (c > 0) {
                sb.append(",");
            }
            sb.append("?");
        }
    }

    private int setString(PreparedStatement ps, int col, String tableName, String columnName, String value, StringBuilder sb) throws SQLException {
        Integer limit = this.jobSchema.getColumnLength(tableName, columnName);
        if (limit == null) {
            if (value == null) {
                ps.setNull(col, 12);
            } else {
                ps.setString(col, value);
            }
            sb.append(value);
            sb.append(",");
            return 1;
        }
        if (value == null) {
            ps.setNull(col, 12);
            ps.setNull(col + 1, 12);
            sb.append("null,null,");
        } else if (value.length() <= limit) {
            ps.setString(col, value);
            ps.setNull(col + 1, 12);
            sb.append(value);
            sb.append(",null,");
        } else {
            ps.setNull(col, 12);
            ps.setString(col + 1, value);
            sb.append("null,");
            sb.append(value);
            sb.append(",");
        }
        return 2;
    }

    protected String getString(ResultSet rs, String tableName, String columnName) throws SQLException {
        String extCol;
        String value = rs.getString(columnName);
        if (value == null && (extCol = this.jobSchema.getAlternateColumn(tableName, columnName)) != null) {
            value = rs.getString(extCol);
        }
        return value;
    }

    private class DetailExtractor
    implements ResultSetExtractor {
        private JobSchema js;
        private Job job;

        public DetailExtractor(JobSchema js, Job job) {
            this.js = js;
            this.job = job;
            if (job.getParameterList() == null) {
                job.setParameterList(new ArrayList<Parameter>());
            }
            if (job.getResultsList() == null) {
                job.setResultsList(new ArrayList<Result>());
            }
        }

        public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
            while (rs.next()) {
                this.mapAndStoreRow(rs);
            }
            return this.job;
        }

        public void mapAndStoreRow(ResultSet rs) throws SQLException {
            String type = rs.getString("type");
            String name = rs.getString("name");
            String value = JobDAO.this.getString(rs, ((JobDAO)JobDAO.this).jobSchema.detailTable, "value");
            if (JobDAO.TYPE_PARAMETER.equals(type)) {
                this.job.getParameterList().add(new Parameter(name, value));
            } else if (JobDAO.TYPE_RESULT.equals(type)) {
                try {
                    URI uri = new URI(value);
                    this.job.getResultsList().add(new Result(name, uri));
                }
                catch (URISyntaxException ex) {
                    throw new IllegalStateException("failed to convert " + value + " to a URI");
                }
            } else {
                throw new IllegalStateException("unexpected type in param table: " + type);
            }
        }
    }

    private class PhaseExtractor
    implements ResultSetExtractor {
        private PhaseExtractor() {
        }

        public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
            if (rs.next()) {
                return ExecutionPhase.valueOf(JobDAO.this.getString(rs, ((JobDAO)JobDAO.this).jobSchema.jobTable, "executionPhase"));
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JobListIterator
    implements Iterator<JobRef> {
        private JdbcTemplate jdbcTemplate;
        private Iterator<JobRef> jobRefIterator;
        private String lastJobID = null;
        private Date lastStartTime = null;
        private Object owner;
        private String appname;
        private List<ExecutionPhase> phases;
        private Date after;
        private Integer last;
        private long count = 0L;

        JobListIterator(JdbcTemplate jdbc, Object owner, String appname, List<ExecutionPhase> phases, Date after, Integer last) {
            this.jdbcTemplate = jdbc;
            this.owner = owner;
            this.appname = appname;
            this.phases = phases;
            this.after = after;
            this.last = last;
            this.jobRefIterator = this.getNextBatchIterator();
        }

        @Override
        public boolean hasNext() {
            if (this.last != null && this.count >= (long)this.last.intValue()) {
                return false;
            }
            if (!this.jobRefIterator.hasNext()) {
                this.jobRefIterator = this.getNextBatchIterator();
            }
            return this.jobRefIterator.hasNext();
        }

        @Override
        public JobRef next() {
            JobRef next = this.jobRefIterator.next();
            ++this.count;
            return next;
        }

        private Iterator<JobRef> getNextBatchIterator() {
            JobListStatementCreator sc = new JobListStatementCreator(this.lastJobID, this.lastStartTime, this.owner, this.appname, this.phases, this.after, this.last);
            List jobs = this.jdbcTemplate.query((PreparedStatementCreator)sc, new RowMapper(){

                public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                    ExecutionPhase executionPhase = ExecutionPhase.valueOf(rs.getString("executionPhase").toUpperCase());
                    Timestamp startTime = rs.getTimestamp("startTime", Calendar.getInstance(DateUtil.UTC));
                    return new JobRef(rs.getString("jobID"), executionPhase, startTime);
                }
            });
            if (!jobs.isEmpty()) {
                JobRef lastEntry = (JobRef)jobs.get(jobs.size() - 1);
                this.lastJobID = lastEntry.getJobID();
                if (this.last != null) {
                    this.lastStartTime = lastEntry.getStartTime();
                }
            }
            if (this.lastStartTime != null && jobs.size() > 0) {
                int startIndex;
                for (startIndex = 0; jobs.size() > startIndex && ((JobRef)jobs.get(startIndex)).equals(this.lastStartTime) && ((JobRef)jobs.get(startIndex)).getJobID().compareTo(this.lastJobID) <= 0; ++startIndex) {
                }
                if (jobs.size() <= startIndex) {
                    throw new IllegalStateException("loop detected");
                }
                if (startIndex > 0) {
                    log.debug("throwing away " + startIndex + " duplicate(s) in batch");
                    jobs = jobs.subList(startIndex, jobs.size() - 1);
                }
            }
            if (this.lastStartTime != null && jobs.size() > 1 && this.count + (long)jobs.size() < (long)this.last.intValue()) {
                JobRef firstEntry = (JobRef)jobs.get(0);
                JobRef lastEntry = (JobRef)jobs.get(jobs.size() - 1);
                if (firstEntry.getStartTime().equals(lastEntry.getStartTime())) {
                    throw new IllegalStateException("loop detected");
                }
            }
            return jobs.iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class JobExtractor
    implements ResultSetExtractor {
        private JobSchema js;

        public JobExtractor(JobSchema js) {
            this.js = js;
        }

        public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
            if (rs.next()) {
                String jobID = rs.getString("jobID");
                ExecutionPhase executionPhase = ExecutionPhase.valueOf(rs.getString("executionPhase").toUpperCase());
                long executionDuration = rs.getLong("executionDuration");
                Timestamp destructionTime = rs.getTimestamp("destructionTime", Calendar.getInstance(DateUtil.UTC));
                Timestamp quote = rs.getTimestamp("quote", Calendar.getInstance(DateUtil.UTC));
                Timestamp startTime = rs.getTimestamp("startTime", Calendar.getInstance(DateUtil.UTC));
                Timestamp endTime = rs.getTimestamp("endTime", Calendar.getInstance(DateUtil.UTC));
                ErrorSummary errorSummary = null;
                String eMsg = JobDAO.this.getString(rs, ((JobDAO)JobDAO.this).jobSchema.jobTable, "error_summaryMessage");
                String et = JobDAO.this.getString(rs, ((JobDAO)JobDAO.this).jobSchema.jobTable, "error_type");
                ErrorType eType = null;
                if (et != null) {
                    eType = ErrorType.valueOf(et);
                }
                if (eMsg != null) {
                    URL errorUrl = null;
                    try {
                        String surl = JobDAO.this.getString(rs, ((JobDAO)JobDAO.this).jobSchema.jobTable, "error_documentURL");
                        errorUrl = new URL(surl);
                    }
                    catch (MalformedURLException e) {
                        errorUrl = null;
                    }
                    errorSummary = new ErrorSummary(eMsg, eType, errorUrl);
                }
                Object appData = rs.getObject("ownerID");
                String runID = JobDAO.this.getString(rs, ((JobDAO)JobDAO.this).jobSchema.jobTable, "runID");
                String requestPath = JobDAO.this.getString(rs, ((JobDAO)JobDAO.this).jobSchema.jobTable, "requestPath");
                String remoteIP = JobDAO.this.getString(rs, ((JobDAO)JobDAO.this).jobSchema.jobTable, "remoteIP");
                String content = JobDAO.this.getString(rs, ((JobDAO)JobDAO.this).jobSchema.jobTable, "jobInfo_content");
                String contentType = JobDAO.this.getString(rs, ((JobDAO)JobDAO.this).jobSchema.jobTable, "jobInfo_contentType");
                Boolean valid = null;
                int i = rs.getInt("jobInfo_valid");
                if (!rs.wasNull()) {
                    valid = i != 0;
                }
                JobInfo jobInfo = content == null && contentType == null ? null : new JobInfo(content, contentType, valid);
                Timestamp lastModified = rs.getTimestamp("lastModified", JobDAO.this.cal);
                Job job = new Job(executionPhase, executionDuration, destructionTime, quote, startTime, endTime, errorSummary, null, runID, requestPath, remoteIP, jobInfo, null, null);
                JobPersistenceUtil.assignID(job, jobID);
                this.assignLastModified(job, lastModified);
                job.appData = appData;
                return job;
            }
            return null;
        }

        private void assignLastModified(Job job, Date lastModified) {
            try {
                Field f = job.getClass().getDeclaredField("lastModified");
                f.setAccessible(true);
                f.set(job, lastModified);
            }
            catch (NoSuchFieldException fex) {
                throw new RuntimeException("BUG", fex);
            }
            catch (IllegalAccessException bug) {
                throw new RuntimeException("BUG", bug);
            }
        }
    }

    class JobPhaseUpdateStatementCreator
    implements PreparedStatementCreator {
        private String jobID;
        private ExecutionPhase start;
        private ExecutionPhase end;
        private ErrorSummary error;
        private Date date;

        public void setValues(String jobID, ExecutionPhase start, ExecutionPhase end, ErrorSummary error, Date date) {
            this.jobID = jobID;
            this.start = start;
            this.end = end;
            this.error = error;
            this.date = date;
        }

        public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
            StringBuilder sb = new StringBuilder();
            String sql = this.getUpdateSQL();
            log.debug(sql);
            PreparedStatement ps = conn.prepareStatement(sql);
            int col = 1;
            ps.setString(col++, this.end.name());
            sb.append(this.end.name());
            sb.append(",");
            log.debug("error summary: " + col);
            String eMsg = null;
            String eType = null;
            String eURL = null;
            if (this.error != null) {
                eMsg = this.error.getSummaryMessage();
                eType = this.error.getErrorType().name();
                if (this.error.getDocumentURL() != null) {
                    eURL = this.error.getDocumentURL().toExternalForm();
                }
                col += JobDAO.this.setString(ps, col, ((JobDAO)JobDAO.this).jobSchema.jobTable, "error_summaryMessage", eMsg, sb);
                col += JobDAO.this.setString(ps, col, ((JobDAO)JobDAO.this).jobSchema.jobTable, "error_type", eType, sb);
                col += JobDAO.this.setString(ps, col, ((JobDAO)JobDAO.this).jobSchema.jobTable, "error_documentURL", eURL, sb);
            }
            if (this.date != null) {
                Timestamp ts = new Timestamp(this.date.getTime());
                ps.setTimestamp(col++, ts, JobDAO.this.cal);
                sb.append(JobDAO.this.dateFormat.format(this.date));
                sb.append(",");
            }
            Date now = new Date();
            Timestamp nowts = new Timestamp(now.getTime());
            ps.setTimestamp(col++, nowts, JobDAO.this.cal);
            sb.append(JobDAO.this.dateFormat.format(now));
            sb.append(",");
            ps.setString(col++, this.jobID);
            sb.append(this.jobID);
            sb.append(",");
            if (this.start != null) {
                ps.setString(col++, this.start.name());
                sb.append(this.start.name());
            }
            log.debug(sb.toString());
            return ps;
        }

        private String getUpdateSQL() {
            StringBuilder sb = new StringBuilder();
            sb.append("UPDATE ");
            sb.append(((JobDAO)JobDAO.this).jobSchema.jobTable);
            sb.append(" SET executionPhase = ?");
            if (this.error != null) {
                sb.append(", error_summaryMessage = ?");
                String alt = JobDAO.this.jobSchema.getAlternateColumn(((JobDAO)JobDAO.this).jobSchema.jobTable, "error_summaryMessage");
                if (alt != null) {
                    sb.append(",");
                    sb.append(alt);
                    sb.append("= ?,");
                }
                sb.append(", error_type = ?");
                alt = JobDAO.this.jobSchema.getAlternateColumn(((JobDAO)JobDAO.this).jobSchema.jobTable, "error_type");
                if (alt != null) {
                    sb.append(",");
                    sb.append(alt);
                    sb.append("= ?,");
                }
                sb.append(", error_documentURL = ?");
                alt = JobDAO.this.jobSchema.getAlternateColumn(((JobDAO)JobDAO.this).jobSchema.jobTable, "error_documentURL");
                if (alt != null) {
                    sb.append(",");
                    sb.append(alt);
                    sb.append("= ?");
                }
            }
            if (this.date != null) {
                if (ExecutionPhase.EXECUTING.equals((Object)this.end)) {
                    sb.append(", startTime = ?");
                } else if (JobPersistenceUtil.isFinalPhase(this.end)) {
                    sb.append(", endTime = ?");
                } else {
                    this.date = null;
                }
            }
            sb.append(", lastModified = ?");
            sb.append(" WHERE jobID = ?");
            if (this.start != null) {
                sb.append(" AND executionPhase = ?");
            }
            return sb.toString();
        }
    }

    class JobPhaseSelectStatementCreator
    implements PreparedStatementCreator {
        private String jobID;
        private String sql;

        public JobPhaseSelectStatementCreator() {
            this.sql = "SELECT executionPhase FROM " + ((JobDAO)JobDAO.this).jobSchema.jobTable + " WHERE jobID = ?";
        }

        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
            log.debug(this.sql);
            log.debug("values: " + this.jobID);
            PreparedStatement ps = conn.prepareStatement(this.sql);
            ps.setString(1, this.jobID);
            return ps;
        }
    }

    class DetailDeleteStatementCreator
    implements PreparedStatementCreator {
        private String jobID;
        private String sql = this.getSQL();

        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
            log.debug(this.sql);
            log.debug("values: " + this.jobID);
            PreparedStatement ps = conn.prepareStatement(this.sql);
            ps.setString(1, this.jobID);
            return ps;
        }

        private String getSQL() {
            StringBuilder sb = new StringBuilder();
            sb.append("DELETE FROM ");
            sb.append(((JobDAO)JobDAO.this).jobSchema.detailTable);
            sb.append(" WHERE jobID = ?");
            return sb.toString();
        }
    }

    class DetailInsertStatementCreator
    implements PreparedStatementCreator {
        private String jobID;
        private Parameter p;
        private Result r;
        private String sql = this.getSQL();

        public void setValues(String jobID, Parameter p) {
            this.jobID = jobID;
            this.p = p;
            this.r = null;
        }

        public void setValues(String jobID, Result r) {
            this.jobID = jobID;
            this.p = null;
            this.r = r;
        }

        public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
            log.debug(this.sql);
            PreparedStatement ps = conn.prepareStatement(this.sql);
            StringBuilder sb = new StringBuilder();
            ps.setString(1, this.jobID);
            sb.append(this.jobID);
            sb.append(",");
            if (this.p != null) {
                ps.setString(2, JobDAO.TYPE_PARAMETER);
                ps.setString(3, this.p.getName());
                sb.append(JobDAO.TYPE_PARAMETER);
                sb.append(",");
                sb.append(this.p.getName());
                sb.append(",");
                JobDAO.this.setString(ps, 4, ((JobDAO)JobDAO.this).jobSchema.detailTable, "value", this.p.getValue(), sb);
            } else if (this.r != null) {
                ps.setString(2, JobDAO.TYPE_RESULT);
                ps.setString(3, this.r.getName());
                sb.append(JobDAO.TYPE_RESULT);
                sb.append(",");
                sb.append(this.r.getName());
                sb.append(",");
                JobDAO.this.setString(ps, 4, ((JobDAO)JobDAO.this).jobSchema.detailTable, "value", this.r.getURI().toASCIIString(), sb);
            }
            log.debug(sb);
            return ps;
        }

        private String getSQL() {
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO ");
            sb.append(((JobDAO)JobDAO.this).jobSchema.detailTable);
            sb.append(" (");
            JobDAO.this.appendColumnNames(sb, JobDAO.this.jobSchema.detailColumns, 0);
            sb.append(") VALUES (");
            JobDAO.this.appendStatementParams(sb, JobDAO.this.jobSchema.detailColumns.size());
            sb.append(")");
            return sb.toString();
        }
    }

    class JobDetailSelectStatementCreator
    implements PreparedStatementCreator {
        private String jobID;
        private String sql = this.getSQL();

        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
            PreparedStatement ret = conn.prepareStatement(this.sql);
            ret.setString(1, this.jobID);
            log.debug(this.sql);
            log.debug(this.jobID);
            return ret;
        }

        String getSQL() {
            if (this.sql != null) {
                return this.sql;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ");
            JobDAO.this.appendColumnNames(sb, JobDAO.this.jobSchema.detailColumns, 0);
            sb.append(" FROM ");
            sb.append(((JobDAO)JobDAO.this).jobSchema.detailTable);
            sb.append(" WHERE jobID = ?");
            return sb.toString();
        }
    }

    class JobSelectStatementCreator
    implements PreparedStatementCreator {
        private String jobID;
        private String sql = this.getSQL();

        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
            PreparedStatement ret = conn.prepareStatement(this.sql);
            ret.setString(1, this.jobID);
            log.debug(this.sql);
            log.debug(this.jobID);
            return ret;
        }

        String getSQL() {
            if (this.sql != null) {
                return this.sql;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ");
            JobDAO.this.appendColumnNames(sb, JobDAO.this.jobSchema.jobColumns, 0);
            sb.append(" FROM ");
            sb.append(((JobDAO)JobDAO.this).jobSchema.jobTable);
            sb.append(" WHERE jobID = ? AND deletedByUser = 0");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JobListStatementCreator
    implements PreparedStatementCreator {
        private Object owner;
        private String appname;
        private List<ExecutionPhase> phases;
        private Date after;
        private Integer last;
        private String lastJobID;
        private Date lastStartTime;

        public JobListStatementCreator(String lastJobID, Date lastStartTime, Object owner, String appname, List<ExecutionPhase> phases, Date after, Integer last) {
            this.lastJobID = lastJobID;
            this.lastStartTime = lastStartTime;
            this.appname = appname;
            this.owner = owner;
            this.phases = phases;
            this.after = after;
            this.last = last;
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
            String sql = this.getSQL();
            log.debug(sql);
            PreparedStatement ret = conn.prepareStatement(sql);
            int arg = 1;
            if (this.owner != null) {
                log.debug(arg + " : " + this.owner);
                ret.setObject(arg++, this.owner);
            }
            if (this.phases != null && !this.phases.isEmpty()) {
                for (ExecutionPhase ep : this.phases) {
                    log.debug(arg + " : " + (Object)((Object)ep));
                    ret.setString(arg++, ep.getValue());
                }
            } else {
                log.debug(arg + " : " + (Object)((Object)ExecutionPhase.ARCHIVED));
                ret.setString(arg++, ExecutionPhase.ARCHIVED.getValue());
            }
            if (this.lastJobID != null && this.lastStartTime == null) {
                log.debug(arg + " : " + this.lastJobID);
                ret.setString(arg++, this.lastJobID);
            }
            if (this.appname != null) {
                this.appname = this.appname + "%";
                log.debug(arg + " : " + this.appname);
                ret.setString(arg++, this.appname);
            }
            if (this.after != null) {
                // empty if block
            }
            return ret;
        }

        protected String getSQL() {
            int rowLimit = 1000;
            if (this.last != null && this.last < 1000) {
                rowLimit = this.last;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ");
            if (((JobDAO)JobDAO.this).jobSchema.limitWithTop) {
                sb.append("TOP ").append(rowLimit);
            }
            sb.append(" jobID, executionPhase, startTime FROM ");
            sb.append(((JobDAO)JobDAO.this).jobSchema.jobTable);
            sb.append(" WHERE deletedByUser = 0");
            if (this.owner != null) {
                sb.append(" AND ownerID = ?");
            }
            if (this.phases != null && !this.phases.isEmpty()) {
                sb.append(" AND executionPhase IN (");
                Iterator<ExecutionPhase> i = this.phases.iterator();
                while (i.hasNext()) {
                    i.next();
                    sb.append("?");
                    if (!i.hasNext()) continue;
                    sb.append(",");
                }
                sb.append(")");
            } else {
                sb.append(" AND executionPhase != ?");
            }
            if (this.lastJobID != null && this.lastStartTime == null) {
                sb.append(" AND jobID > ?");
            }
            if (this.lastStartTime != null) {
                String lastStartStr = JobDAO.this.isoDateFormat.format(this.lastStartTime);
                log.debug("lastStartTime: " + lastStartStr);
                sb.append(" AND startTime < '" + lastStartStr + "'");
            }
            if (this.appname != null) {
                sb.append(" AND requestPath LIKE ?");
            }
            if (this.after != null) {
                String afterStr = JobDAO.this.isoDateFormat.format(this.after);
                log.debug("after: " + afterStr);
                sb.append(" AND startTime > '" + afterStr + "'");
            }
            if (this.after != null || this.last != null) {
                sb.append(" AND startTime is not null");
            }
            if (this.last != null) {
                sb.append(" ORDER BY startTime DESC, jobID ASC ");
            } else {
                sb.append(" ORDER BY jobID ASC ");
            }
            if (!((JobDAO)JobDAO.this).jobSchema.limitWithTop) {
                sb.append(" LIMIT " + rowLimit);
            }
            return sb.toString();
        }
    }

    class JobPutStatementCreator
    implements PreparedStatementCreator {
        private boolean update;
        private Job job;
        private String sql;

        public JobPutStatementCreator(boolean update) {
            this.update = update;
            this.sql = update ? this.getUpdateSQL() : this.getInsertSQL();
        }

        public void setValues(Job job) {
            this.job = job;
        }

        public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
            log.debug(this.sql);
            PreparedStatement prep = conn.prepareStatement(this.sql);
            this.setValues(prep);
            return prep;
        }

        private void setValues(PreparedStatement ps) throws SQLException {
            Timestamp ts;
            StringBuilder sb = new StringBuilder();
            int col = 1;
            if (!this.update) {
                log.debug("jobID: " + col);
                ps.setString(col++, this.job.getID());
                sb.append(this.job.getID());
                sb.append(",");
            }
            ps.setString(col++, this.job.getExecutionPhase().name());
            sb.append(this.job.getExecutionPhase().name());
            sb.append(",");
            if (this.job.getExecutionDuration() != null) {
                ps.setLong(col++, this.job.getExecutionDuration());
                sb.append(this.job.getExecutionDuration());
                sb.append(",");
            } else {
                ps.setNull(col++, -5);
                sb.append("null,");
            }
            if (this.job.getDestructionTime() != null) {
                ts = new Timestamp(this.job.getDestructionTime().getTime());
                ps.setTimestamp(col++, ts, JobDAO.this.cal);
                sb.append(JobDAO.this.dateFormat.format(this.job.getDestructionTime()));
                sb.append(",");
            } else {
                ps.setNull(col++, 93);
                sb.append("null,");
            }
            if (this.job.getQuote() != null) {
                ts = new Timestamp(this.job.getQuote().getTime());
                ps.setTimestamp(col++, ts, JobDAO.this.cal);
                sb.append(JobDAO.this.dateFormat.format(this.job.getQuote()));
                sb.append(",");
            } else {
                ps.setNull(col++, 93);
                sb.append("null,");
            }
            if (this.job.getStartTime() != null) {
                ts = new Timestamp(this.job.getStartTime().getTime());
                ps.setTimestamp(col++, ts, JobDAO.this.cal);
                sb.append(JobDAO.this.dateFormat.format(this.job.getStartTime()));
                sb.append(",");
            } else {
                ps.setNull(col++, 93);
                sb.append("null,");
            }
            if (this.job.getEndTime() != null) {
                ts = new Timestamp(this.job.getEndTime().getTime());
                ps.setTimestamp(col++, ts, JobDAO.this.cal);
                sb.append(JobDAO.this.dateFormat.format(this.job.getEndTime()));
                sb.append(",");
            } else {
                ps.setNull(col++, 93);
                sb.append("null,");
            }
            log.debug("error summary: " + col);
            String eMsg = null;
            String eType = null;
            String eURL = null;
            if (this.job.getErrorSummary() != null) {
                eMsg = this.job.getErrorSummary().getSummaryMessage();
                eType = this.job.getErrorSummary().getErrorType().name();
                if (this.job.getErrorSummary().getDocumentURL() != null) {
                    eURL = this.job.getErrorSummary().getDocumentURL().toExternalForm();
                }
            }
            col += JobDAO.this.setString(ps, col, ((JobDAO)JobDAO.this).jobSchema.jobTable, "error_summaryMessage", eMsg, sb);
            col += JobDAO.this.setString(ps, col, ((JobDAO)JobDAO.this).jobSchema.jobTable, "error_type", eType, sb);
            col += JobDAO.this.setString(ps, col, ((JobDAO)JobDAO.this).jobSchema.jobTable, "error_documentURL", eURL, sb);
            log.debug("owner: " + col);
            int ownerType = JobDAO.this.identManager.getOwnerType();
            if (this.job.appData != null) {
                Object ownerObject = this.job.appData;
                ps.setObject(col++, ownerObject, ownerType);
                sb.append(ownerObject);
                sb.append(",");
            } else {
                ps.setNull(col++, ownerType);
                sb.append("null,");
            }
            log.debug("runID: " + col);
            ps.setString(col++, this.job.getRunID());
            sb.append(this.job.getRunID());
            sb.append(",");
            col += JobDAO.this.setString(ps, col, ((JobDAO)JobDAO.this).jobSchema.jobTable, "requestPath", this.job.getRequestPath(), sb);
            col += JobDAO.this.setString(ps, col, ((JobDAO)JobDAO.this).jobSchema.jobTable, "remoteIP", this.job.getRemoteIP(), sb);
            log.debug("jobInfo: " + col);
            String jiContent = null;
            String jiContentType = null;
            if (this.job.getJobInfo() != null) {
                jiContent = this.job.getJobInfo().getContent();
                jiContentType = this.job.getJobInfo().getContentType();
            }
            col += JobDAO.this.setString(ps, col, ((JobDAO)JobDAO.this).jobSchema.jobTable, "jobInfo_content", jiContent, sb);
            col += JobDAO.this.setString(ps, col, ((JobDAO)JobDAO.this).jobSchema.jobTable, "jobInfo_contentType", jiContentType, sb);
            if (this.job.getJobInfo() != null && this.job.getJobInfo().getValid() != null) {
                int jiValid = 0;
                if (this.job.getJobInfo().getValid().booleanValue()) {
                    jiValid = 1;
                }
                ps.setInt(col++, jiValid);
                sb.append(Integer.toString(jiValid));
                sb.append(",");
            } else {
                ps.setNull(col++, -6);
                sb.append("null,");
            }
            log.debug("lastModified: " + col);
            Date now = new Date();
            Timestamp ts2 = new Timestamp(now.getTime());
            ps.setTimestamp(col++, ts2, JobDAO.this.cal);
            sb.append(JobDAO.this.dateFormat.format(now));
            sb.append(",");
            if (this.update) {
                log.debug("update - jobID: " + col);
                ps.setString(col++, this.job.getID());
                sb.append(",");
                sb.append(this.job.getID());
            }
            log.debug(sb);
        }

        private String getInsertSQL() {
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO ");
            sb.append(((JobDAO)JobDAO.this).jobSchema.jobTable);
            sb.append(" (");
            JobDAO.this.appendColumnNames(sb, JobDAO.this.jobSchema.jobColumns, 0);
            sb.append(") VALUES (");
            JobDAO.this.appendStatementParams(sb, JobDAO.this.jobSchema.jobColumns.size());
            sb.append(")");
            return sb.toString();
        }

        private String getUpdateSQL() {
            StringBuilder sb = new StringBuilder();
            sb.append("UPDATE ");
            sb.append(((JobDAO)JobDAO.this).jobSchema.jobTable);
            sb.append(" SET ");
            for (int i = 1; i < JobDAO.this.jobSchema.jobColumns.size(); ++i) {
                if (i > 1) {
                    sb.append(",");
                }
                sb.append((String)JobDAO.this.jobSchema.jobColumns.get(i));
                sb.append(" = ?");
            }
            sb.append(" WHERE jobID = ?");
            return sb.toString();
        }
    }

    class JobDeleteStatementCreator
    implements PreparedStatementCreator {
        private String jobID;

        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
            String sql = "UPDATE " + ((JobDAO)JobDAO.this).jobSchema.jobTable + " SET deletedByUser = 1 WHERE jobID = ?";
            log.debug(sql);
            log.debug(this.jobID);
            PreparedStatement prep = conn.prepareStatement(sql);
            prep.setString(1, this.jobID);
            return prep;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JobSchema {
        public String jobTable;
        public String detailTable;
        boolean limitWithTop;
        public Map<String, Integer> jobColumnLimits;
        public Map<String, Integer> detailColumnLimits;
        private Map<String, String> alternateJobColumns;
        private Map<String, String> alternateDetailColumns;
        private List<String> jobColumns;
        private List<String> detailColumns;

        public JobSchema(String jobTable, String detailTable, boolean limitWithTop) {
            this(jobTable, detailTable, limitWithTop, null, null);
        }

        public JobSchema(String jobTable, String detailTable, boolean limitWithTop, Map<String, Integer> jobColumnLimits, Map<String, Integer> detailColumnLimits) {
            String alt;
            this.jobTable = jobTable;
            this.detailTable = detailTable;
            this.limitWithTop = limitWithTop;
            this.jobColumnLimits = jobColumnLimits;
            this.detailColumnLimits = detailColumnLimits;
            if (this.jobColumnLimits == null) {
                this.jobColumnLimits = new HashMap<String, Integer>();
            }
            this.alternateJobColumns = new HashMap<String, String>();
            for (String col : this.jobColumnLimits.keySet()) {
                this.alternateJobColumns.put(col, col + "_text");
            }
            if (this.detailColumnLimits == null) {
                this.detailColumnLimits = new HashMap<String, Integer>();
            }
            this.alternateDetailColumns = new HashMap<String, String>();
            for (String col : this.detailColumnLimits.keySet()) {
                this.alternateDetailColumns.put(col, col + "_text");
            }
            this.jobColumns = new ArrayList<String>();
            for (String col : JOB_COLUMNS) {
                this.jobColumns.add(col);
                alt = this.alternateJobColumns.get(col);
                if (alt == null) continue;
                this.jobColumns.add(alt);
            }
            this.detailColumns = new ArrayList<String>();
            for (String col : DETAIL_COLUMNS) {
                this.detailColumns.add(col);
                alt = this.alternateDetailColumns.get(col);
                if (alt == null) continue;
                this.detailColumns.add(alt);
            }
        }

        public String toString() {
            return this.jobTable + "/" + this.detailTable + "/" + this.jobColumnLimits.size();
        }

        public Integer getColumnLength(String tableName, String columnName) {
            if (this.jobColumnLimits != null && this.jobTable.equals(tableName)) {
                return this.jobColumnLimits.get(columnName);
            }
            if (this.detailColumnLimits != null && this.detailTable.equals(tableName)) {
                return this.detailColumnLimits.get(columnName);
            }
            return null;
        }

        public String getAlternateColumn(String tableName, String columnName) {
            String ret = null;
            if (this.alternateJobColumns != null && this.jobTable.equals(tableName)) {
                ret = this.alternateJobColumns.get(columnName);
            }
            if (this.alternateDetailColumns != null && this.detailTable.equals(tableName)) {
                ret = this.alternateDetailColumns.get(columnName);
            }
            return ret;
        }
    }
}

