/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.server;

import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.server.JobExecutor;
import ca.nrc.cadc.uws.server.JobNotFoundException;
import ca.nrc.cadc.uws.server.JobPersistenceException;
import ca.nrc.cadc.uws.server.JobPhaseException;
import ca.nrc.cadc.uws.server.JobRunner;
import ca.nrc.cadc.uws.server.JobUpdater;
import ca.nrc.cadc.uws.server.SyncOutput;
import java.util.Date;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExecutor
implements JobExecutor {
    private static final Logger log = Logger.getLogger(AbstractExecutor.class);
    protected JobUpdater jobUpdater;
    protected Class<JobRunner> jobRunnerClass;

    private AbstractExecutor() {
    }

    protected AbstractExecutor(JobUpdater jobUpdater, Class jobRunnerClass) {
        if (jobUpdater == null) {
            throw new IllegalArgumentException("jobUpdater cannot be null");
        }
        if (jobRunnerClass == null) {
            throw new IllegalArgumentException("jobRunnerClass cannot be null");
        }
        this.jobUpdater = jobUpdater;
        this.jobRunnerClass = jobRunnerClass;
    }

    @Override
    public void terminate() throws InterruptedException {
    }

    public void setJobUpdater(JobUpdater jobUpdater) {
        this.jobUpdater = jobUpdater;
    }

    public void setJobRunnerClass(Class<JobRunner> jobRunnerClass) {
        this.jobRunnerClass = jobRunnerClass;
    }

    @Override
    public final void execute(Job job) throws JobNotFoundException, JobPersistenceException, JobPhaseException, TransientException {
        this.execute(job, null);
    }

    @Override
    public final void execute(Job job, SyncOutput sync) throws JobNotFoundException, JobPersistenceException, JobPhaseException, TransientException {
        if (job == null) {
            throw new IllegalArgumentException("BUG: Job cannot be null");
        }
        log.debug("execute: " + job.getID() + " sync=" + (sync != null));
        log.debug(job.getID() + ": PENDING -> QUEUED");
        ExecutionPhase ep = this.jobUpdater.setPhase(job.getID(), ExecutionPhase.PENDING, ExecutionPhase.QUEUED);
        if (!ExecutionPhase.QUEUED.equals((Object)ep)) {
            ExecutionPhase actual = this.jobUpdater.getPhase(job.getID());
            log.debug(job.getID() + ": PENDING -> QUEUED [FAILED] -- was " + (Object)((Object)actual));
            throw new JobPhaseException("cannot execute job " + job.getID() + " when phase = " + (Object)((Object)actual));
        }
        job.setExecutionPhase(ep);
        log.debug(job.getID() + ": PENDING -> QUEUED [OK]");
        try {
            JobRunner jobRunner = this.getJobRunner();
            jobRunner.setJobUpdater(this.jobUpdater);
            jobRunner.setJob(job);
            jobRunner.setSyncOutput(sync);
            if (sync != null) {
                this.executeSync(jobRunner);
            } else {
                this.executeAsync(job, jobRunner);
            }
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("configuration error: failed to load " + this.jobRunnerClass.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("configuration error: failed to load " + this.jobRunnerClass.getName(), ex);
        }
    }

    protected JobRunner getJobRunner() throws InstantiationException, IllegalAccessException {
        log.debug("Creating " + this.jobRunnerClass.getName());
        return this.jobRunnerClass.newInstance();
    }

    protected void executeSync(JobRunner jobRunner) {
        jobRunner.run();
    }

    protected abstract void executeAsync(Job var1, JobRunner var2);

    @Override
    public void abort(Job job) throws JobNotFoundException, JobPersistenceException, JobPhaseException, TransientException {
        log.debug("abort: " + job.getID());
        ExecutionPhase ep = this.jobUpdater.setPhase(job.getID(), ExecutionPhase.PENDING, ExecutionPhase.ABORTED, new Date());
        if (!(ExecutionPhase.ABORTED.equals((Object)ep) || ExecutionPhase.ABORTED.equals((Object)(ep = this.jobUpdater.setPhase(job.getID(), ExecutionPhase.QUEUED, ExecutionPhase.ABORTED, new Date()))) || ExecutionPhase.ABORTED.equals((Object)(ep = this.jobUpdater.setPhase(job.getID(), ExecutionPhase.EXECUTING, ExecutionPhase.ABORTED, new Date()))))) {
            return;
        }
        job.setExecutionPhase(ep);
        this.abortJob(job.getID());
    }

    protected abstract void abortJob(String var1);
}

