/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws;

import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.uws.ErrorSummary;
import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.JobAttribute;
import ca.nrc.cadc.uws.JobInfo;
import ca.nrc.cadc.uws.Parameter;
import ca.nrc.cadc.uws.Result;
import ca.nrc.cadc.uws.UWS;
import ca.nrc.cadc.xml.XmlUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class JobWriter {
    private static Logger log = Logger.getLogger(JobWriter.class);
    private DateFormat dateFormat = DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", DateUtil.UTC);

    protected void writeDocument(Element root, Writer writer) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        Document document = new Document(root);
        outputter.output(document, writer);
    }

    public void write(Job job, OutputStream out) throws IOException {
        this.write(job, new OutputStreamWriter(out));
    }

    public void write(Job job, Writer writer) throws IOException {
        Element root = this.getRootElement(job);
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        Document document = new Document(root);
        outputter.output(document, writer);
    }

    public static Element getJob() {
        Element element = new Element(JobAttribute.JOB.getAttributeName(), UWS.NS);
        element.addNamespaceDeclaration(UWS.NS);
        element.addNamespaceDeclaration(UWS.XLINK_NS);
        return element;
    }

    public Element getRootElement(Job job) {
        Element jobInfo;
        Element root = new Element(JobAttribute.JOB.getAttributeName(), UWS.NS);
        root.addNamespaceDeclaration(UWS.NS);
        root.addNamespaceDeclaration(UWS.XLINK_NS);
        root.addContent(this.getJobId(job));
        root.addContent(this.getRunId(job));
        root.addContent(this.getOwnerId(job));
        root.addContent(this.getPhase(job));
        root.addContent(this.getQuote(job));
        root.addContent(this.getStartTime(job));
        root.addContent(this.getEndTime(job));
        root.addContent(this.getExecutionDuration(job));
        root.addContent(this.getDestruction(job));
        root.addContent(this.getParameters(job));
        root.addContent(this.getResults(job));
        Element errorSummary = this.getErrorSummary(job);
        if (errorSummary != null) {
            root.addContent(errorSummary);
        }
        if ((jobInfo = this.getJobInfo(job)) != null) {
            root.addContent(jobInfo);
        }
        return root;
    }

    public Element getJobId(Job job) {
        Element element = new Element(JobAttribute.JOB_ID.getAttributeName(), UWS.NS);
        element.addContent(job.getID());
        return element;
    }

    public Element getJobRef(String host, Job job) {
        Element element = new Element(JobAttribute.JOB_REF.getAttributeName(), UWS.NS);
        element.setAttribute("id", job.getID());
        element.setAttribute("xlink:href", host + job.getRequestPath() + "/" + job.getID());
        return element;
    }

    public Element getRunId(Job job) {
        Element element = new Element(JobAttribute.RUN_ID.getAttributeName(), UWS.NS);
        element.addContent(job.getRunID());
        return element;
    }

    public Element getOwnerId(Job job) {
        Element element = new Element(JobAttribute.OWNER_ID.getAttributeName(), UWS.NS);
        if (job.getOwnerID() != null) {
            element.addContent(job.getOwnerID());
        } else {
            element.setAttribute("nil", "true", UWS.XSI_NS);
        }
        return element;
    }

    public Element getPhase(Job job) {
        Element element = new Element(JobAttribute.EXECUTION_PHASE.getAttributeName(), UWS.NS);
        element.addContent(job.getExecutionPhase().toString());
        return element;
    }

    public Element getQuote(Job job) {
        Element element = new Element(JobAttribute.QUOTE.getAttributeName(), UWS.NS);
        Date date = job.getQuote();
        if (date == null) {
            element.setAttribute("nil", "true", UWS.XSI_NS);
        } else {
            element.addContent(this.dateFormat.format(date));
        }
        return element;
    }

    public Element getStartTime(Job job) {
        Element element = new Element(JobAttribute.START_TIME.getAttributeName(), UWS.NS);
        Date date = job.getStartTime();
        if (date == null) {
            element.setAttribute("nil", "true", UWS.XSI_NS);
        } else {
            element.addContent(this.dateFormat.format(date));
        }
        return element;
    }

    public Element getEndTime(Job job) {
        Element element = new Element(JobAttribute.END_TIME.getAttributeName(), UWS.NS);
        Date date = job.getEndTime();
        if (date == null) {
            element.setAttribute("nil", "true", UWS.XSI_NS);
        } else {
            element.addContent(this.dateFormat.format(date));
        }
        return element;
    }

    public Element getExecutionDuration(Job job) {
        Element element = new Element(JobAttribute.EXECUTION_DURATION.getAttributeName(), UWS.NS);
        element.addContent(Long.toString(job.getExecutionDuration()));
        return element;
    }

    public Element getDestruction(Job job) {
        Element element = new Element(JobAttribute.DESTRUCTION_TIME.getAttributeName(), UWS.NS);
        Date date = job.getDestructionTime();
        if (date == null) {
            element.setAttribute("nil", "true", UWS.XSI_NS);
        } else {
            element.addContent(this.dateFormat.format(date));
        }
        return element;
    }

    public Element getParameters(Job job) {
        Element element = new Element(JobAttribute.PARAMETERS.getAttributeName(), UWS.NS);
        for (Parameter parameter : job.getParameterList()) {
            Element e = new Element(JobAttribute.PARAMETER.getAttributeName(), UWS.NS);
            e.setAttribute("id", parameter.getName());
            e.addContent(parameter.getValue());
            element.addContent(e);
        }
        return element;
    }

    public Element getResults(Job job) {
        Element element = new Element(JobAttribute.RESULTS.getAttributeName(), UWS.NS);
        for (Result result : job.getResultsList()) {
            Element e = new Element(JobAttribute.RESULT.getAttributeName(), UWS.NS);
            e.setAttribute("id", result.getName());
            e.setAttribute("href", result.getURI().toASCIIString(), UWS.XLINK_NS);
            element.addContent(e);
        }
        return element;
    }

    public Element getErrorSummary(Job job) {
        Element eleErrorSummary = null;
        ErrorSummary es = job.getErrorSummary();
        if (es != null) {
            eleErrorSummary = new Element(JobAttribute.ERROR_SUMMARY.getAttributeName(), UWS.NS);
            eleErrorSummary.setAttribute("type", es.getErrorType().toString().toLowerCase());
            eleErrorSummary.setAttribute("hasDetail", Boolean.toString(es.getHasDetail()));
            Element eleMessage = new Element(JobAttribute.ERROR_SUMMARY_MESSAGE.getAttributeName(), UWS.NS);
            eleMessage.addContent(job.getErrorSummary().getSummaryMessage());
            eleErrorSummary.addContent(eleMessage);
        }
        return eleErrorSummary;
    }

    public Element getJobInfo(Job job) {
        Element element = null;
        JobInfo jobInfo = job.getJobInfo();
        if (jobInfo != null && jobInfo.getContent() != null && jobInfo.getValid() != null && jobInfo.getValid().booleanValue()) {
            element = new Element(JobAttribute.JOB_INFO.getAttributeName(), UWS.NS);
            try {
                Document doc = XmlUtil.buildDocument(jobInfo.getContent());
                element.addContent(doc.getRootElement().detach());
            }
            catch (Exception e) {
                element = null;
            }
        }
        return element;
    }
}

