/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import ca.nrc.cadc.net.HttpTransfer;
import ca.nrc.cadc.net.InputStreamWrapper;
import ca.nrc.cadc.net.NetUtil;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.util.FileMetadata;
import ca.nrc.cadc.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import org.apache.log4j.Logger;

public class HttpDownload
extends HttpTransfer {
    private static Logger log = Logger.getLogger(HttpDownload.class);
    private static int NONE = 0;
    private static int GZIP = 1;
    private static int ZIP = 2;
    private boolean headOnly = false;
    private String logAction = "HTTP GET";
    private boolean decompress = false;
    private boolean overwrite = false;
    private File destDir = null;
    private File origFile;
    private File decompFile;
    private File removeFile;
    private int decompressor;
    private OutputStream destStream;
    private String serverFilename;
    private File destFile;
    private InputStreamWrapper wrapper;
    private String contentType;
    private String contentEncoding;
    private String contentMD5;
    private long contentLength = -1L;
    private long decompSize = -1L;
    private long size = -1L;
    private long lastModified = -1L;
    private static char SINGLE_QUOTE = "'".charAt(0);
    private static char DOUBLE_QUOTE = "\"".charAt(0);

    public HttpDownload(URL src, File dest) {
        this(null, src, dest);
    }

    public HttpDownload(URL src, OutputStream dest) {
        this(null, src, dest);
    }

    public HttpDownload(URL src, InputStreamWrapper dest) {
        this(null, src, dest);
    }

    public HttpDownload(String userAgent, URL src, File dest) {
        super(true);
        this.setUserAgent(userAgent);
        if (src == null) {
            throw new IllegalArgumentException("source URL cannot be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("destination File cannot be null");
        }
        if (dest.exists() && dest.isDirectory()) {
            this.destDir = dest;
        } else {
            File parent = dest.getParentFile();
            if (parent == null) {
                throw new IllegalArgumentException("destination File cannot be relative");
            }
            this.destDir = parent;
            this.localFile = dest;
        }
        this.remoteURL = src;
    }

    public HttpDownload(String userAgent, URL src, OutputStream dest) {
        super(true);
        this.setUserAgent(userAgent);
        if (src == null) {
            throw new IllegalArgumentException("source URL cannot be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("destination stream cannot be null");
        }
        this.remoteURL = src;
        this.destStream = dest;
    }

    public HttpDownload(String userAgent, URL src, InputStreamWrapper dest) {
        super(true);
        this.setUserAgent(userAgent);
        if (src == null) {
            throw new IllegalArgumentException("source URL cannot be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("destination wrapper cannot be null");
        }
        this.remoteURL = src;
        this.wrapper = dest;
    }

    private HttpDownload() {
        super(true);
    }

    public String toString() {
        if (this.localFile == null) {
            return "HttpDownload[" + this.remoteURL + "]";
        }
        return "HttpDownload[" + this.remoteURL + "," + this.localFile + "]";
    }

    public void setHeadOnly(boolean headOnly) {
        this.headOnly = headOnly;
        if (headOnly) {
            this.logAction = "HTTP HEAD";
        }
    }

    public void setDecompress(boolean decompress) {
        this.decompress = decompress;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public long getSize() {
        return this.size;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public Date getLastModified() {
        if (this.lastModified > 0L) {
            return new Date(this.lastModified);
        }
        return null;
    }

    public String getFilename() {
        return this.serverFilename;
    }

    public File getFile() {
        return this.destFile;
    }

    public void run() {
        boolean done = false;
        while (!done) {
            try {
                this.runX();
                done = true;
            }
            catch (TransientException ex) {
                try {
                    long dt = 1000L * (long)ex.getRetryDelay();
                    log.debug("retry " + this.numRetries + " sleeping  for " + dt);
                    this.fireEvent(9);
                    Thread.sleep(dt);
                }
                catch (InterruptedException iex) {
                    log.debug("retry interrupted");
                    this.go = false;
                    done = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void runX() throws TransientException {
        log.debug(this.toString());
        if (!this.go) {
            return;
        }
        boolean throwTE = false;
        try {
            block40: {
                try {
                    this.thread = Thread.currentThread();
                    this.fireEvent(1);
                    this.doGet();
                    if (!this.decompress || this.decompressor == NONE) break block40;
                    this.fireEvent(this.decompFile, 4);
                    this.doDecompress();
                }
                catch (InterruptedException iex) {
                    this.go = false;
                    Object var4_3 = null;
                    HttpDownload httpDownload3 = this;
                    // MONITORENTER : httpDownload3
                    if (this.thread != null) {
                        if (Thread.interrupted()) {
                            this.go = false;
                        }
                        this.thread = null;
                    }
                    // MONITOREXIT : httpDownload3
                    if (this.failure == null && this.removeFile != null) {
                        log.debug("removing: " + this.removeFile);
                        this.fireEvent(this.removeFile, 8);
                        this.removeFile.delete();
                    }
                    if (!this.go) {
                        log.debug("cancelled");
                        this.fireEvent(6);
                        return;
                    }
                    if (this.failure != null) {
                        log.debug("failed: " + this.failure);
                        this.fireEvent(this.failure);
                        return;
                    }
                    if (throwTE) return;
                    log.debug("completed");
                    FileMetadata meta = new FileMetadata();
                    meta.setContentType(this.contentType);
                    meta.setContentEncoding(this.contentEncoding);
                    meta.setContentLength(this.contentLength);
                    meta.setMd5Sum(this.contentMD5);
                    meta.setLastModified(new Date(this.lastModified));
                    this.fireEvent(this.destFile, 5, meta);
                    return;
                }
                catch (TransientException tex) {
                    log.debug("caught: " + tex);
                    throwTE = true;
                    throw tex;
                }
                catch (AccessControlException ex) {
                    this.failure = ex;
                    Object var4_4 = null;
                    HttpDownload httpDownload4 = this;
                    // MONITORENTER : httpDownload4
                    if (this.thread != null) {
                        if (Thread.interrupted()) {
                            this.go = false;
                        }
                        this.thread = null;
                    }
                    // MONITOREXIT : httpDownload4
                    if (this.failure == null && this.removeFile != null) {
                        log.debug("removing: " + this.removeFile);
                        this.fireEvent(this.removeFile, 8);
                        this.removeFile.delete();
                    }
                    if (!this.go) {
                        log.debug("cancelled");
                        this.fireEvent(6);
                        return;
                    }
                    if (this.failure != null) {
                        log.debug("failed: " + this.failure);
                        this.fireEvent(this.failure);
                        return;
                    }
                    if (throwTE) return;
                    log.debug("completed");
                    FileMetadata meta = new FileMetadata();
                    meta.setContentType(this.contentType);
                    meta.setContentEncoding(this.contentEncoding);
                    meta.setContentLength(this.contentLength);
                    meta.setMd5Sum(this.contentMD5);
                    meta.setLastModified(new Date(this.lastModified));
                    this.fireEvent(this.destFile, 5, meta);
                    return;
                }
                catch (Throwable t) {
                    this.failure = t;
                    if (log.isDebugEnabled()) {
                        log.debug("unexpected transfer failure", t);
                    }
                    Object var4_5 = null;
                    HttpDownload httpDownload5 = this;
                    // MONITORENTER : httpDownload5
                    if (this.thread != null) {
                        if (Thread.interrupted()) {
                            this.go = false;
                        }
                        this.thread = null;
                    }
                    // MONITOREXIT : httpDownload5
                    if (this.failure == null && this.removeFile != null) {
                        log.debug("removing: " + this.removeFile);
                        this.fireEvent(this.removeFile, 8);
                        this.removeFile.delete();
                    }
                    if (!this.go) {
                        log.debug("cancelled");
                        this.fireEvent(6);
                        return;
                    }
                    if (this.failure != null) {
                        log.debug("failed: " + this.failure);
                        this.fireEvent(this.failure);
                        return;
                    }
                    if (throwTE) return;
                    log.debug("completed");
                    FileMetadata meta = new FileMetadata();
                    meta.setContentType(this.contentType);
                    meta.setContentEncoding(this.contentEncoding);
                    meta.setContentLength(this.contentLength);
                    meta.setMd5Sum(this.contentMD5);
                    meta.setLastModified(new Date(this.lastModified));
                    this.fireEvent(this.destFile, 5, meta);
                    return;
                }
            }
            Object var4_2 = null;
            HttpDownload httpDownload = this;
            // MONITORENTER : httpDownload
            if (this.thread != null) {
                if (Thread.interrupted()) {
                    this.go = false;
                }
                this.thread = null;
            }
            // MONITOREXIT : httpDownload
            if (this.failure == null && this.removeFile != null) {
                log.debug("removing: " + this.removeFile);
                this.fireEvent(this.removeFile, 8);
                this.removeFile.delete();
            }
            if (!this.go) {
                log.debug("cancelled");
                this.fireEvent(6);
                return;
            }
            if (this.failure != null) {
                log.debug("failed: " + this.failure);
                this.fireEvent(this.failure);
                return;
            }
            if (throwTE) return;
            log.debug("completed");
            FileMetadata meta = new FileMetadata();
            meta.setContentType(this.contentType);
            meta.setContentEncoding(this.contentEncoding);
            meta.setContentLength(this.contentLength);
            meta.setMd5Sum(this.contentMD5);
            meta.setLastModified(new Date(this.lastModified));
            this.fireEvent(this.destFile, 5, meta);
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            HttpDownload httpDownload2 = this;
            // MONITORENTER : httpDownload2
            if (this.thread != null) {
                if (Thread.interrupted()) {
                    this.go = false;
                }
                this.thread = null;
            }
            // MONITOREXIT : httpDownload2
            if (this.failure == null && this.removeFile != null) {
                log.debug("removing: " + this.removeFile);
                this.fireEvent(this.removeFile, 8);
                this.removeFile.delete();
            }
            if (!this.go) {
                log.debug("cancelled");
                this.fireEvent(6);
                throw throwable;
            }
            if (this.failure != null) {
                log.debug("failed: " + this.failure);
                this.fireEvent(this.failure);
                throw throwable;
            }
            if (throwTE) throw throwable;
            log.debug("completed");
            FileMetadata meta = new FileMetadata();
            meta.setContentType(this.contentType);
            meta.setContentEncoding(this.contentEncoding);
            meta.setContentLength(this.contentLength);
            meta.setMd5Sum(this.contentMD5);
            meta.setLastModified(new Date(this.lastModified));
            this.fireEvent(this.destFile, 5, meta);
            throw throwable;
        }
    }

    protected boolean askOverwrite(File f, Long length, Long lastMod) {
        return this.overwrite || this.overwriteChooser != null && this.overwriteChooser.overwriteFile(f.getAbsolutePath(), f.length(), f.lastModified(), length, lastMod);
    }

    private boolean doCheckDestination() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean doDownload = true;
        if (this.origFile.exists()) {
            log.debug(this.origFile + " exists");
            if (this.askOverwrite(this.origFile, this.contentLength, this.lastModified)) {
                log.debug("overwrite: YES -- " + this.origFile);
                this.origFile.delete();
                if (this.decompFile != null && this.decompFile.exists()) {
                    this.decompFile.delete();
                }
                this.destFile = this.decompress && this.decompressor != NONE ? this.decompFile : this.origFile;
            } else {
                log.debug("overwrite: NO -- " + this.origFile);
                if (this.decompress && this.decompressor != NONE) {
                    this.decompFile.delete();
                    doDownload = false;
                    this.destFile = this.decompFile;
                    this.removeFile = this.origFile;
                } else {
                    doDownload = false;
                }
            }
        } else if (this.decompFile != null && this.decompFile.exists()) {
            log.debug(this.decompFile + " exists");
            if (this.askOverwrite(this.decompFile, this.decompSize, this.lastModified)) {
                log.debug("overwrite: YES -- " + this.decompFile);
                this.removeFile = this.decompFile;
                this.destFile = this.decompress && this.decompressor != NONE ? this.decompFile : this.origFile;
            } else {
                log.debug("overwrite: NO -- " + this.decompFile);
                this.destFile = this.decompFile;
                this.removeFile = null;
                doDownload = false;
            }
        } else {
            this.destFile = this.decompress && this.decompressor != NONE && this.decompFile != null ? this.decompFile : this.origFile;
        }
        log.debug("destination file: " + this.destFile);
        this.localFile = this.destFile;
        return doDownload;
    }

    private void processHeader(HttpURLConnection conn) throws IOException, InterruptedException {
        String ucl;
        this.contentEncoding = conn.getHeaderField("Content-Encoding");
        this.contentType = conn.getContentType();
        this.contentMD5 = conn.getHeaderField("Content-MD5");
        String cl = conn.getHeaderField("Content-Length");
        if (cl != null) {
            try {
                this.contentLength = Long.parseLong(cl);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((ucl = conn.getHeaderField("X-Uncompressed-Length")) != null) {
            try {
                this.decompSize = Long.parseLong(ucl);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.lastModified = conn.getLastModified();
        this.serverFilename = this.getServerFilename(conn);
        if (this.destStream == null && this.wrapper == null) {
            String origFilename = null;
            if (this.localFile != this.destDir) {
                this.origFile = this.localFile;
            }
            if (this.origFile == null) {
                this.origFile = new File(this.destDir, this.serverFilename);
            }
            origFilename = this.origFile.getName();
            if ("gzip".equals(this.contentEncoding) || origFilename.endsWith(".gz")) {
                if (origFilename.endsWith(".gz")) {
                    this.decompFile = new File(this.destDir, origFilename.substring(0, origFilename.length() - 3));
                } else {
                    this.decompFile = this.origFile;
                    this.origFile = new File(this.destDir, origFilename + ".gz");
                }
                this.decompressor = GZIP;
            } else if ("zip".equals(this.contentEncoding) || origFilename.endsWith(".zip")) {
                if (origFilename.endsWith(".zip")) {
                    this.decompFile = new File(this.destDir, origFilename.substring(0, origFilename.length() - 4));
                } else {
                    this.decompFile = this.origFile;
                    this.origFile = new File(this.destDir, origFilename + ".zip");
                }
                this.decompressor = ZIP;
            }
        }
        log.debug("   original file: " + this.origFile);
        log.debug("     decomp file: " + this.decompFile);
        log.debug("  content length: " + this.contentLength);
        log.debug("     content md5: " + this.contentMD5);
        log.debug("    content type: " + this.contentType);
        log.debug("content encoding: " + this.contentEncoding);
        log.debug("     decomp size: " + this.decompSize);
        log.debug("    decompressor: " + this.decompressor);
        log.debug("    lastModified: " + this.lastModified);
    }

    private String getServerFilename(HttpURLConnection conn) {
        String ret = null;
        String cdisp = conn.getHeaderField("Content-Disposition");
        log.debug("HTTP HEAD: Content-Disposition = " + cdisp);
        if (cdisp != null) {
            ret = HttpDownload.parseContentDisposition(cdisp);
        }
        if (ret == null) {
            String s = this.remoteURL.getPath();
            String query = this.remoteURL.getQuery();
            int i = s.lastIndexOf(47);
            if (i != -1 && i < s.length() - 1) {
                ret = s.substring(i + 1, s.length());
            }
            if (query != null) {
                ret = ret + "?" + query;
            }
        }
        if (ret == null) {
            ret = this.remoteURL.getHost();
        }
        return ret;
    }

    private int checkStatusCode(HttpURLConnection conn) throws IOException, TransientException {
        int code;
        this.responseCode = code = conn.getResponseCode();
        log.debug(this.logAction + " status: " + code + " for " + this.remoteURL);
        String location = conn.getHeaderField("Location");
        if ((code == 303 || code == 302 || code == 301) && location != null) {
            this.redirectURL = new URL(location);
        } else if (code > 303) {
            String msg = "(" + code + ") " + conn.getResponseMessage();
            if (this.destStream != null) {
                NetUtil.getErrorBody(conn, this.destStream);
            } else {
                String body = NetUtil.getErrorBody(conn);
                if (StringUtil.hasText(body)) {
                    msg = msg + ": " + body;
                }
            }
            this.checkTransient(code, msg, conn);
            switch (code) {
                case 204: {
                    break;
                }
                case 401: {
                    throw new AccessControlException("authentication failed " + msg);
                }
                case 403: {
                    throw new AccessControlException("authorization failed " + msg);
                }
                case 404: {
                    throw new FileNotFoundException("resource not found " + msg);
                }
                default: {
                    throw new IOException(msg);
                }
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doGet() throws IOException, InterruptedException, TransientException {
        block55: {
            block50: {
                block48: {
                    block52: {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        istream = null;
                        ostream = null;
                        conn = (HttpURLConnection)this.remoteURL.openConnection();
                        HttpDownload.log.debug("HttpURLConnection type: " + conn.getClass().getName() + " for GET " + this.remoteURL);
                        if (conn instanceof HttpsURLConnection) {
                            sslConn = (HttpsURLConnection)conn;
                            this.initHTTPS(sslConn);
                        }
                        this.setRequestSSOCookie(conn);
                        conn.setInstanceFollowRedirects(this.followRedirects);
                        conn.setRequestProperty("Accept", "*/*");
                        conn.setRequestProperty("User-Agent", this.userAgent);
                        this.setRequestHeaders(conn);
                        if (this.headOnly) {
                            conn.setRequestMethod("HEAD");
                        } else {
                            conn.setRequestMethod("GET");
                        }
                        code = this.checkStatusCode(conn);
                        this.processHeader(conn);
                        if (this.headOnly) break block52;
                        if (this.followRedirects || this.redirectURL == null) break block53;
                    }
                    var16_6 = null;
                    if (istream == null) break block48;
                    HttpDownload.log.debug("closing InputStream");
                    try {
                        istream.close();
                    }
                    catch (Exception var17_10) {
                        // empty catch block
                    }
                }
                if (ostream == null) ** GOTO lbl-1000
                HttpDownload.log.debug("closing OutputStream");
                try {
                    ostream.close();
                }
                catch (Exception var17_10) {
                    // empty catch block
                }
lbl-1000:
                // 3 sources

                {
                    block53: {
                        return;
                    }
                    doDownload = true;
                    if (this.destStream == null && this.wrapper == null) {
                        doDownload = this.doCheckDestination();
                    }
                    v0 = this.go = this.go != false && doDownload != false;
                    if (this.go) break block54;
                }
                var16_7 = null;
                if (istream != null) {
                    HttpDownload.log.debug("closing InputStream");
                    try {
                        istream.close();
                    }
                    catch (Exception var17_11) {
                        // empty catch block
                    }
                }
                if (ostream == null) ** GOTO lbl-1000
                HttpDownload.log.debug("closing OutputStream");
                try {
                    ostream.close();
                }
                catch (Exception var17_11) {
                    // empty catch block
                }
lbl-1000:
                // 3 sources

                {
                    block54: {
                        return;
                    }
                    tmp = this.origFile;
                    this.size = this.contentLength;
                    pkey = null;
                    pvalue = null;
                    append = false;
                    startingPos = 0L;
                    if (this.destStream == null && this.wrapper == null) {
                        this.origFile = new File(this.origFile.getAbsolutePath() + ".part");
                        if (this.origFile.exists() && this.origFile.length() < this.contentLength) {
                            pkey = "Range";
                            pvalue = "bytes=" + this.origFile.length() + "-";
                        }
                    }
                    if (pkey != null) {
                        rconn = (HttpURLConnection)this.remoteURL.openConnection();
                        HttpDownload.log.debug("HttpURLConnection type: " + conn.getClass().getName() + " for GET " + this.remoteURL);
                        if (rconn instanceof HttpsURLConnection) {
                            sslConn = (HttpsURLConnection)rconn;
                            this.initHTTPS(sslConn);
                        }
                        this.setRequestSSOCookie(rconn);
                        rconn.setInstanceFollowRedirects(true);
                        rconn.setRequestProperty("Accept", "*/*");
                        rconn.setRequestProperty("User-Agent", this.userAgent);
                        this.setRequestHeaders(conn);
                        HttpDownload.log.debug("trying: " + pkey + " = " + pvalue);
                        rconn.setRequestProperty(pkey, pvalue);
                        rconn.setRequestMethod("GET");
                        rcode = rconn.getResponseCode();
                        HttpDownload.log.debug(this.logAction + " status: " + rcode + " for range request to " + this.remoteURL);
                        if (pkey != null && code == 416) {
                            try {
                                HttpDownload.log.debug("cannot resume: closing second connection");
                                rconn.disconnect();
                            }
                            catch (Exception var14_25) {}
                        } else {
                            try {
                                HttpDownload.log.debug("can resume: closing first connection");
                                conn.disconnect();
                            }
                            catch (Exception var14_26) {
                                // empty catch block
                            }
                            conn = rconn;
                            code = rcode;
                        }
                    }
                    if (pkey != null && code == 206) {
                        cr = conn.getHeaderField("Content-Range");
                        HttpDownload.log.debug("Content-Range = " + cr);
                        if (cr != null && (cr = cr.trim()).startsWith("bytes")) {
                            cr = cr.substring(6);
                            parts = cr.split("-");
                            startingPos = Long.parseLong(parts[0]);
                            HttpDownload.log.debug("found startingPos = " + startingPos);
                            ss = cr.split("/");
                            this.size = Long.parseLong(ss[1]);
                            HttpDownload.log.debug("found real size = " + this.size);
                            append = true;
                        }
                    } else {
                        this.checkStatusCode(conn);
                    }
                    this.fireEvent(2);
                    this.findEventID(conn);
                    this.fireEvent(this.origFile, 3);
                    istream = conn.getInputStream();
                    if (!(istream instanceof BufferedInputStream)) {
                        HttpDownload.log.debug("using BufferedInputStream");
                        istream = new BufferedInputStream(istream, this.bufferSize);
                    }
                    if (this.destStream != null) {
                        HttpDownload.log.debug("output: supplied OutputStream");
                        ostream = this.destStream;
                        HttpDownload.log.debug("using BufferedOutputStream");
                        ostream = new BufferedOutputStream(ostream, this.bufferSize);
                    } else if (this.wrapper == null) {
                        parent = this.origFile.getParentFile();
                        parent.mkdirs();
                        if (!parent.exists()) {
                            throw new IOException("failed to create one or more parent dir(s):" + parent);
                        }
                        HttpDownload.log.debug("output: " + this.origFile + " append: " + append);
                        ostream = new FileOutputStream(this.origFile, append);
                        HttpDownload.log.debug("using BufferedOutputStream");
                        ostream = new BufferedOutputStream(ostream, this.bufferSize);
                    }
                    if (this.wrapper != null) {
                        this.wrapper.read(istream);
                    } else if (this.use_nio) {
                        this.nioLoop(istream, ostream, 2 * this.bufferSize, startingPos);
                    } else {
                        md5 = this.ioLoop(istream, ostream, 2 * this.bufferSize, startingPos);
                        if (this.contentMD5 != null && md5 != null && !md5.equals(this.contentMD5)) {
                            sb = new StringBuilder();
                            sb.append("MD5 mismatch: ");
                            sb.append(this.contentMD5).append(" (header) != ").append(md5).append(" (bytes)");
                            if (this.remoteURL != null) {
                                sb.append(" url: ").append(this.remoteURL);
                            }
                            if (this.destFile != null) {
                                sb.append(" destFile: ").append(this.destFile.getAbsolutePath());
                            }
                            HttpDownload.log.warn(sb.toString());
                        }
                    }
                    if (ostream != null) {
                        ostream.flush();
                    }
                    HttpDownload.log.debug("download completed");
                    if (this.destStream != null || this.wrapper != null) break block50;
                    HttpDownload.log.debug("renaming " + this.origFile + " to " + tmp);
                    this.origFile.renameTo(tmp);
                    this.origFile = tmp;
                    this.destFile = tmp;
                }
            }
            var16_8 = null;
            if (istream != null) {
                HttpDownload.log.debug("closing InputStream");
                try {
                    istream.close();
                }
                catch (Exception var17_12) {
                    // empty catch block
                }
            }
            if (ostream != null) {
                HttpDownload.log.debug("closing OutputStream");
                try {
                    ostream.close();
                }
                catch (Exception var17_12) {}
            }
            break block55;
            catch (Throwable var15_28) {
                var16_9 = null;
                if (istream != null) {
                    HttpDownload.log.debug("closing InputStream");
                    try {
                        istream.close();
                    }
                    catch (Exception var17_13) {
                        // empty catch block
                    }
                }
                if (ostream != null) {
                    HttpDownload.log.debug("closing OutputStream");
                    try {
                        ostream.close();
                    }
                    catch (Exception var17_13) {
                        // empty catch block
                    }
                }
                throw var15_28;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDecompress() throws IOException, InterruptedException {
        Exception exception3;
        OutputStream ostream;
        block17: {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InputStream istream = null;
            ostream = null;
            try {
                this.size = this.decompSize;
                int sz = this.bufferSize;
                if (this.decompressor == GZIP) {
                    log.debug("input: GZIPInputStream(BufferedInputStream(FileInputStream)");
                    istream = new GZIPInputStream((InputStream)new FileInputStream(this.origFile), sz);
                } else if (this.decompressor == ZIP) {
                    log.debug("input: ZIPInputStream(BufferedInputStream(FileInputStream)");
                    istream = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.origFile)));
                }
                log.debug("output: " + this.decompFile);
                ostream = new BufferedOutputStream(new FileOutputStream(this.decompFile), sz);
                this.removeFile = this.origFile;
                if (this.use_nio) {
                    this.nioLoop(istream, ostream, sz, 0L);
                } else {
                    this.ioLoop(istream, ostream, sz, 0L);
                }
                ostream.flush();
                this.destFile = this.decompFile;
                Object var5_4 = null;
                if (istream == null) break block17;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var5_5 = null;
                if (istream != null) {
                    try {
                        istream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (ostream != null) {
                    try {
                        ostream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                istream.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (ostream != null) {
            try {
                ostream.close();
            }
            catch (Exception exception3) {}
        }
    }

    private static boolean isFilenameDisposition(String cdisp) {
        if (cdisp == null) {
            return false;
        }
        return (cdisp = cdisp.toLowerCase()).startsWith("attachment") || cdisp.startsWith("inline");
    }

    public static String parseContentDisposition(String cdisp) {
        if (!HttpDownload.isFilenameDisposition(cdisp)) {
            return null;
        }
        String[] parts = cdisp.split(";");
        for (int p = 0; p < parts.length; ++p) {
            boolean re;
            String part = parts[p].trim();
            if (part.charAt(0) == '\"') {
                part = part.substring(1, part.length());
            }
            if (part.charAt(part.length() - 1) == '\"') {
                part = part.substring(0, part.length() - 1);
            }
            if (!part.startsWith("filename")) continue;
            int i = part.indexOf(61);
            String filename = part.substring(i + 1, part.length());
            char c1 = filename.charAt(0);
            char c2 = filename.charAt(filename.length() - 1);
            boolean rs = c1 == SINGLE_QUOTE || c1 == DOUBLE_QUOTE;
            boolean bl = re = c2 == SINGLE_QUOTE || c2 == DOUBLE_QUOTE;
            if (rs && re) {
                filename = filename.substring(1, filename.length() - 1);
            } else if (rs) {
                filename = filename.substring(1, filename.length());
            } else if (re) {
                filename = filename.substring(0, filename.length() - 1);
            }
            i = filename.lastIndexOf(47);
            if (i >= 0) {
                filename = filename.substring(i + 1);
            }
            if ((i = filename.lastIndexOf(92)) >= 0) {
                filename = filename.substring(i + 1);
            }
            return filename;
        }
        return null;
    }
}

