/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.log;

import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.Authorizer;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.util.Log4jInit;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LogControlServlet
extends HttpServlet {
    private static final long serialVersionUID = 200909091014L;
    private static final Logger logger = Logger.getLogger(LogControlServlet.class);
    private static final Level DEFAULT_LEVEL = Level.INFO;
    private static final String LOG_LEVEL_PARAM = "logLevel";
    private static final String PACKAGES_PARAM = "logLevelPackages";
    private static final String GROUP_PARAM = "logAccessGroup";
    private static final String GROUP_AUTHORIZER = "groupAuthorizer";
    private Level level = null;
    private List<String> packages;
    private String accessGroup;
    private Authorizer groupAuthorizer;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.packages = new ArrayList<String>();
        String levelVal = config.getInitParameter(LOG_LEVEL_PARAM);
        this.level = levelVal == null ? DEFAULT_LEVEL : (levelVal.equalsIgnoreCase(Level.TRACE.toString()) ? Level.TRACE : (levelVal.equalsIgnoreCase(Level.DEBUG.toString()) ? Level.DEBUG : (levelVal.equalsIgnoreCase(Level.INFO.toString()) ? Level.INFO : (levelVal.equalsIgnoreCase(Level.WARN.toString()) ? Level.WARN : (levelVal.equalsIgnoreCase(Level.ERROR.toString()) ? Level.ERROR : (levelVal.equalsIgnoreCase(Level.FATAL.toString()) ? Level.FATAL : DEFAULT_LEVEL))))));
        String webapp = config.getServletContext().getServletContextName();
        if (webapp == null) {
            webapp = "[?]";
        }
        String thisPkg = LogControlServlet.class.getPackage().getName();
        Log4jInit.setLevel(webapp, thisPkg, this.level);
        this.packages.add(thisPkg);
        logger.info("log level: " + thisPkg + " =  " + this.level);
        String packageParamValues = config.getInitParameter(PACKAGES_PARAM);
        if (packageParamValues != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(packageParamValues, " \n\t\r", false);
            while (stringTokenizer.hasMoreTokens()) {
                String pkg = stringTokenizer.nextToken();
                if (pkg.length() <= 0) continue;
                Log4jInit.setLevel(webapp, pkg, this.level);
                logger.info("log level: " + pkg + " =  " + this.level);
                if (this.packages.contains(pkg)) continue;
                this.packages.add(pkg);
            }
        }
        this.accessGroup = config.getInitParameter(GROUP_PARAM);
        String authClassName = config.getInitParameter(GROUP_AUTHORIZER);
        if (this.accessGroup != null && authClassName != null) {
            try {
                Class<?> authClass = Class.forName(authClassName);
                Object o = authClass.newInstance();
                this.groupAuthorizer = (Authorizer)o;
            }
            catch (Exception e) {
                logger.error("Could not load group authorizer", e);
            }
        }
        logger.info("init complete");
        logger.debug("init complete -- YOU SHOULD NEVER SEE THIS MESSAGE");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.authorize(request, true);
        }
        catch (AccessControlException e) {
            logger.debug("Forbidden");
            response.setStatus(403);
            return;
        }
        catch (TransientException e) {
            logger.error("Error calling group authorizer", e);
            response.setStatus(503);
            return;
        }
        catch (Throwable t) {
            logger.error("Error calling group authorizer", t);
            response.setStatus(500);
            return;
        }
        response.setStatus(200);
        response.setContentType("text/plain");
        PrintWriter writer = response.getWriter();
        for (String pkg : this.packages) {
            Logger log = Logger.getLogger(pkg);
            writer.println(pkg + " " + log.getLevel());
        }
        writer.close();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String[] pkgs;
        Subject subject = AuthenticationUtil.getSubject(request);
        logger.debug(subject.toString());
        try {
            this.authorize(request, false);
        }
        catch (AccessControlException e) {
            logger.debug("Forbidden");
            response.setStatus(403);
            return;
        }
        catch (TransientException e) {
            logger.error("Error calling group authorizer", e);
            response.setStatus(503);
            return;
        }
        catch (Throwable t) {
            logger.error("Error calling group authorizer", t);
            response.setStatus(500);
            return;
        }
        String[] params = request.getParameterValues("level");
        String levelVal = null;
        if (params != null && params.length > 0) {
            levelVal = params[0];
        }
        if (levelVal != null) {
            if (levelVal == null) {
                this.level = DEFAULT_LEVEL;
            } else if (levelVal.equalsIgnoreCase(Level.TRACE.toString())) {
                this.level = Level.TRACE;
            } else if (levelVal.equalsIgnoreCase(Level.DEBUG.toString())) {
                this.level = Level.DEBUG;
            } else if (levelVal.equalsIgnoreCase(Level.INFO.toString())) {
                this.level = Level.INFO;
            } else if (levelVal.equalsIgnoreCase(Level.WARN.toString())) {
                this.level = Level.WARN;
            } else if (levelVal.equalsIgnoreCase(Level.ERROR.toString())) {
                this.level = Level.ERROR;
            } else if (levelVal.equalsIgnoreCase(Level.FATAL.toString())) {
                this.level = Level.FATAL;
            } else {
                response.setStatus(400);
                response.setContentType("text/plain");
                PrintWriter writer = response.getWriter();
                writer.println("unrecognised value for level: " + levelVal);
                writer.close();
            }
        }
        if ((pkgs = request.getParameterValues("package")) != null) {
            String dnt = request.getParameter("notrack");
            boolean track = dnt == null;
            for (String p : pkgs) {
                logger.info("setLevel: " + p + " -> " + this.level);
                Log4jInit.setLevel(p, this.level);
                if (this.packages.contains(p) || !track) continue;
                this.packages.add(p);
            }
        } else {
            for (String p : this.packages) {
                logger.info("setLevel: " + p + " -> " + this.level);
                Log4jInit.setLevel(p, this.level);
            }
        }
        response.setStatus(303);
        String url = request.getRequestURI();
        response.setHeader("Location", url);
    }

    private void authorize(HttpServletRequest request, boolean readOnly) throws AccessControlException, TransientException {
        block8: {
            if (this.accessGroup == null || this.groupAuthorizer == null) {
                logger.debug("Authorization not configured, log control is public.");
                return;
            }
            Subject subject = AuthenticationUtil.getSubject(request);
            logger.debug(subject.toString());
            GroupAuthorizationAction groupCheck = new GroupAuthorizationAction(readOnly);
            try {
                if (subject == null) {
                    groupCheck.run();
                    break block8;
                }
                try {
                    Subject.doAs(subject, groupCheck);
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
            catch (Exception e) {
                if (e instanceof AccessControlException) {
                    throw (AccessControlException)e;
                }
                if (e instanceof TransientException) {
                    throw (TransientException)e;
                }
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GroupAuthorizationAction
    implements PrivilegedExceptionAction<Object> {
        private boolean readOnly;

        GroupAuthorizationAction(boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        public Object run() throws Exception {
            try {
                if (this.readOnly) {
                    LogControlServlet.this.groupAuthorizer.getReadPermission(null);
                } else {
                    LogControlServlet.this.groupAuthorizer.getWritePermission(null);
                }
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("UnexpectedException", e);
            }
            return null;
        }
    }
}

