/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.db;

import ca.nrc.cadc.db.StandaloneContext;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import org.apache.log4j.Logger;

public class StandaloneContextFactory
implements InitialContextFactory {
    private static final Logger log = Logger.getLogger(StandaloneContextFactory.class);
    private static Context CTX;

    public static void initJNDI() throws NamingException {
        StandaloneContextFactory.checkJNDI();
        if (CTX == null) {
            CTX = new StandaloneContext();
            System.setProperty("java.naming.factory.initial", StandaloneContextFactory.class.getName());
        }
    }

    private static void checkJNDI() throws NamingException {
        String jnfi = System.getProperty("java.naming.factory.initial");
        if (StandaloneContextFactory.class.getName().equals(jnfi)) {
            return;
        }
        try {
            InitialContext initContext = new InitialContext();
            Context envContext = (Context)initContext.lookup("java:/com/env");
            throw new IllegalStateException("attempt to initialise StandaloneContext in a real JNDI environment");
        }
        catch (NoInitialContextException ignore) {
            log.debug("checkJNDI: caught NoInitialContextException -- standalone init OK");
            return;
        }
    }

    public Context getInitialContext(Hashtable environment) throws NamingException {
        log.debug("StandaloneContextFactory.getInitialContext");
        return CTX;
    }
}

