/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.Asn1Object;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.BasicX509KeyManager;
import ca.nrc.cadc.auth.BasicX509TrustManager;
import ca.nrc.cadc.auth.DerParser;
import ca.nrc.cadc.auth.X509CertificateChain;
import ca.nrc.cadc.util.Base64;
import ca.nrc.cadc.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public class SSLUtil {
    private static Logger log = Logger.getLogger(SSLUtil.class);
    private static final String SSL_PROTOCOL = "TLS";
    private static final String KEYSTORE_TYPE = "JKS";
    private static final String KEYMANAGER_ALGORITHM = "SunX509";
    private static final String CERT_ALIAS = "opencadc_x509";
    private static final char[] THE_PASSWORD = "opencadc_x509".toCharArray();

    public static void initSSL(File certFile, File keyFile) {
        try {
            SSLSocketFactory sf = SSLUtil.getSocketFactory(certFile, keyFile);
            HttpsURLConnection.setDefaultSSLSocketFactory(sf);
        }
        catch (Exception e) {
            log.debug("Errore QUIIIIIIIIIIIIIIIII");
            throw new RuntimeException("Errore QUIIIIIIIIIIIIIIIII", e);
        }
    }

    public static void initSSL(File pemFile) {
        try {
            X509CertificateChain chain = SSLUtil.readPemCertificateAndKey(pemFile);
            SSLSocketFactory sf = SSLUtil.getSocketFactory(chain);
            HttpsURLConnection.setDefaultSSLSocketFactory(sf);
        }
        catch (InvalidKeySpecException ex) {
            throw new RuntimeException("failed to read RSA private key from " + pemFile, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("BUG: failed to create empty KeyStore", ex);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("failed to find certificate and/or key file " + pemFile, ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("failed to read certificate file " + pemFile, ex);
        }
        catch (CertificateException ex) {
            throw new RuntimeException("failed to load certificate from file " + pemFile, ex);
        }
    }

    public static SSLSocketFactory getSocketFactory(File certFile, File keyFile) {
        SSLSocketFactory socketFactory = null;
        try {
            KeyStore ks = SSLUtil.getKeyStore(certFile, keyFile);
            KeyStore ts = null;
            socketFactory = SSLUtil.getSocketFactory(ks, ts);
        }
        catch (Exception e) {
            log.debug("Errore QUIIIIIIIIIIIIIIIII222222222222222");
            throw new RuntimeException("Errore QUIIIIIIIIIIIIIIIII222222222222222", e);
        }
        return socketFactory;
    }

    public static SSLSocketFactory getSocketFactory(File pemFile) {
        X509CertificateChain chain;
        log.debug("Working on file " + pemFile.getAbsolutePath());
        log.debug("Print input pem file");
        FileReader fr = null;
        try {
            fr = new FileReader(pemFile);
        }
        catch (FileNotFoundException e) {
            log.debug("FileNotFoundException riguardo al file " + pemFile.getAbsolutePath());
            throw new RuntimeException(e);
        }
        BufferedReader br = new BufferedReader(fr);
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                log.debug(line);
            }
        }
        catch (IOException e) {
            log.debug("Exception reading  and logging " + pemFile.getAbsolutePath());
        }
        try {
            chain = SSLUtil.readPemCertificateAndKey(pemFile);
            log.debug("Print chain");
            log.debug(chain);
        }
        catch (InvalidKeySpecException ex) {
            throw new RuntimeException("failed to read RSA private key from " + pemFile, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("BUG: failed to create empty KeyStore", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("failed to read certificate file " + pemFile, ex);
        }
        catch (CertificateException ex) {
            throw new RuntimeException("failed to load certificate from file " + pemFile, ex);
        }
        SSLSocketFactory socketFactory = null;
        try {
            socketFactory = SSLUtil.getSocketFactory(chain);
        }
        catch (Exception e) {
            log.debug("GGGGGGGGGGGGGGGGG Errore");
            throw new RuntimeException(e);
        }
        return socketFactory;
    }

    public static SSLSocketFactory getSocketFactory(Subject s) {
        X509CertificateChain chain = null;
        log.debug("SB: getting socket factory bt subject with subject ");
        log.debug(s);
        if (s != null) {
            Set<X509CertificateChain> certs = s.getPublicCredentials(X509CertificateChain.class);
            log.debug("Certs = ");
            log.debug(certs);
            for (X509CertificateChain cc : certs) {
                if (cc.getKey() == null) continue;
                chain = cc;
                break;
            }
        }
        log.debug(" CHAIN:");
        log.debug(chain);
        if (chain == null) {
            log.debug("Returning chain null");
            return null;
        }
        SSLSocketFactory socketFactory = null;
        try {
            socketFactory = SSLUtil.getSocketFactory(chain);
        }
        catch (Exception e) {
            log.debug("HHHHHHHHHHHHHHH Errore");
            throw new RuntimeException(e);
        }
        log.debug("Returning socketFactory = ");
        log.debug(socketFactory);
        return socketFactory;
    }

    public static SSLSocketFactory getSocketFactory(X509CertificateChain chain) {
        KeyStore ts = null;
        KeyStore ks = null;
        log.debug(" SB sono in getSocketFactory");
        log.debug("SB Stampo il parametro chain: ");
        log.debug(chain);
        log.debug(chain.getChain());
        if (chain != null) {
            log.debug(" SB Chain not null");
            try {
                ks = SSLUtil.getKeyStore(chain.getChain(), chain.getPrivateKey());
            }
            catch (Exception e) {
                log.debug("Eccezione in getKeyStore");
                throw new RuntimeException(e);
            }
        }
        SSLSocketFactory socketFactory = null;
        try {
            socketFactory = SSLUtil.getSocketFactory(ks, ts);
        }
        catch (Exception e) {
            log.debug("FFFFFFFFFFFFFFFFFFFF Errore");
            throw new RuntimeException(e);
        }
        return socketFactory;
    }

    public static Subject createSubject(File certFile, File keyFile) {
        try {
            PrivateKey pk = SSLUtil.readPrivateKey(keyFile);
            X509Certificate[] chain = SSLUtil.readCertificateChain(certFile);
            return AuthenticationUtil.getSubject(chain, pk);
        }
        catch (InvalidKeySpecException ex) {
            throw new RuntimeException("failed to read RSA private key from " + keyFile, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("BUG: failed to create empty KeyStore", ex);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("failed to find certificate and/or key file " + certFile + "," + keyFile, ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("failed to read certificate file " + certFile, ex);
        }
        catch (CertificateException ex) {
            throw new RuntimeException("failed to load certificate from file " + certFile, ex);
        }
    }

    public static Subject createSubject(File certKeyFile) {
        try {
            X509CertificateChain certKey = SSLUtil.readPemCertificateAndKey(certKeyFile);
            return AuthenticationUtil.getSubject(certKey);
        }
        catch (InvalidKeySpecException ex) {
            throw new RuntimeException("failed to read RSA private key from " + certKeyFile, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("BUG: failed to create empty KeyStore", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("failed to read certificate file " + certKeyFile, ex);
        }
        catch (CertificateException ex) {
            throw new RuntimeException("failed to load certificate from file " + certKeyFile, ex);
        }
    }

    static SSLSocketFactory getSocketFactory(KeyStore keyStore, KeyStore trustStore) {
        SSLSocketFactory sf = null;
        try {
            KeyManagerFactory kmf = SSLUtil.getKeyManagerFactory(keyStore);
            TrustManagerFactory tmf = SSLUtil.getTrustManagerFactory(trustStore);
            SSLContext ctx = SSLUtil.getContext(kmf, tmf, keyStore);
            sf = ctx.getSocketFactory();
        }
        catch (Exception e) {
            log.debug("exception in getting socket factory from keyStore and trustStore");
        }
        return sf;
    }

    static byte[] getPrivateKey(byte[] certBuf) throws IOException {
        BufferedReader rdr = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(certBuf)));
        String line = rdr.readLine();
        StringBuilder base64 = new StringBuilder();
        while (line != null) {
            if (line.startsWith("-----BEGIN RSA PRIVATE KEY-")) {
                line = rdr.readLine();
                while (line != null && !line.startsWith("-----END RSA PRIVATE KEY-")) {
                    base64.append(line.trim());
                    line = rdr.readLine();
                }
                line = null;
                continue;
            }
            line = rdr.readLine();
        }
        rdr.close();
        String encoded = base64.toString();
        byte[] ret = Base64.decode(encoded);
        return ret;
    }

    public static byte[] getCertificates(byte[] certBuf) throws IOException {
        BufferedReader rdr = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(certBuf)));
        String line = rdr.readLine();
        ArrayList<byte[]> certs = new ArrayList<byte[]>();
        int byteSize = 0;
        while (line != null) {
            StringBuilder base64 = new StringBuilder();
            if (line.startsWith("-----BEGIN CERTIFICATE-----")) {
                line = rdr.readLine();
                while (line != null && !line.startsWith("-----END CERTIFICATE-----")) {
                    base64.append(line.trim());
                    line = rdr.readLine();
                }
                if (!line.startsWith("-----END CERTIFICATE-----")) continue;
                String encoded = base64.toString();
                byte[] tmp = Base64.decode(encoded);
                byteSize += tmp.length;
                certs.add(tmp);
                continue;
            }
            line = rdr.readLine();
        }
        rdr.close();
        byte[] result = new byte[byteSize];
        byteSize = 0;
        for (byte[] cert : certs) {
            System.arraycopy(cert, 0, result, byteSize, cert.length);
            byteSize += cert.length;
        }
        return result;
    }

    public static X509Certificate[] readCertificateChain(File certFile) throws CertificateException, IOException {
        try {
            X509Certificate[] chain = SSLUtil.readCertificateChain(FileUtil.readFile(certFile));
            log.debug("X509 certificate is valid");
            return chain;
        }
        catch (CertificateException ex) {
            throw new RuntimeException("certificate from file " + certFile + " is not valid", ex);
        }
    }

    public static X509Certificate[] readCertificateChain(byte[] certBuf) throws CertificateException, IOException {
        BufferedInputStream istream = new BufferedInputStream(new ByteArrayInputStream(certBuf));
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        while (istream.available() > 0) {
            Certificate cert = cf.generateCertificate(istream);
            certs.add(cert);
        }
        istream.close();
        X509Certificate[] chain = new X509Certificate[certs.size()];
        Iterator i = certs.iterator();
        int c = 0;
        while (i.hasNext()) {
            X509Certificate x509 = (X509Certificate)i.next();
            chain[c++] = x509;
            try {
                x509.checkValidity();
                log.debug("X509 certificate is valid");
            }
            catch (CertificateExpiredException exp) {
                log.debug("X509 certificate is expired");
            }
            catch (CertificateException ex) {
                throw new RuntimeException("certificate byte array is not valid", ex);
            }
        }
        return chain;
    }

    public static PrivateKey readPrivateKey(File keyFile) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        byte[] priv = FileUtil.readFile(keyFile);
        return SSLUtil.readPrivateKey(priv);
    }

    public static PrivateKey readPrivateKey(byte[] bytesPrivateKey) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytesPrivateKey);
        PrivateKey pk = kf.generatePrivate(spec);
        return pk;
    }

    private static KeyStore getKeyStore(Certificate[] chain, PrivateKey pk) {
        try {
            KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
            try {
                ks.load(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ks.setKeyEntry(CERT_ALIAS, pk, THE_PASSWORD, chain);
            log.debug("added certificate chain to keystore: opencadc_x509," + pk + "," + THE_PASSWORD + "," + chain);
            return ks;
        }
        catch (KeyStoreException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof NoSuchAlgorithmException) {
                throw new IllegalArgumentException("Sorry, this implementation of Java, issued by " + System.getProperty("java.vendor") + ", does not support CADC Certificates.");
            }
            throw new RuntimeException("failed to find/load KeyStore of type JKS", ex);
        }
    }

    private static KeyStore getKeyStore(File certFile, File keyFile) {
        log.debug("Sono in getKeyStore");
        log.debug("certFile = " + certFile.getAbsolutePath());
        log.debug("keyFile = " + keyFile.getAbsolutePath());
        try {
            PrivateKey pk = SSLUtil.readPrivateKey(keyFile);
            Certificate[] chain = SSLUtil.readCertificateChain(certFile);
            return SSLUtil.getKeyStore(chain, pk);
        }
        catch (InvalidKeySpecException ex) {
            throw new RuntimeException("failed to read RSA private key from " + keyFile, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("BUG: failed to create empty KeyStore", ex);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("failed to find certificate and/or key file " + certFile + "," + keyFile, ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("failed to read certificate file " + certFile, ex);
        }
        catch (CertificateException ex) {
            throw new RuntimeException("failed to load certificate from file " + certFile, ex);
        }
    }

    private static KeyStore readPKCS12(File f) {
        log.debug("Sto leggendo il keystore. File: " + f.getAbsolutePath());
        FileInputStream istream = null;
        try {
            istream = new FileInputStream(f);
            KeyStore ks = KeyStore.getInstance("PKCS12");
            log.debug("assume a non-password-protected proxy cert");
            ks.load(istream, THE_PASSWORD);
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException("failed to find KeyStore for JKS", ex);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("failed to find key store file " + f, ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("failed to read key store file " + f, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("failed to check integtrity of key store file " + f, ex);
        }
        catch (CertificateException ex) {
            throw new RuntimeException("failed to load proxy certificate(s) from key store file " + f, ex);
        }
        finally {
            try {
                ((InputStream)istream).close();
            }
            catch (Throwable throwable) {}
        }
    }

    private static KeyManagerFactory getKeyManagerFactory(KeyStore keyStore) {
        String da = KEYMANAGER_ALGORITHM;
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(da);
            kmf.init(keyStore, THE_PASSWORD);
            return kmf;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("failed to find KeyManagerFactory for " + da, ex);
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException("failed to init KeyManagerFactory", ex);
        }
        catch (UnrecoverableKeyException ex) {
            throw new RuntimeException("failed to init KeyManagerFactory", ex);
        }
    }

    private static TrustManagerFactory getTrustManagerFactory(KeyStore trustStore) {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX", "SunJSSE");
            tmf.init(trustStore);
            return tmf;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("BUG: failed to create TrustManagerFactory for algorithm=PKIX", ex);
        }
        catch (NoSuchProviderException ex) {
            throw new RuntimeException("BUG: failed to create TrustManagerFactory for provider=SunJSSE", ex);
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException("failed to init trustManagerFactory", ex);
        }
    }

    private static SSLContext getContext(KeyManagerFactory kmf, TrustManagerFactory tmf, KeyStore ks) {
        try {
            KeyManager[] kms = kmf.getKeyManagers();
            for (int i = 0; i < kms.length; ++i) {
                BasicX509KeyManager wrapper = new BasicX509KeyManager((X509KeyManager)kms[i], CERT_ALIAS);
                kms[i] = wrapper;
            }
            TrustManager[] tms = tmf.getTrustManagers();
            for (int i = 0; i < tms.length; ++i) {
                BasicX509TrustManager wrapper = new BasicX509TrustManager((X509TrustManager)tms[i]);
                tms[i] = wrapper;
            }
            SSLContext ctx = SSLContext.getInstance(SSL_PROTOCOL);
            log.debug("KMF returned " + kms.length + " KeyManagers");
            log.debug("TMF returned " + tms.length + " TrustManagers");
            ctx.init(kms, tms, null);
            return ctx;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("failed to find SSLContext for TLS", ex);
        }
        catch (KeyManagementException ex) {
            throw new RuntimeException("failed to init SSLContext", ex);
        }
    }

    private static void printKeyStoreInfo(KeyStore keystore) throws KeyStoreException {
        log.debug("Provider : " + keystore.getProvider().getName());
        log.debug("Type : " + keystore.getType());
        log.debug("Size : " + keystore.size());
        Enumeration<String> en = keystore.aliases();
        while (en.hasMoreElements()) {
            System.out.println("Alias: " + en.nextElement());
        }
    }

    public static X509CertificateChain readPemCertificateAndKey(File pemFile) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException, CertificateException {
        log.debug("SB: Trying to read pem file:");
        log.debug(pemFile);
        byte[] data = FileUtil.readFile(pemFile);
        return SSLUtil.readPemCertificateAndKey(data);
    }

    public static X509CertificateChain readPemCertificateAndKey(byte[] data) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException, CertificateException {
        log.debug("SB:  sono in readPemCertificateAndKey(byte[] data)");
        byte[] key = SSLUtil.getPrivateKey(data);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        RSAPrivateCrtKeySpec spec = SSLUtil.parseKeySpec(key);
        PrivateKey pk = kf.generatePrivate(spec);
        byte[] certificates = SSLUtil.getCertificates(data);
        X509Certificate[] chain = SSLUtil.readCertificateChain(certificates);
        return new X509CertificateChain(chain, pk);
    }

    public static RSAPrivateCrtKeySpec parseKeySpec(byte[] code) throws IOException {
        DerParser parser = new DerParser(code);
        Asn1Object sequence = parser.read();
        if (sequence.getType() != 16) {
            throw new IOException("Invalid DER: not a sequence");
        }
        parser = sequence.getParser();
        parser.read();
        BigInteger modulus = parser.read().getInteger();
        BigInteger publicExp = parser.read().getInteger();
        BigInteger privateExp = parser.read().getInteger();
        BigInteger prime1 = parser.read().getInteger();
        BigInteger prime2 = parser.read().getInteger();
        BigInteger exp1 = parser.read().getInteger();
        BigInteger exp2 = parser.read().getInteger();
        BigInteger crtCoef = parser.read().getInteger();
        RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
        return keySpec;
    }

    private static String buildPEM(String certChainStr, byte[] bytesPrivateKey) {
        if (certChainStr == null || bytesPrivateKey == null) {
            throw new RuntimeException("Cannot build PEM of cert & privateKey. An argument is null.");
        }
        int posCertEnd = certChainStr.indexOf("-----END CERTIFICATE-----");
        if (posCertEnd == -1) {
            throw new RuntimeException("Cannot find END mark of certificate.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN RSA PRIVATE KEY-----");
        sb.append(X509CertificateChain.NEW_LINE);
        sb.append(Base64.encodeLines64(bytesPrivateKey));
        sb.append("-----END RSA PRIVATE KEY-----");
        String privateKeyStr = sb.toString();
        int posSecondCertStart = certChainStr.indexOf("-----BEGIN CERTIFICATE-----", posCertEnd);
        if (posSecondCertStart == -1) {
            return certChainStr + X509CertificateChain.NEW_LINE + privateKeyStr;
        }
        String certStrPart1 = certChainStr.substring(0, posSecondCertStart);
        String certStrPart2 = certChainStr.substring(posSecondCertStart);
        return certStrPart1 + privateKeyStr + X509CertificateChain.NEW_LINE + certStrPart2;
    }

    public static void validateSubject(Subject subject, Date date) throws CertificateException, CertificateExpiredException, CertificateNotYetValidException {
        if (subject != null) {
            Set<X509CertificateChain> certs = subject.getPublicCredentials(X509CertificateChain.class);
            if (certs.size() == 0) {
                throw new CertificateException("No certificates associated with subject");
            }
            X509CertificateChain chain = certs.iterator().next();
            for (X509Certificate c : chain.getChain()) {
                if (date != null) {
                    c.checkValidity(date);
                    continue;
                }
                c.checkValidity();
            }
        }
    }
}

