/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AuthMethod {
    ANON("anon"),
    CERT("cert"),
    COOKIE("cookie"),
    PASSWORD("password"),
    TOKEN("token");

    private static final Map<AuthMethod, URI> SEC_MAP;
    private final String value;

    private AuthMethod(String s) {
        this.value = s;
    }

    public static AuthMethod getAuthMethod(String s) {
        for (AuthMethod am : AuthMethod.values()) {
            if (!am.value.equals(s)) continue;
            return am;
        }
        throw new IllegalArgumentException("invalid value: " + s);
    }

    public static AuthMethod getAuthMethod(URI securityMethod) {
        for (Map.Entry<AuthMethod, URI> me : SEC_MAP.entrySet()) {
            if (!me.getValue().equals(securityMethod)) continue;
            return me.getKey();
        }
        throw new IllegalArgumentException("invalid value: " + securityMethod);
    }

    public String getValue() {
        return this.value;
    }

    public URI getSecurityMethod() {
        return SEC_MAP.get((Object)this);
    }

    public String toString() {
        return "AuthMethod[" + this.value + "]";
    }

    static {
        SEC_MAP = new HashMap<AuthMethod, URI>();
        try {
            SEC_MAP.put(ANON, new URI("ivo://ivoa.net/sso#anon"));
            SEC_MAP.put(CERT, new URI("ivo://ivoa.net/sso#tls-with-certficate"));
            SEC_MAP.put(COOKIE, new URI("ivo://ivoa.net/sso#cookie"));
            SEC_MAP.put(PASSWORD, new URI("http://www.w3.org/Protocols/HTTP/1.0/spec.html#BasicAA"));
            SEC_MAP.put(TOKEN, new URI("ivo://cadc.nrc.ca/auth#delegation-token"));
        }
        catch (URISyntaxException bug) {
            throw new RuntimeException("BUG: invalid URI in static constants", bug);
        }
    }
}

