/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.xml;

import ca.nrc.cadc.ac.ReaderException;
import ca.nrc.cadc.ac.User;
import ca.nrc.cadc.ac.xml.AbstractReaderWriter;
import ca.nrc.cadc.xml.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserListReader
extends AbstractReaderWriter {
    public List<User<Principal>> read(String xml) throws ReaderException, IOException, URISyntaxException {
        if (xml == null) {
            throw new IllegalArgumentException("XML must not be null");
        }
        return this.read(new StringReader(xml));
    }

    public List<User<Principal>> read(InputStream in) throws ReaderException, IOException {
        InputStreamReader reader;
        if (in == null) {
            throw new IOException("stream closed");
        }
        try {
            reader = new InputStreamReader(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported");
        }
        return this.read(reader);
    }

    public List<User<Principal>> read(Reader reader) throws ReaderException, IOException {
        Document document;
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        try {
            document = XmlUtil.buildDocument(reader);
        }
        catch (JDOMException jde) {
            String error = "XML failed validation: " + jde.getMessage();
            throw new ReaderException(error, jde);
        }
        Element root = document.getRootElement();
        String userElemName = root.getName();
        if (!userElemName.equalsIgnoreCase("users")) {
            String error = "Expected users element, found " + userElemName;
            throw new ReaderException(error);
        }
        return this.getUserList(root);
    }

    protected final List<User<Principal>> getUserList(Element element) throws ReaderException {
        ArrayList<User<Principal>> users = new ArrayList<User<Principal>>();
        List<Element> userElements = element.getChildren("user");
        for (Element userElement : userElements) {
            users.add(this.getUser(userElement));
        }
        return users;
    }
}

