/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.xml;

import ca.nrc.cadc.ac.Group;
import ca.nrc.cadc.ac.GroupProperty;
import ca.nrc.cadc.ac.PersonalDetails;
import ca.nrc.cadc.ac.PosixDetails;
import ca.nrc.cadc.ac.ReaderException;
import ca.nrc.cadc.ac.User;
import ca.nrc.cadc.ac.UserDetails;
import ca.nrc.cadc.ac.UserRequest;
import ca.nrc.cadc.ac.WriterException;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.DNPrincipal;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.IdentityType;
import ca.nrc.cadc.auth.NumericPrincipal;
import ca.nrc.cadc.auth.OpenIdPrincipal;
import ca.nrc.cadc.date.DateUtil;
import java.io.IOException;
import java.io.Writer;
import java.security.Principal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReaderWriter {
    protected void write(Element root, Writer writer) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        outputter.output(new Document(root), writer);
    }

    protected final User<Principal> getUser(Element element) throws ReaderException {
        Element detailsElement;
        Element userIDElement = element.getChild("userID");
        if (userIDElement == null) {
            String error = "userID element not found in user element";
            throw new ReaderException(error);
        }
        Element userIDIdentityElement = userIDElement.getChild("identity");
        if (userIDIdentityElement == null) {
            String error = "identity element not found in userID element";
            throw new ReaderException(error);
        }
        Principal userID = this.getPrincipal(userIDIdentityElement);
        User<Principal> user = new User<Principal>(userID);
        Element identitiesElement = element.getChild("identities");
        if (identitiesElement != null) {
            List<Element> identityElements = identitiesElement.getChildren("identity");
            for (Element identityElement : identityElements) {
                user.getIdentities().add(this.getPrincipal(identityElement));
            }
        }
        if ((detailsElement = element.getChild("details")) != null) {
            List<Element> userDetailsElements = detailsElement.getChildren("userDetails");
            for (Element userDetailsElement : userDetailsElements) {
                user.details.add(this.getUserDetails(userDetailsElement));
            }
        }
        return user;
    }

    protected final UserRequest<Principal> getUserRequest(Element element) throws ReaderException {
        Element userElement = element.getChild("user");
        if (userElement == null) {
            String error = "user element not found in userRequest element";
            throw new ReaderException(error);
        }
        User<Principal> user = this.getUser(userElement);
        Element passwordElement = element.getChild("password");
        if (passwordElement == null) {
            String error = "password element not found in userRequest element";
            throw new ReaderException(error);
        }
        String password = passwordElement.getText();
        return new UserRequest<Principal>(user, password.toCharArray());
    }

    protected final Principal getPrincipal(Element element) throws ReaderException {
        Principal principal;
        if (element == null) {
            String error = "null identity element";
            throw new ReaderException(error);
        }
        if (!element.getName().equals("identity")) {
            String error = "expected identity element name, found " + element.getName();
            throw new ReaderException(error);
        }
        String type = element.getAttributeValue("type");
        if (type == null) {
            String error = "type attribute not found in identity element" + element.getName();
            throw new ReaderException(error);
        }
        String identity = element.getText();
        if (type.equals(IdentityType.OPENID.getValue())) {
            principal = new OpenIdPrincipal(identity);
        } else if (type.equals(IdentityType.CADC.getValue())) {
            Integer cadcID;
            try {
                cadcID = Integer.valueOf(identity);
            }
            catch (NumberFormatException e) {
                String error = "Non-integer cadcID: " + identity;
                throw new ReaderException(error);
            }
            principal = new NumericPrincipal(cadcID);
        } else if (type.equals(IdentityType.USERNAME.getValue())) {
            principal = new HttpPrincipal(identity);
        } else if (type.equals(IdentityType.X500.getValue())) {
            principal = new X500Principal(identity);
        } else if (type.equals(IdentityType.ENTRY_DN.getValue())) {
            principal = new DNPrincipal(identity);
        } else {
            String error = "Unknown type attribute: " + type;
            throw new ReaderException(error);
        }
        return principal;
    }

    protected final UserDetails getUserDetails(Element element) throws ReaderException {
        if (element == null) {
            throw new ReaderException("null UserDetails");
        }
        if (!element.getName().equals("userDetails")) {
            String error = "expected element name userDetails, found " + element.getName();
            throw new ReaderException(error);
        }
        String type = element.getAttributeValue("type");
        if (type == null) {
            String error = "userDetails missing required attribute type";
            throw new ReaderException(error);
        }
        if (type.equals("posixDetails")) {
            return this.getPosixDetails(element);
        }
        if (type.equals("personalDetails")) {
            return this.getPersonalDetails(element);
        }
        String error = "Unknown UserDetails attribute type " + type;
        throw new ReaderException(error);
    }

    protected final PosixDetails getPosixDetails(Element element) throws ReaderException {
        long gid;
        long uid;
        Element uidElement = element.getChild("uid");
        if (uidElement == null) {
            String error = "posixDetails missing required element uid";
            throw new ReaderException(error);
        }
        try {
            uid = Long.valueOf(uidElement.getText());
        }
        catch (NumberFormatException e) {
            String error = "Cannot parse posixDetails uid to a long";
            throw new ReaderException(error);
        }
        Element gidElement = element.getChild("gid");
        if (gidElement == null) {
            String error = "posixDetails missing required element gid";
            throw new ReaderException(error);
        }
        try {
            gid = Long.valueOf(gidElement.getText());
        }
        catch (NumberFormatException e) {
            String error = "Cannot parse posixDetails gid to a long";
            throw new ReaderException(error);
        }
        Element homeDirElement = element.getChild("homeDirectory");
        if (homeDirElement == null) {
            String error = "posixDetails missing required element homeDirectory";
            throw new ReaderException(error);
        }
        String homeDirectory = homeDirElement.getText();
        return new PosixDetails(uid, gid, homeDirectory);
    }

    protected final PersonalDetails getPersonalDetails(Element element) throws ReaderException {
        Element countryElement;
        Element cityElement;
        Element instituteElement;
        Element addressElement;
        Element firstNameElement = element.getChild("firstName");
        if (firstNameElement == null) {
            String error = "personalDetails missing required element firstName";
            throw new ReaderException(error);
        }
        String firstName = firstNameElement.getText();
        Element lastNameElement = element.getChild("lastName");
        if (lastNameElement == null) {
            String error = "personalDetails missing required element lastName";
            throw new ReaderException(error);
        }
        String lastName = lastNameElement.getText();
        PersonalDetails details = new PersonalDetails(firstName, lastName);
        Element emailElement = element.getChild("email");
        if (emailElement != null) {
            details.email = emailElement.getText();
        }
        if ((addressElement = element.getChild("address")) != null) {
            details.address = addressElement.getText();
        }
        if ((instituteElement = element.getChild("institute")) != null) {
            details.institute = instituteElement.getText();
        }
        if ((cityElement = element.getChild("city")) != null) {
            details.city = cityElement.getText();
        }
        if ((countryElement = element.getChild("country")) != null) {
            details.country = countryElement.getText();
        }
        return details;
    }

    protected final Group getGroup(Element element) throws ReaderException {
        Element element2;
        Element element3;
        Element userMembersElement;
        Element groupMembersElement;
        Element propertiesElement;
        Element lastModifiedElement;
        String uri = element.getAttributeValue("uri");
        if (uri == null) {
            String error = "group missing required uri attribute";
            throw new ReaderException(error);
        }
        int index = uri.indexOf("ivo://cadc.nrc.ca/gms#");
        if (index == -1) {
            String error = "group uri attribute malformed: " + uri;
            throw new ReaderException(error);
        }
        String groupID = uri.substring("ivo://cadc.nrc.ca/gms#".length());
        User<Principal> user = null;
        Element ownerElement = element.getChild("owner");
        if (ownerElement != null) {
            Element userElement = ownerElement.getChild("user");
            if (userElement == null) {
                String error = "owner missing required user element";
                throw new ReaderException(error);
            }
            user = this.getUser(userElement);
        }
        Group group = new Group(groupID, user);
        Element descriptionElement = element.getChild("description");
        if (descriptionElement != null) {
            group.description = descriptionElement.getText();
        }
        if ((lastModifiedElement = element.getChild("lastModified")) != null) {
            try {
                DateFormat df = DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", DateUtil.UTC);
                group.lastModified = df.parse(lastModifiedElement.getText());
            }
            catch (ParseException e) {
                String error = "Unable to parse group lastModified because " + e.getMessage();
                throw new ReaderException(error);
            }
        }
        if ((propertiesElement = element.getChild("properties")) != null) {
            List<Element> propertyElements = propertiesElement.getChildren("property");
            for (Element element4 : propertyElements) {
                group.getProperties().add(this.getGroupProperty(element4));
            }
        }
        if ((groupMembersElement = element.getChild("groupMembers")) != null) {
            List<Element> groupElements = groupMembersElement.getChildren("group");
            for (Element element5 : groupElements) {
                group.getGroupMembers().add(this.getGroup(element5));
            }
        }
        if ((userMembersElement = element.getChild("userMembers")) != null) {
            List<Element> list = userMembersElement.getChildren("user");
            for (Element element6 : list) {
                group.getUserMembers().add(this.getUser(element6));
            }
        }
        if ((element3 = element.getChild("groupAdmins")) != null) {
            List<Element> list = element3.getChildren("group");
            for (Element groupMember : list) {
                group.getGroupAdmins().add(this.getGroup(groupMember));
            }
        }
        if ((element2 = element.getChild("userAdmins")) != null) {
            List<Element> list = element2.getChildren("user");
            for (Element userMember : list) {
                group.getUserAdmins().add(this.getUser(userMember));
            }
        }
        return group;
    }

    protected final GroupProperty getGroupProperty(Element element) throws ReaderException {
        Object value;
        if (element == null) {
            String error = "null property element";
            throw new ReaderException(error);
        }
        if (!element.getName().equals("property")) {
            String error = "expected property element name, found " + element.getName();
            throw new ReaderException(error);
        }
        String key = element.getAttributeValue("key");
        if (key == null) {
            String error = "required key attribute not found";
            throw new ReaderException(error);
        }
        String type = element.getAttributeValue("type");
        if (type == null) {
            String error = "required type attribute not found";
            throw new ReaderException(error);
        }
        if (type.equals("String")) {
            value = String.valueOf(element.getText());
        } else if (type.equals("Integer")) {
            value = Integer.valueOf(element.getText());
        } else {
            String error = "Unsupported GroupProperty type: " + type;
            throw new ReaderException(error);
        }
        Boolean readOnly = Boolean.valueOf(element.getAttributeValue("readOnly"));
        return new GroupProperty(key, value, readOnly);
    }

    protected final Element getElement(User<? extends Principal> user) throws WriterException {
        Element userElement = new Element("user");
        Element userIDElement = new Element("userID");
        userIDElement.addContent(this.getElement(user.getUserID()));
        userElement.addContent(userIDElement);
        Set<Principal> identities = user.getIdentities();
        if (identities.size() > 1) {
            Element identitiesElement = new Element("identities");
            for (Principal identity : identities) {
                if (AuthenticationUtil.equals(identity, user.getUserID())) continue;
                identitiesElement.addContent(this.getElement(identity));
            }
            userElement.addContent(identitiesElement);
        }
        if (!user.details.isEmpty()) {
            Element detailsElement = new Element("details");
            Set<UserDetails> userDetails = user.details;
            for (UserDetails userDetail : userDetails) {
                detailsElement.addContent(this.getElement(userDetail));
            }
            userElement.addContent(detailsElement);
        }
        return userElement;
    }

    protected final Element getElement(UserRequest<? extends Principal> userRequest) throws WriterException {
        Element userRequestElement = new Element("userRequest");
        Element userElement = this.getElement(userRequest.getUser());
        userRequestElement.addContent(userElement);
        Element passwordElement = new Element("password");
        passwordElement.setText(String.valueOf(userRequest.getPassword()));
        userRequestElement.addContent(passwordElement);
        return userRequestElement;
    }

    protected final Element getElement(Principal identity) throws WriterException {
        if (identity == null) {
            String error = "null identity";
            throw new WriterException(error);
        }
        Element identityElement = new Element("identity");
        if (identity instanceof HttpPrincipal) {
            identityElement.setAttribute("type", IdentityType.USERNAME.getValue());
        } else if (identity instanceof NumericPrincipal) {
            identityElement.setAttribute("type", IdentityType.CADC.getValue());
        } else if (identity instanceof OpenIdPrincipal) {
            identityElement.setAttribute("type", IdentityType.OPENID.getValue());
        } else if (identity instanceof X500Principal) {
            identityElement.setAttribute("type", IdentityType.X500.getValue());
        } else if (identity instanceof DNPrincipal) {
            identityElement.setAttribute("type", IdentityType.ENTRY_DN.getValue());
        } else {
            String error = "Unsupported Principal type " + identity.getClass().getSimpleName();
            throw new IllegalArgumentException(error);
        }
        identityElement.setText(identity.getName());
        return identityElement;
    }

    protected final Element getElement(UserDetails details) throws WriterException {
        if (details == null) {
            throw new WriterException("null UserDetails");
        }
        if (details instanceof PosixDetails) {
            return this.getElement((PosixDetails)details);
        }
        if (details instanceof PersonalDetails) {
            return this.getElement((PersonalDetails)details);
        }
        String error = "Unknown UserDetails implementation: " + details.getClass().getName();
        throw new WriterException(error);
    }

    protected final Element getElement(PosixDetails details) {
        Element detailsElement = new Element("userDetails");
        detailsElement.setAttribute("type", "posixDetails");
        Element uidElement = new Element("uid");
        uidElement.setText(String.valueOf(details.getUid()));
        detailsElement.addContent(uidElement);
        Element gidElement = new Element("gid");
        gidElement.setText(String.valueOf(details.getGid()));
        detailsElement.addContent(gidElement);
        Element homeDirElement = new Element("homeDirectory");
        homeDirElement.setText(details.getHomeDirectory());
        detailsElement.addContent(homeDirElement);
        return detailsElement;
    }

    protected final Element getElement(PersonalDetails details) {
        Element detailsElement = new Element("userDetails");
        detailsElement.setAttribute("type", "personalDetails");
        Element firstNameElement = new Element("firstName");
        firstNameElement.setText(details.getFirstName());
        detailsElement.addContent(firstNameElement);
        Element lastNameElement = new Element("lastName");
        lastNameElement.setText(details.getLastName());
        detailsElement.addContent(lastNameElement);
        if (details.email != null) {
            Element emailElement = new Element("email");
            emailElement.setText(details.email);
            detailsElement.addContent(emailElement);
        }
        if (details.address != null) {
            Element addressElement = new Element("address");
            addressElement.setText(details.address);
            detailsElement.addContent(addressElement);
        }
        if (details.institute != null) {
            Element instituteElement = new Element("institute");
            instituteElement.setText(details.institute);
            detailsElement.addContent(instituteElement);
        }
        if (details.city != null) {
            Element cityElement = new Element("city");
            cityElement.setText(details.city);
            detailsElement.addContent(cityElement);
        }
        if (details.country != null) {
            Element countryElement = new Element("country");
            countryElement.setText(details.country);
            detailsElement.addContent(countryElement);
        }
        return detailsElement;
    }

    protected final Element getElement(Group group) throws WriterException {
        return this.getElement(group, true);
    }

    protected final Element getElement(Group group, boolean deepCopy) throws WriterException {
        Element groupElement = new Element("group");
        String groupURI = "ivo://cadc.nrc.ca/gms#" + group.getID();
        groupElement.setAttribute(new Attribute("uri", groupURI));
        if (group.getOwner() != null) {
            Element ownerElement = new Element("owner");
            Element userElement = this.getElement(group.getOwner());
            ownerElement.addContent(userElement);
            groupElement.addContent(ownerElement);
        }
        if (deepCopy) {
            if (group.description != null) {
                Element descriptionElement = new Element("description");
                descriptionElement.setText(group.description);
                groupElement.addContent(descriptionElement);
            }
            if (group.lastModified != null) {
                Element lastModifiedElement = new Element("lastModified");
                DateFormat df = DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", DateUtil.UTC);
                lastModifiedElement.setText(df.format(group.lastModified));
                groupElement.addContent(lastModifiedElement);
            }
            if (!group.getProperties().isEmpty()) {
                Element propertiesElement = new Element("properties");
                for (GroupProperty groupProperty : group.getProperties()) {
                    propertiesElement.addContent(this.getElement(groupProperty));
                }
                groupElement.addContent(propertiesElement);
            }
            if (group.getGroupMembers() != null && !group.getGroupMembers().isEmpty()) {
                Element groupMembersElement = new Element("groupMembers");
                for (Group group2 : group.getGroupMembers()) {
                    groupMembersElement.addContent(this.getElement(group2, false));
                }
                groupElement.addContent(groupMembersElement);
            }
            if (group.getUserMembers() != null && !group.getUserMembers().isEmpty()) {
                Element userMembersElement = new Element("userMembers");
                for (User user : group.getUserMembers()) {
                    userMembersElement.addContent(this.getElement(user));
                }
                groupElement.addContent(userMembersElement);
            }
            if (group.getGroupAdmins() != null && !group.getGroupAdmins().isEmpty()) {
                Element groupAdminsElement = new Element("groupAdmins");
                for (Group group3 : group.getGroupAdmins()) {
                    groupAdminsElement.addContent(this.getElement(group3, false));
                }
                groupElement.addContent(groupAdminsElement);
            }
            if (group.getUserAdmins() != null && !group.getUserAdmins().isEmpty()) {
                Element userAdminsElement = new Element("userAdmins");
                for (User user : group.getUserAdmins()) {
                    userAdminsElement.addContent(this.getElement(user));
                }
                groupElement.addContent(userAdminsElement);
            }
        }
        return groupElement;
    }

    protected final Element getElement(GroupProperty property) throws WriterException {
        Object value;
        if (property == null) {
            throw new WriterException("null GroupProperty");
        }
        Element propertyElement = new Element("property");
        propertyElement.setAttribute("key", property.getKey());
        if (property.isReadOnly()) {
            propertyElement.setAttribute("readOnly", "true");
        }
        if ((value = property.getValue()) instanceof String) {
            propertyElement.setAttribute("type", "String");
        } else if (value instanceof Integer) {
            propertyElement.setAttribute("type", "Integer");
        } else {
            String error = "Unsupported value type: " + value.getClass().getSimpleName();
            throw new IllegalArgumentException(error);
        }
        propertyElement.setText(String.valueOf(property.getValue()));
        return propertyElement;
    }
}

