/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.json;

import ca.nrc.cadc.ac.ReaderException;
import ca.nrc.cadc.ac.UserRequest;
import ca.nrc.cadc.ac.xml.UserRequestReader;
import ca.nrc.cadc.xml.JsonInputter;
import java.io.IOException;
import java.io.Reader;
import java.security.Principal;
import java.util.Scanner;
import org.jdom2.Document;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUserRequestReader
extends UserRequestReader {
    @Override
    public UserRequest<Principal> read(Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        Scanner s = new Scanner(reader).useDelimiter("\\A");
        String json = s.hasNext() ? s.next() : "";
        try {
            JsonInputter jsonInputter = new JsonInputter();
            jsonInputter.getListElementMap().put("identities", "identity");
            jsonInputter.getListElementMap().put("details", "userDetails");
            Document document = jsonInputter.input(json);
            return this.getUserRequest(document.getRootElement());
        }
        catch (JSONException e) {
            String error = "Unable to parse JSON to User because " + e.getMessage();
            throw new ReaderException(error, e);
        }
    }
}

