/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.client;

import ca.nrc.cadc.ac.User;
import ca.nrc.cadc.ac.xml.UserReader;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.NumericPrincipal;
import ca.nrc.cadc.net.HttpDownload;
import ca.nrc.cadc.net.NetUtil;
import java.io.ByteArrayOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserClient {
    private static final Logger log = Logger.getLogger(UserClient.class);
    private String baseURL;

    public UserClient(String baseURL) throws IllegalArgumentException {
        if (baseURL == null) {
            throw new IllegalArgumentException("baseURL is required");
        }
        try {
            new URL(baseURL);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL is malformed: " + e.getMessage());
        }
        this.baseURL = baseURL.endsWith("/") ? baseURL.substring(0, baseURL.length() - 1) : baseURL;
    }

    public void augmentSubject(Subject subject) {
        Principal principal = this.getPrincipal(subject);
        if (principal != null) {
            URL url = this.getURL(principal);
            log.debug("augmentSubject request to " + url.toString());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            HttpDownload download = new HttpDownload(url, out);
            download.run();
            int responseCode = download.getResponseCode();
            if (responseCode == 404) {
                return;
            }
            if (responseCode != 200) {
                String message = "Error calling /ac to augment subject";
                if (download.getThrowable() != null) {
                    throw new IllegalStateException(message, download.getThrowable());
                }
                throw new IllegalStateException(message);
            }
            subject.getPrincipals().clear();
            subject.getPrincipals().addAll(this.getPrincipals(out));
        }
    }

    protected Principal getPrincipal(Subject subject) {
        if (subject == null || subject.getPrincipals() == null || subject.getPrincipals().isEmpty()) {
            return null;
        }
        if (subject.getPrincipals().size() == 1) {
            return subject.getPrincipals().iterator().next();
        }
        Set<X500Principal> x500Principals = subject.getPrincipals(X500Principal.class);
        if (x500Principals.size() > 0) {
            return x500Principals.iterator().next();
        }
        Set<NumericPrincipal> numericPrincipals = subject.getPrincipals(NumericPrincipal.class);
        if (numericPrincipals.size() > 0) {
            return numericPrincipals.iterator().next();
        }
        return subject.getPrincipals().iterator().next();
    }

    protected Set<Principal> getPrincipals(ByteArrayOutputStream out) {
        try {
            String userXML = new String(out.toByteArray(), "UTF-8");
            log.debug("userXML Input to getPrincipals(): " + userXML);
            User<Principal> user = new UserReader().read(userXML);
            return user.getIdentities();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected URL getURL(Principal principal) {
        try {
            String userID = principal.getName();
            URL url = new URL(this.baseURL + "/users/" + NetUtil.encode(userID) + "?idType=" + this.getIdType(principal) + "&detail=identity");
            log.debug("getURL(): returned url = " + url.toString());
            return url;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getIdType(Principal principal) {
        String idTypeStr = AuthenticationUtil.getPrincipalType(principal);
        if (idTypeStr == null) {
            String msg = "Subject has unsupported principal " + principal.getName();
            throw new IllegalArgumentException(msg);
        }
        return idTypeStr;
    }
}

