/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.client;

import ca.nrc.cadc.ac.Group;
import ca.nrc.cadc.ac.GroupAlreadyExistsException;
import ca.nrc.cadc.ac.GroupNotFoundException;
import ca.nrc.cadc.ac.Role;
import ca.nrc.cadc.ac.User;
import ca.nrc.cadc.ac.UserNotFoundException;
import ca.nrc.cadc.ac.client.GroupMemberships;
import ca.nrc.cadc.ac.client.JsonUserListInputStreamWrapper;
import ca.nrc.cadc.ac.xml.GroupListReader;
import ca.nrc.cadc.ac.xml.GroupReader;
import ca.nrc.cadc.ac.xml.GroupWriter;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.SSLUtil;
import ca.nrc.cadc.net.HttpDownload;
import ca.nrc.cadc.net.HttpPost;
import ca.nrc.cadc.net.HttpTransfer;
import ca.nrc.cadc.net.HttpUpload;
import ca.nrc.cadc.net.InputStreamWrapper;
import ca.nrc.cadc.net.NetUtil;
import ca.nrc.cadc.net.event.TransferEvent;
import ca.nrc.cadc.net.event.TransferListener;
import ca.nrc.cadc.reg.client.RegistryClient;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMSClient
implements TransferListener {
    private static final Logger log = Logger.getLogger(GMSClient.class);
    private SSLSocketFactory sslSocketFactory;
    private SSLSocketFactory mySocketFactory;
    private URI serviceURI;
    private String baseURL;
    private int subjectHashCode = 0;

    public GMSClient(URI serviceURI, RegistryClient registryClient) {
        try {
            URL base = registryClient.getServiceURL(serviceURI, "https");
            if (base == null) {
                throw new IllegalArgumentException("service not found with https access: " + serviceURI);
            }
            this.baseURL = base.toExternalForm();
            log.debug("AC Service URI: " + this.baseURL);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("BUG: failed to construct GMS base URL", ex);
        }
    }

    public GMSClient(URI serviceURI) {
        this(serviceURI, new RegistryClient());
    }

    public GMSClient(String baseURL) throws IllegalArgumentException {
        if (baseURL == null) {
            throw new IllegalArgumentException("baseURL is required");
        }
        try {
            new URL(baseURL);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL is malformed: " + e.getMessage());
        }
        this.baseURL = baseURL.endsWith("/") ? baseURL.substring(0, baseURL.length() - 1) : baseURL;
    }

    @Override
    public void transferEvent(TransferEvent te) {
        if (9 == te.getState()) {
            log.debug("retry after request failed, reason: " + te.getError());
        }
    }

    @Override
    public String getEventHeader() {
        return null;
    }

    public List<Group> getGroups() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public List<User<? extends Principal>> getDisplayUsers() throws IOException {
        ArrayList<User<? extends Principal>> webUsers = new ArrayList<User<? extends Principal>>();
        HttpDownload httpDownload = this.createDisplayUsersHTTPDownload(webUsers);
        httpDownload.setRequestProperty("Accept", "application/json");
        httpDownload.run();
        Throwable error = httpDownload.getThrowable();
        if (error != null) {
            String errMessage = error.getMessage();
            int responseCode = httpDownload.getResponseCode();
            log.debug("getDisplayUsers response " + responseCode + ": " + errMessage);
            if (responseCode == 401 || responseCode == 403 || responseCode == -1) {
                throw new AccessControlException(errMessage);
            }
            if (responseCode == 400) {
                throw new IllegalArgumentException(errMessage);
            }
            throw new IOException("HttpResponse (" + responseCode + ") - " + errMessage);
        }
        log.debug("Content-Length: " + httpDownload.getContentLength());
        log.debug("Content-Type: " + httpDownload.getContentType());
        return webUsers;
    }

    HttpDownload createDisplayUsersHTTPDownload(List<User<? extends Principal>> webUsers) throws IOException {
        URL usersListURL = new URL(this.baseURL + "/users");
        return new HttpDownload(usersListURL, new JsonUserListInputStreamWrapper(webUsers));
    }

    public Group createGroup(Group group) throws GroupAlreadyExistsException, AccessControlException, UserNotFoundException, IOException {
        URL createGroupURL = new URL(this.baseURL + "/groups");
        log.debug("createGroupURL request to " + createGroupURL.toString());
        this.clearCache();
        StringBuilder groupXML = new StringBuilder();
        GroupWriter groupWriter = new GroupWriter();
        groupWriter.write(group, groupXML);
        log.debug("createGroup: " + groupXML);
        byte[] bytes = groupXML.toString().getBytes("UTF-8");
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        HttpUpload transfer = new HttpUpload(in, createGroupURL);
        transfer.setSSLSocketFactory(this.getSSLSocketFactory());
        transfer.run();
        Throwable error = transfer.getThrowable();
        if (error != null) {
            log.debug("createGroup throwable", error);
            if (transfer.getResponseCode() == -1 || transfer.getResponseCode() == 401 || transfer.getResponseCode() == 403) {
                throw new AccessControlException(error.getMessage());
            }
            if (transfer.getResponseCode() == 400) {
                throw new IllegalArgumentException(error.getMessage());
            }
            if (transfer.getResponseCode() == 409) {
                throw new GroupAlreadyExistsException(error.getMessage());
            }
            if (transfer.getResponseCode() == 404) {
                throw new UserNotFoundException(error.getMessage());
            }
            throw new IOException(error);
        }
        String retXML = transfer.getResponseBody();
        try {
            log.debug("createGroup returned: " + retXML);
            GroupReader groupReader = new GroupReader();
            return groupReader.read(retXML);
        }
        catch (Exception bug) {
            log.error("Unexpected exception", bug);
            throw new RuntimeException(bug);
        }
    }

    public Group getGroup(String groupName) throws GroupNotFoundException, AccessControlException, IOException {
        URL getGroupURL = new URL(this.baseURL + "/groups/" + groupName);
        log.debug("getGroup request to " + getGroupURL.toString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HttpDownload transfer = new HttpDownload(getGroupURL, out);
        transfer.setSSLSocketFactory(this.getSSLSocketFactory());
        transfer.run();
        Throwable error = transfer.getThrowable();
        if (error != null) {
            log.debug("getGroup throwable (" + transfer.getResponseCode() + ")", error);
            if (transfer.getResponseCode() == -1 || transfer.getResponseCode() == 401 || transfer.getResponseCode() == 403) {
                throw new AccessControlException(error.getMessage());
            }
            if (transfer.getResponseCode() == 400) {
                throw new IllegalArgumentException(error.getMessage());
            }
            if (transfer.getResponseCode() == 404) {
                throw new GroupNotFoundException(error.getMessage());
            }
            throw new IOException(error);
        }
        try {
            String groupXML = new String(out.toByteArray(), "UTF-8");
            log.debug("getGroup returned: " + groupXML);
            GroupReader groupReader = new GroupReader();
            return groupReader.read(groupXML);
        }
        catch (Exception bug) {
            log.error("Unexpected exception", bug);
            throw new RuntimeException(bug);
        }
    }

    public List<String> getGroupNames() throws AccessControlException, IOException {
        URL getGroupNamesURL = new URL(this.baseURL + "/groups");
        log.debug("getGroupNames request to " + getGroupNamesURL.toString());
        final ArrayList<String> groupNames = new ArrayList<String>();
        HttpDownload httpDownload = new HttpDownload(getGroupNamesURL, new InputStreamWrapper(){

            public void read(InputStream inputStream) throws IOException {
                try {
                    String line;
                    InputStreamReader inReader = new InputStreamReader(inputStream);
                    BufferedReader reader = new BufferedReader(inReader);
                    while ((line = reader.readLine()) != null) {
                        groupNames.add(line);
                    }
                }
                catch (Exception bug) {
                    log.error("Unexpected exception", bug);
                    throw new RuntimeException(bug);
                }
            }
        });
        httpDownload.setRetry(0, 0, HttpTransfer.RetryReason.NONE);
        httpDownload.setSSLSocketFactory(this.getSSLSocketFactory());
        httpDownload.run();
        Throwable error = httpDownload.getThrowable();
        if (error != null) {
            String errMessage = error.getMessage();
            int responseCode = httpDownload.getResponseCode();
            log.debug("getGroupNames response " + responseCode + ": " + errMessage);
            if (responseCode == 401 || responseCode == 403 || responseCode == -1) {
                throw new AccessControlException(errMessage);
            }
            if (responseCode == 400) {
                throw new IllegalArgumentException(errMessage);
            }
            throw new IOException("HttpResponse (" + responseCode + ") - " + errMessage);
        }
        log.debug("Content-Length: " + httpDownload.getContentLength());
        log.debug("Content-Type: " + httpDownload.getContentType());
        return groupNames;
    }

    public Group updateGroup(Group group) throws IllegalArgumentException, GroupNotFoundException, UserNotFoundException, AccessControlException, IOException {
        URL updateGroupURL = new URL(this.baseURL + "/groups/" + group.getID());
        log.debug("updateGroup request to " + updateGroupURL.toString());
        this.clearCache();
        StringBuilder groupXML = new StringBuilder();
        GroupWriter groupWriter = new GroupWriter();
        groupWriter.write(group, groupXML);
        log.debug("updateGroup: " + groupXML);
        HttpPost transfer = new HttpPost(updateGroupURL, groupXML.toString(), "application/xml", true);
        transfer.setSSLSocketFactory(this.getSSLSocketFactory());
        transfer.setTransferListener(this);
        transfer.run();
        Throwable error = transfer.getThrowable();
        if (error != null) {
            if (transfer.getResponseCode() == -1 || transfer.getResponseCode() == 401 || transfer.getResponseCode() == 403) {
                throw new AccessControlException(error.getMessage());
            }
            if (transfer.getResponseCode() == 400) {
                throw new IllegalArgumentException(error.getMessage());
            }
            if (transfer.getResponseCode() == 404) {
                if (error.getMessage() != null && error.getMessage().toLowerCase().contains("user")) {
                    throw new UserNotFoundException(error.getMessage());
                }
                throw new GroupNotFoundException(error.getMessage());
            }
            throw new IOException(error);
        }
        try {
            String retXML = transfer.getResponseBody();
            log.debug("getGroup returned: " + retXML);
            GroupReader groupReader = new GroupReader();
            return groupReader.read(retXML);
        }
        catch (Exception bug) {
            log.error("Unexpected exception", bug);
            throw new RuntimeException(bug);
        }
    }

    public void deleteGroup(String groupName) throws GroupNotFoundException, AccessControlException, IOException {
        int responseCode;
        URL deleteGroupURL = new URL(this.baseURL + "/groups/" + groupName);
        log.debug("deleteGroup request to " + deleteGroupURL.toString());
        this.clearCache();
        HttpURLConnection conn = (HttpURLConnection)deleteGroupURL.openConnection();
        conn.setRequestMethod("DELETE");
        SSLSocketFactory sf = this.getSSLSocketFactory();
        if (sf != null && conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(sf);
        }
        try {
            responseCode = conn.getResponseCode();
        }
        catch (Exception e) {
            throw new AccessControlException(e.getMessage());
        }
        if (responseCode != 200) {
            String errMessage = NetUtil.getErrorBody(conn);
            log.debug("deleteGroup response " + responseCode + ": " + errMessage);
            if (responseCode == 401 || responseCode == 403 || responseCode == -1) {
                throw new AccessControlException(errMessage);
            }
            if (responseCode == 400) {
                throw new IllegalArgumentException(errMessage);
            }
            if (responseCode == 404) {
                throw new GroupNotFoundException(errMessage);
            }
            throw new IOException("HttpResponse (" + responseCode + ") - " + errMessage);
        }
    }

    public void addGroupMember(String targetGroupName, String groupMemberName) throws IllegalArgumentException, GroupNotFoundException, AccessControlException, IOException {
        URL addGroupMemberURL = new URL(this.baseURL + "/groups/" + targetGroupName + "/groupMembers/" + groupMemberName);
        log.debug("addGroupMember request to " + addGroupMemberURL.toString());
        this.clearCache();
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
        HttpUpload httpUpload = new HttpUpload(is, addGroupMemberURL);
        httpUpload.setSSLSocketFactory(this.getSSLSocketFactory());
        httpUpload.run();
        Throwable error = httpUpload.getThrowable();
        if (error != null) {
            int responseCode = httpUpload.getResponseCode();
            String errMessage = error.getMessage();
            if (responseCode == -1 || responseCode == 401 || responseCode == 403) {
                throw new AccessControlException(errMessage);
            }
            if (responseCode == 400) {
                throw new IllegalArgumentException(errMessage);
            }
            if (responseCode == 404) {
                throw new GroupNotFoundException(errMessage);
            }
            throw new IOException(errMessage);
        }
    }

    public void addUserMember(String targetGroupName, Principal userID) throws GroupNotFoundException, UserNotFoundException, AccessControlException, IOException {
        log.debug("addUserMember: " + targetGroupName + " + " + userID.getName());
        String userIDType = AuthenticationUtil.getPrincipalType(userID);
        URL addUserMemberURL = new URL(this.baseURL + "/groups/" + targetGroupName + "/userMembers/" + NetUtil.encode(userID.getName()) + "?idType=" + userIDType);
        log.debug("addUserMember request to " + addUserMemberURL.toString());
        this.clearCache();
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
        HttpUpload httpUpload = new HttpUpload(is, addUserMemberURL);
        httpUpload.setSSLSocketFactory(this.getSSLSocketFactory());
        httpUpload.run();
        Throwable error = httpUpload.getThrowable();
        if (error != null) {
            int responseCode = httpUpload.getResponseCode();
            String errMessage = error.getMessage();
            if (responseCode == -1 || responseCode == 401 || responseCode == 403) {
                throw new AccessControlException(errMessage);
            }
            if (responseCode == 400) {
                throw new IllegalArgumentException(errMessage);
            }
            if (responseCode == 404) {
                if (errMessage != null && errMessage.toLowerCase().contains("user")) {
                    throw new UserNotFoundException(errMessage);
                }
                throw new GroupNotFoundException(errMessage);
            }
            throw new IOException(errMessage);
        }
    }

    public void removeGroupMember(String targetGroupName, String groupMemberName) throws GroupNotFoundException, AccessControlException, IOException {
        URL removeGroupMemberURL = new URL(this.baseURL + "/groups/" + targetGroupName + "/groupMembers/" + groupMemberName);
        log.debug("removeGroupMember request to " + removeGroupMemberURL.toString());
        this.clearCache();
        HttpURLConnection conn = (HttpURLConnection)removeGroupMemberURL.openConnection();
        conn.setRequestMethod("DELETE");
        SSLSocketFactory sf = this.getSSLSocketFactory();
        if (sf != null && conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(this.getSSLSocketFactory());
        }
        int responseCode = -1;
        try {
            responseCode = conn.getResponseCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (responseCode != 200) {
            String errMessage = NetUtil.getErrorBody(conn);
            log.debug("removeGroupMember response " + responseCode + ": " + errMessage);
            if (responseCode == -1 || responseCode == 401 || responseCode == 403) {
                throw new AccessControlException(errMessage);
            }
            if (responseCode == 400) {
                throw new IllegalArgumentException(errMessage);
            }
            if (responseCode == 404) {
                throw new GroupNotFoundException(errMessage);
            }
            throw new IOException(errMessage);
        }
    }

    public void removeUserMember(String targetGroupName, Principal userID) throws GroupNotFoundException, UserNotFoundException, AccessControlException, IOException {
        String userIDType = AuthenticationUtil.getPrincipalType(userID);
        log.debug("removeUserMember: " + targetGroupName + " - " + userID.getName() + " type: " + userIDType);
        URL removeUserMemberURL = new URL(this.baseURL + "/groups/" + targetGroupName + "/userMembers/" + NetUtil.encode(userID.getName()) + "?idType=" + userIDType);
        log.debug("removeUserMember: " + removeUserMemberURL.toString());
        this.clearCache();
        HttpURLConnection conn = (HttpURLConnection)removeUserMemberURL.openConnection();
        conn.setRequestMethod("DELETE");
        SSLSocketFactory sf = this.getSSLSocketFactory();
        if (sf != null && conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(this.getSSLSocketFactory());
        }
        int responseCode = -1;
        try {
            responseCode = conn.getResponseCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (responseCode != 200) {
            String errMessage = NetUtil.getErrorBody(conn);
            log.debug("removeUserMember response " + responseCode + ": " + errMessage);
            if (responseCode == -1 || responseCode == 401 || responseCode == 403) {
                throw new AccessControlException(errMessage);
            }
            if (responseCode == 400) {
                throw new IllegalArgumentException(errMessage);
            }
            if (responseCode == 404) {
                if (errMessage != null && errMessage.toLowerCase().contains("user")) {
                    throw new UserNotFoundException(errMessage);
                }
                throw new GroupNotFoundException(errMessage);
            }
            throw new IOException(errMessage);
        }
    }

    private Principal getCurrentUserID() {
        Subject cur = AuthenticationUtil.getCurrentSubject();
        if (cur == null) {
            return null;
        }
        Set<HttpPrincipal> ps = cur.getPrincipals(HttpPrincipal.class);
        if (ps.isEmpty()) {
            return null;
        }
        Principal p = ps.iterator().next();
        log.debug("getCurrentID: " + p.getClass());
        return p;
    }

    public List<Group> getMemberships(Role role) throws UserNotFoundException, AccessControlException, IOException {
        return this.getMemberships(null, role);
    }

    private List<Group> getMemberships(Principal ignore, Role role) throws UserNotFoundException, AccessControlException, IOException {
        List<Group> cachedGroups;
        if (role == null) {
            throw new IllegalArgumentException("role are required.");
        }
        Principal userID = this.getCurrentUserID();
        if (userID != null && (cachedGroups = this.getCachedGroups(userID, role, true)) != null) {
            return cachedGroups;
        }
        String roleString = role.getValue();
        StringBuilder searchGroupURL = new StringBuilder(this.baseURL);
        searchGroupURL.append("/search?");
        searchGroupURL.append("&ROLE=").append(NetUtil.encode(roleString));
        log.debug("getMemberships request to " + searchGroupURL.toString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        URL url = new URL(searchGroupURL.toString());
        HttpDownload transfer = new HttpDownload(url, out);
        transfer.setSSLSocketFactory(this.getSSLSocketFactory());
        transfer.run();
        Throwable error = transfer.getThrowable();
        if (error != null) {
            log.debug("getMemberships throwable", error);
            if (transfer.getResponseCode() == -1 || transfer.getResponseCode() == 401 || transfer.getResponseCode() == 403) {
                throw new AccessControlException(error.getMessage());
            }
            if (transfer.getResponseCode() == 404) {
                throw new UserNotFoundException(error.getMessage());
            }
            if (transfer.getResponseCode() == 400) {
                throw new IllegalArgumentException(error.getMessage());
            }
            throw new IOException(error);
        }
        try {
            String groupsXML = new String(out.toByteArray(), "UTF-8");
            log.debug("getMemberships returned: " + groupsXML);
            GroupListReader groupListReader = new GroupListReader();
            List<Group> groups = groupListReader.read(groupsXML);
            this.setCachedGroups(userID, groups, role);
            return groups;
        }
        catch (Exception bug) {
            log.error("Unexpected exception", bug);
            throw new RuntimeException(bug);
        }
    }

    public Group getMembership(String groupName) throws UserNotFoundException, AccessControlException, IOException {
        return this.getMembership(groupName, Role.MEMBER);
    }

    public Group getMembership(String groupName, Role role) throws UserNotFoundException, AccessControlException, IOException {
        Group cachedGroup;
        if (groupName == null || role == null) {
            throw new IllegalArgumentException("groupName and role are required.");
        }
        Principal userID = this.getCurrentUserID();
        if (userID != null && (cachedGroup = this.getCachedGroup(userID, groupName, role)) != null) {
            return cachedGroup;
        }
        String roleString = role.getValue();
        StringBuilder searchGroupURL = new StringBuilder(this.baseURL);
        searchGroupURL.append("/search?");
        searchGroupURL.append("&ROLE=").append(NetUtil.encode(roleString));
        searchGroupURL.append("&GROUPID=").append(NetUtil.encode(groupName));
        log.debug("getMembership request to " + searchGroupURL.toString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        URL url = new URL(searchGroupURL.toString());
        HttpDownload transfer = new HttpDownload(url, out);
        transfer.setSSLSocketFactory(this.getSSLSocketFactory());
        transfer.run();
        Throwable error = transfer.getThrowable();
        if (error != null) {
            log.debug("getMembership throwable", error);
            if (transfer.getResponseCode() == -1 || transfer.getResponseCode() == 401 || transfer.getResponseCode() == 403) {
                throw new AccessControlException(error.getMessage());
            }
            if (transfer.getResponseCode() == 404) {
                throw new UserNotFoundException(error.getMessage());
            }
            if (transfer.getResponseCode() == 400) {
                throw new IllegalArgumentException(error.getMessage());
            }
            throw new IOException(error);
        }
        try {
            String groupsXML = new String(out.toByteArray(), "UTF-8");
            log.debug("getMembership returned: " + groupsXML);
            GroupListReader groupListReader = new GroupListReader();
            List<Group> groups = groupListReader.read(groupsXML);
            if (groups.isEmpty()) {
                return null;
            }
            if (groups.size() == 1) {
                Group ret = groups.get(0);
                this.addCachedGroup(userID, ret, role);
                return ret;
            }
            throw new IllegalStateException("Duplicate membership for " + userID + " in group " + groupName);
        }
        catch (Exception bug) {
            log.error("Unexpected exception", bug);
            throw new RuntimeException(bug);
        }
    }

    public boolean isMember(String groupName) throws UserNotFoundException, AccessControlException, IOException {
        return this.isMember(groupName, Role.MEMBER);
    }

    public boolean isMember(String groupName, Role role) throws UserNotFoundException, AccessControlException, IOException {
        return this.isMember(this.getCurrentUserID(), groupName, role);
    }

    private boolean isMember(Principal userID, String groupName, Role role) throws UserNotFoundException, AccessControlException, IOException {
        Group group = this.getMembership(groupName, role);
        return group != null;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        if (this.mySocketFactory != null) {
            throw new IllegalStateException("Illegal use of GMSClient: cannot set SSLSocketFactory after using one created from Subject");
        }
        this.sslSocketFactory = sslSocketFactory;
        this.clearCache();
    }

    private SSLSocketFactory getSSLSocketFactory() {
        AccessControlContext ac = AccessController.getContext();
        Subject s = Subject.getSubject(ac);
        if (s == null || s.getPrincipals().isEmpty()) {
            return this.sslSocketFactory;
        }
        if (this.mySocketFactory == null) {
            log.debug("getSSLSocketFactory: " + s);
            this.mySocketFactory = SSLUtil.getSocketFactory(s);
            this.subjectHashCode = s.hashCode();
        } else {
            int c = s.hashCode();
            if (c != this.subjectHashCode) {
                throw new IllegalStateException("Illegal use of " + this.getClass().getSimpleName() + ": subject change not supported for internal SSLSocketFactory");
            }
        }
        return this.mySocketFactory;
    }

    protected void clearCache() {
        AccessControlContext acContext = AccessController.getContext();
        Subject subject = Subject.getSubject(acContext);
        if (subject != null) {
            subject.getPrivateCredentials().remove(new GroupMemberships());
        }
    }

    protected GroupMemberships getGroupCache(Principal userID) {
        AccessControlContext acContext = AccessController.getContext();
        Subject subject = Subject.getSubject(acContext);
        if (this.userIsSubject(userID, subject)) {
            Set<GroupMemberships> gset = subject.getPrivateCredentials(GroupMemberships.class);
            if (gset == null || gset.isEmpty()) {
                GroupMemberships mems = new GroupMemberships(new User<Principal>(userID));
                subject.getPrivateCredentials().add(mems);
                return mems;
            }
            GroupMemberships mems = gset.iterator().next();
            return mems;
        }
        return null;
    }

    protected Group getCachedGroup(Principal userID, String groupID, Role role) {
        List<Group> groups = this.getCachedGroups(userID, role, false);
        if (groups == null) {
            return null;
        }
        for (Group g : groups) {
            if (!g.getID().equals(groupID)) continue;
            return g;
        }
        return null;
    }

    protected List<Group> getCachedGroups(Principal userID, Role role, boolean complete) {
        GroupMemberships mems = this.getGroupCache(userID);
        if (mems == null) {
            return null;
        }
        Boolean cacheState = mems.isComplete(role);
        if (!complete || Boolean.TRUE.equals(cacheState)) {
            return mems.getMemberships(role);
        }
        return null;
    }

    protected void addCachedGroup(Principal userID, Group group, Role role) {
        GroupMemberships mems = this.getGroupCache(userID);
        if (mems == null) {
            return;
        }
        mems.add(group, role);
    }

    protected void setCachedGroups(Principal userID, List<Group> groups, Role role) {
        GroupMemberships mems = this.getGroupCache(userID);
        if (mems == null) {
            return;
        }
        mems.add(groups, role);
    }

    protected boolean userIsSubject(Principal userID, Subject subject) {
        if (userID == null || subject == null) {
            return false;
        }
        for (Principal subjectPrincipal : subject.getPrincipals()) {
            if (!AuthenticationUtil.equals(subjectPrincipal, userID)) continue;
            return true;
        }
        return false;
    }
}

