/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac;

import ca.nrc.cadc.ac.GroupProperty;
import ca.nrc.cadc.ac.User;
import java.security.Principal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group {
    private String groupID;
    private User<? extends Principal> owner;
    protected Set<GroupProperty> properties = new HashSet<GroupProperty>();
    private Set<User<? extends Principal>> userMembers = new HashSet<User<? extends Principal>>();
    private Set<Group> groupMembers = new HashSet<Group>();
    private Set<User<? extends Principal>> userAdmins = new HashSet<User<? extends Principal>>();
    private Set<Group> groupAdmins = new HashSet<Group>();
    public String description;
    public Date lastModified;

    public Group() {
    }

    public Group(String groupID) {
        this(groupID, null);
    }

    public Group(String groupID, User<? extends Principal> owner) {
        if (groupID == null) {
            throw new IllegalArgumentException("Null groupID");
        }
        if (!groupID.matches("^[a-zA-Z0-9\\-\\.~_]*$")) {
            throw new IllegalArgumentException("Invalid group ID " + groupID + ": may not contain space ( ), slash (/), escape (\\), or percent (%)");
        }
        this.groupID = groupID;
        this.owner = owner;
    }

    public String getID() {
        return this.groupID;
    }

    public User<? extends Principal> getOwner() {
        return this.owner;
    }

    public void setOwner(User<? extends Principal> owner) {
        this.owner = owner;
    }

    public Set<GroupProperty> getProperties() {
        return this.properties;
    }

    public Set<User<? extends Principal>> getUserMembers() {
        return this.userMembers;
    }

    public Set<Group> getGroupMembers() {
        return this.groupMembers;
    }

    public Set<User<? extends Principal>> getUserAdmins() {
        return this.userAdmins;
    }

    public Set<Group> getGroupAdmins() {
        return this.groupAdmins;
    }

    public int hashCode() {
        return 31 + this.groupID.toLowerCase().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        return this.groupID.equalsIgnoreCase(other.groupID);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.groupID + "]";
    }
}

