# LST analysis

Collection of scripts to run analysis of LST data at the IT cluster in La Palma.
The repository contains also a folder with some bash scripts that can be easily used.

## Analysis tree

Use `create_analysis_tree.py` to create automatically a directory tree.
The default one is:

```bash
Parent_Folder
        └──DL1
            ├── source
            │   └── night
            │      └── version
            │           └── cleaning
            DL2
            ├── source
            │   └── night
            │      └── version
            │           └── cleaning
            DL3
            └── source
                └── night
                   └── version
                        └── cleaning
```

Modify the script at your convenience if you prefer a different structure.
Change the default value for the Parent folder in the argparse with your own path.

Example:

```bash
python create_analysis_tree.py --source Crab --night 20220304
```

Output:

```bash
Directory  /fefs/aswg/workspace/alice.donini/Analysis/data/DL1/Crab/20220304/v0.9.2/tailcut84  already exists
Directory  /fefs/aswg/workspace/alice.donini/Analysis/data/DL2/Crab/20220304/v0.9.2/tailcut84  Created
Directory  /fefs/aswg/workspace/alice.donini/Analysis/data/DL3/Crab/20220304/v0.9.2/tailcut84  Created
Directory structure ready for analysis on Crab.
```

## Contributing
Pull requests are welcome. For major changes, please open an issue first to discuss what you would like to change.