KPL/FK

ExoMarsRSP Kazachok Surface Platform (SP) Frames Kernel
===============================================================================

   This frame kernel contains a complete set of frame definitions for the
   ExoMars Surface Platform including definitions for the structures science 
   instrument frames. This kernel also contains NAIF ID/name mapping for the
   ExoMars Surface Platform instruments.


Version and Date
------------------------------------------------------------------------

   Version 0.0.4 -- March 18, 2020 -- Stanislav Bober, IKI
                                      Marc Costa Sitja, ESAC/ESA
   
      SP_LANDER attitude was linked to SP_LANDED_LOCAL frame
	  using CK file. LARA_ANT_BASE and SP_TS_CAM_BASE was redefined
	  relative to SP_LANDER. Updated formatting and fixed some typos.

   Version 0.0.3 -- January 20, 2019 -- Stanislav Bober, IKI
   
      Added observation cameras frames and positions
	  (SP_TS_CAM_1 .. SP_TS_CAM_4).

   Version 0.0.2 -- December 30, 2019 -- Stanislav Bober, IKI
   
      SP_AFTER_RM was removed from frame chaining. If platform
      attitude will be changed after RM disposal then new attitude
      will be incorporated in CK kernel.
      LARA_ANT_BASE temporarily defined relative to SP_LANDED_LOCAL and
      will be changed in next version.
      SP_CRUISE frame now redefined relative to CM_SPACECRAFT.

   Version 0.0.1 -- October 30, 2019 -- Stanislav Bober, IKI
   
      Descent path was removed from frame chaining.
      LARA frames added. Added several frame definitions.

   Version 0.0.0-draft -- September 23, 2019 -- Stanislav Bober, IKI
   
      Draft Version. Based on ExoMars-16 EDM (Schiaparelli)
      Frame Definitions Kernel (em16_edm_v01.tf)


References
------------------------------------------------------------------------

    1. ``Frames Required Reading'', NAIF 

    2. ``Kernel Pool Required Reading'', NAIF 

    3. ``C-Kernel Required Reading'', NAIF
   
    4. Email from Marc Costa <mcosta@sciops.esa.int>
       ``Special consideration for LaRa in the Surface Platform FK''
       on 12 July 2019
   
    5. Email from Alexander Abbakumov <aabbakumov@romance.iki.rssi.ru>
       ``Layout of EM2020'' on 31 July 2019
       
    6. Email from Oleg Batanov <obat@romance.iki.rssi.ru>
       ``EM20 SRP (Science Research Program)'' on 19 September 2019
      


Contact Information
------------------------------------------------------------------------

   If you have any questions regarding this file contact
   the ESA SPICE Service at ESAC:

           Marc Costa Sitja
           (+34) 91-8131-457
           marc.costa@esa.int, esa_spice@sciops.esa.int

     or SPICE support at IKI:

             Alexander Abbakumov
             +7 (495) 333-40-13
             aabbakumov@romance.iki.rssi.ru

             Stanislav Bober
             +7 (985) 285-24-94
             stasbober@rlab.iki.rssi.ru
      
     
Implementation Notes
------------------------------------------------------------------------

  This file is used by the SPICE system as follows: programs that make use
  of this frame kernel must "load" the kernel normally during program
  initialization. Loading the kernel associates the data items with
  their names in a data structure called the "kernel pool".  The SPICELIB
  routine FURNSH loads a kernel into the pool as shown below:

    FORTRAN: (SPICELIB)

      CALL FURNSH ( frame_kernel_name )

    C: (CSPICE)

      furnsh_c ( frame_kernel_name );

    IDL: (ICY)

      cspice_furnsh, frame_kernel_name

    MATLAB: (MICE)
      
         cspice_furnsh ( 'frame_kernel_name' )

    PYTHON: (SPICEYPY)*

         furnsh( frame_kernel_name )

  In order for a program or routine to extract data from the pool, the
  SPICELIB routines GDPOOL, GIPOOL, and GCPOOL are used.  See [2] for
  more details.

  This file was created and may be updated with a text editor or word
  processor.

  * SPICEPY is a non-official, community developed Python wrapper for the
    NAIF SPICE toolkit. Its development is managed on Github.
    It is available at: https://github.com/AndrewAnnex/SpiceyPy

   
ExoMars Surface Platform NAIF ID Codes -- Summary Section
------------------------------------------------------------------------

   The following names and NAIF ID codes are assigned to the ExoMars Surface
   Platform, its structures and science instruments (the keywords implementing
   these definitions are located in the section "ExoMars Surface Platform NAIF 
   ID Codes -- Definitions Section" at the end of this file):
   
   ExoMars Surface Platform and it's Structures names/IDs:

    EXOMARS SURFACE PLATFORM    -173     (synonyms:
                                          EXOMARS RSP SURFACE PLATFORM,
                                          EXOMARS RSP SP)
                                                                                    
    SP_LANDER                  -173000
    SP_CRUISE                  -173001
    SP_TOPO                    -173900
    SP_LANDED_LOCAL            -173901

    LARA                        -197     (synonyms:
                                          EXOMARS LARA,
                                          EXOMARS RSP LARA)

    LARA_ANT_BASE               -197000
    LARA_ANT_TX1                -197001
    LARA_ANT_TX2                -197002
    LARA_ANT_RX                 -197003

ExoMars Surface Platform Frames
------------------------------------------------------------------------

   The following ExoMars Surface Platform frames are defined in this kernel file:

        Name                      Relative to                 Type    NAIF ID
      ======================    ==========================   =======  =======
          
        SP_CRUISE                  CM_SPACECRAFT             FIXED    -173001
        SP_TOPO                    IAU_MARS                  FIXED    -173900
        SP_LANDED_LOCAL            SP_TOPO                   FIXED    -173901
    
        SP_LANDER                  SP_CRUISE,                CK       -173000
                                   SP_LANDED_LOCAL
        
        LARA_ANT_BASE              SP_LANDER                 FIXED    -197000
        LARA_ANT_TX1               LARA_ANT_BASE             FIXED    -197001
        LARA_ANT_TX2               LARA_ANT_BASE             FIXED    -197002
        LARA_ANT_RX                LARA_ANT_BASE             FIXED    -197003
        
        SP_TS_CAM_BASE             SP_LANDER                 FIXED    -173920
        SP_TS_CAM_1                SP_TS_CAM_BASE            FIXED    -173921
        SP_TS_CAM_2                SP_TS_CAM_BASE            FIXED    -173922
        SP_TS_CAM_3                SP_TS_CAM_BASE            FIXED    -173923
        SP_TS_CAM_4                SP_TS_CAM_BASE            FIXED    -173924

ExoMars Surface Platform Frames Hierarchy
--------------------------------------------------------------------------

   The diagram below shows the ExoMars Surface Platform frames hierarchy:


                "J2000" INERTIAL
        +-------------------------------+
        |                               |
        | <--ck                         | <--pck
        |                               |
        v                               v
  "CM_SPACECRAFT"                   "IAU_MARS"   
  ---------------                       +
        |                               |
        | <--fixed                      | <--fixed
        |                               |
        v                               v
   "SP_CRUISE"                       "SP_TOPO"
   -----------                          +
        |                               |
        |                               | <--fixed
        |                               |
        |                               v
        |                       "SP_LANDED_LOCAL"
        |                       -----------------
        |                               |        
        | <--ck(*)                      | <--ck(*)
        |                               |         
        v                               v         
        +--------------------+----------+
                             |
                             v
                         "SP_LANDER"
                         -----------
                             |
                             |
                             +------------------------------------+
                             |                                    |
                             | <--fixed                           |
                             v                                    |
                      "LARA_ANT_BASE"                             |
             +---------------+---------------+                    |
             |               |               |                    |
             |<--fixed       |<--fixed       |<--fixed            |
             v               v               v                    |
        "LARA_ANT_TX1"  "LARA_ANT_TX2"  "LARA_ANT_RX"             |
                                                                  |
                                                                  |
                                                                  |
                                                                  |
                             +------------------------------------+
                             |
                             | <--fixed
                             |
                             v
                      "SP_TS_CAM_BASE"
        +-------------+-------------+-------------+
        |             |             |             |
        | <--fixed    | <--fixed    | <--fixed    | <--fixed
        v             v             v             v
   "SP_TS_CAM_1" "SP_TS_CAM_2" "SP_TS_CAM_3" "SP_TS_CAM_4"
        
                         
                         

   (*)      In these cases transformation is fixed but it has to be
            stored in a CK to make SPICE "traverse" appropriate frame
            tree branch based on the time of interest and/or loaded
            kernels.  


Implementation of Frame Chains for Different Mission Phases
-------------------------------------------------------------------------------

   Different routes along the branches of the SP frame hierarchy
   are implemented for different mission phases depending on the
   availability of the orientation data and the source, format and type
   of the data.

   This subsection summarizes mission phase specific implementations.


Cruise
------

     "J2000" Inertial
     ----------------
            |
            | <----------- CK segment containing telemetry data
            |
            v
     "CM_SPACECRAFT"
     ---------------
            |
            | <----------- Fixed rotation based on frame definitions
            |
            v
       "SP_CRUISE"
       -----------
            |
            |
            | <----------- CK segment representing fixed rotation defined
            |              by the lander design and to make SPICE "transverse"
            V              to the appropiate frame chain
      "SP_LANDER"
      ------------

Surface Mission (after landing)
---------------------------------------------------------

     "J2000" Inertial
     ----------------
            |
            | <----------- PCK-based transformation
            V
        "IAU_MARS" 
        ----------
            |
            | <----------- Fixed rotation based on the landing site
            |              coordinates. Generated using PINPOINT utility.
            V              (See sp_topo_xxxxxxxx.tf, sp_topo_xxxxxxxx.bsp)
        "SP_TOPO"
        ----------
            |
            | <----------- Fixed rotation based on frame definitions
            V
    "SP_LANDED_LOCAL"
    -----------------
            |
            | <----------- CK segment representing fixed rotation per
            |              initial quaternion and to make SPICE "transverse"
            V              to the appropiate frame chain.
       "SP_LANDER"
       ------------


ExoMars Surface Platform Spacecraft and Spacecraft Structures Frames
--------------------------------------------------------------------

   This section of the file contains the definitions of the spacecraft
   and spacecraft structures frames.


ExoMars Surface Platform Spacecraft Frames
------------------------------------------

    ExoMars Surface Platform landing site topocentric frame 
    -- SP_TOPO -- is defined as follows:
    
        - +X axis points to Mars north pole;
        
        - +Z axis is orthogonal to Mars surface, points outside Mars;
        
        - +Y axis completes the right-handed frame;
        
        - the origin is located at ExoMars Surface Platform actual landing
          point above Mars surface;

        - Frame text kernel and binary SPK located in sp_topo_YYYYMMDD.tf,
          sp_topo_YYYYMMDD.bsp.


    ExoMars Surface Platform landing site reference frame 
    -- SP_LANDED_LOCAL -- is defined as follows:
            
        - Frame built by fixed rotation relative to SP_TOPO using
          angles acquired after SP landing.

        - Origin of this frame is located at the landing point on
          Mars surface.


    These diagrams illustrate the ExoMars Surface Platform frame (SP_LANDER):

    -Y side view:
    -------------


                                                __
                                               /\\\
                         _____________________ |\\|
                       ||                       ||\
                       ||                       || \
                       ||                       ||  \
             .---------||                       ||---'-----.
            /          ||                       ||          \
           |           ||                       ||           |
           |           ||                       ||           |
    _______|___________||_______+Ysc____________||___________|______
   |________________________________x---> +Zsc________BASE PLANE____|
    `.                              |                              .'
      `.                            | +Xsc                       .'
        `.__________________________v__________________________.'
           |   /   .'        `.            .'       `.   \   |
           |  /  .'            `.________.'           `.  \  |
           | / .'                                       `. \ |
          | /.'                      |                    `.\ |
       '._|/'__.'                    |                  '.__`\|_.'
         ======                      |                    ======
                                     v towards Mars



    -X top view:
    ------------



                                _.-----._
                            _.-'         '-._
                        _.-'                 '-._
                    _.-'                         '-._
                _.-'                                 '-._
              -'                        BASE PLANE       '-
             /   .--.                                .--.  \
            /     \_|                                |_/    \
           /                                                 \
          / =================|             |================= \
         /--|---------------.               .---------------|--\
        /   |               ||             ||               |   \
       /    |               ||             ||               |    \
      /     |               ||  .-------.  ||               |     \
     /      |               || /         \ ||               |      \
    .       |               ||/       +Ysc\||               |       .
    |       |               |' +Xsc x--->  '|               |       |
    |       |               |'      |      '|               |       |
    '       |               ||\     | +Zsc/||               |       '
     \      |               || \    v    / ||               |      /
      \     |               ||  `-------'  ||               |     /
       \    |               ||             ||               |    /
        \   |               ||             ||               |   /
         \--|---------------'               '---------------|--/
          \ =================|             |================= /
           \       _                                  _      /
            \     / |                                | \    /
             \_  '--'                                '--' _/
               '-._                                   _.-'
                   '-._                           _.-'
                       '-._                   _.-'
                           '-._           _.-'
                               '-._____.-'


   These sets of keywords define the ExoMars Surface Platform Spacecraft
   frames:

   \begindata

      FRAME_SP_LANDER                  = -173000
      FRAME_-173000_NAME               = 'SP_LANDER'
      FRAME_-173000_CLASS              =  3
      FRAME_-173000_CLASS_ID           = -173000
      FRAME_-173000_CENTER             = -173
      CK_-173000_SCLK                  = -173
      CK_-173000_SPK                   = -173
      OBJECT_-173_FRAME                = 'SP_LANDER'


      FRAME_SP_CRUISE                  =  -173001
      FRAME_-173001_NAME               = 'SP_CRUISE'
      FRAME_-173001_CLASS              =  4
      FRAME_-173001_CLASS_ID           =  -173001
      FRAME_-173001_CENTER             =  -174
      TKFRAME_-173001_RELATIVE         = 'CM_SPACECRAFT'
      TKFRAME_-173001_SPEC             = 'ANGLES'
      TKFRAME_-173001_UNITS            = 'DEGREES'
      TKFRAME_-173001_AXES             = (    3,   2,    3 )
      TKFRAME_-173001_ANGLES           = (  0.0, 0.0,  0.0 )



      FRAME_SP_LANDED_LOCAL            =  -173901
      FRAME_-173901_NAME               = 'SP_LANDED_LOCAL'
      FRAME_-173901_CLASS              =  4
      FRAME_-173901_CLASS_ID           =  -173901
      FRAME_-173901_CENTER             =  -173
      TKFRAME_-173901_RELATIVE         = 'SP_TOPO'
      TKFRAME_-173901_SPEC             = 'ANGLES'
      TKFRAME_-173901_UNITS            = 'DEGREES'
      TKFRAME_-173901_AXES             = (    3,    2,    3 )
      TKFRAME_-173901_ANGLES           = (  0.0, 90.0,  0.0 )

    \begintext


ExoMars Surface Platform LARA antennas frames
---------------------------------------------

    ExoMars Surface Platform LARA antennas frames base -- LARA_ANT_BASE -- is
    defined as follows:

        - Frame origin located at SP_LANDER origin.

        - +X axis points at zenith direction of Surface Platform

    ExoMars Surface Platform LARA antennas frames -- LARA_ANT_TX1,
    LARA_ANT_TX2, LARA_ANT_RX -- are defined as follows:

        - Frame origins located in LARA_ANT_TX1, LARA_ANT_TX2a and LARA_ANT_RX
          objects.

        - SPK kernels for LARA_ANT_TX1, LARA_ANT_TX2, LARA_ANT_RX objects have
          fixed offset relative to LARA_ANT_BASE origin.
        
        - Orientation is rotated by fixed angles relative to LARA_ANT_BASE
          (i.e. SP zenith), rotation angles acquired during calibration
          procedure.


   These sets of keywords define the ExoMars Surface Platform LARA atennas
   frames:

   \begindata

      FRAME_LARA_ANT_BASE              = -197000
      FRAME_-197000_NAME               = 'LARA_ANT_BASE'
      FRAME_-197000_CLASS              =  4
      FRAME_-197000_CLASS_ID           =  -197000
      FRAME_-197000_CENTER             =  -197
      TKFRAME_-197000_RELATIVE         = 'SP_LANDER'
      TKFRAME_-197000_SPEC             = 'ANGLES'
      TKFRAME_-197000_UNITS            = 'DEGREES'
      TKFRAME_-197000_AXES             = (   3,   2,   3  )
      TKFRAME_-197000_ANGLES           = ( 0.0, 0.0, 0.0  )

      FRAME_LARA_ANT_TX1               = -197011
      FRAME_-197011_NAME               = 'LARA_ANT_TX1'
      FRAME_-197011_CLASS              =  4
      FRAME_-197011_CLASS_ID           =  -197011
      FRAME_-197011_CENTER             =  -197001
      TKFRAME_-197011_RELATIVE         = 'LARA_ANT_BASE'
      TKFRAME_-197011_SPEC             = 'ANGLES'
      TKFRAME_-197011_UNITS            = 'DEGREES'
      TKFRAME_-197011_AXES             = (   3,    2,   3  )
      TKFRAME_-197011_ANGLES           = ( 0.0, 90.0, 0.0  )
      OBJECT_-197001_FRAME             = -197011

      FRAME_LARA_ANT_TX2               = -197012
      FRAME_-197012_NAME               = 'LARA_ANT_TX2'
      FRAME_-197012_CLASS              =  4
      FRAME_-197012_CLASS_ID           =  -197012
      FRAME_-197012_CENTER             =  -197002
      TKFRAME_-197012_RELATIVE         = 'LARA_ANT_BASE'
      TKFRAME_-197012_SPEC             = 'ANGLES'
      TKFRAME_-197012_UNITS            = 'DEGREES'
      TKFRAME_-197012_AXES             = (   3,    2,   3  )
      TKFRAME_-197012_ANGLES           = ( 0.0, 90.0, 0.0  )
      OBJECT_-197002_FRAME             = -197012

      FRAME_LARA_ANT_RX                = -197013
      FRAME_-197013_NAME               = 'LARA_ANT_RX'
      FRAME_-197013_CLASS              =  4
      FRAME_-197013_CLASS_ID           =  -197013
      FRAME_-197013_CENTER             =  -197003
      TKFRAME_-197013_RELATIVE         = 'LARA_ANT_BASE'
      TKFRAME_-197013_SPEC             = 'ANGLES'
      TKFRAME_-197013_UNITS            = 'DEGREES'
      TKFRAME_-197013_AXES             = (   3,    2,   3  )
      TKFRAME_-197013_ANGLES           = ( 0.0, 90.0, 0.0  )
      OBJECT_-197003_FRAME             = -197013

    \begintext


ExoMars Surface Platform Television System (TS) cameras frames
--------------------------------------------------------------

	ExoMars Surface Platform SP_TS_CAM_ observation cameras frames
	-- SP_TS_CAM_1, SP_TS_CAM_2, SP_TS_CAM_3, SP_TS_CAM_4 -- are
	defined as follows:
	
		- Frame origins located in SP_TS_CAM_1, SP_TS_CAM_2, SP_TS_CAM_3,
		  SP_TS_CAM_4 objects.
		
		- SPK kernels for SP_TS_CAM_1, SP_TS_CAM_2, SP_TS_CAM_3,
		  SP_TS_CAM_4 objects have a fixed offset relative to SP_TS_CAM_BASE
		  origin as follows:

		     - Z coordinate is +/- 439.8 mm,
		     - Y coordinate is +/- 633.5 mm.
		  
		- The orientation of the cameras  is defined by fixed angles
		  relative to SP_TS_CAM__BASE to satisfy following conditions:

		    - cameras boresight should be at 32 degrees below main plane (XZ)
			- cameras boresight projections to XZ plane should be:
			    - at  +45 degrees relative to +Y axis for SP_TS_CAM_1,
				- at  -45 degrees relative to +Y axis for SP_TS_CAM_2,
				- at -135 degrees relative to +Y axis for SP_TS_CAM_3,
				- at +135 degrees relative to +Y axis for SP_TS_CAM_4.

   These diagrams illustrate the ExoMars Surface Platform Television
   System frames:

   +Xsc view (from below the platform)
   -----------------------------------


           +Zcam1               _.-----._
             ^              _.-'         '-._               +Zcam2
              '.        _.-'                 '-._          .^
                '.  _.-'   .^ +Ycam1             '-._   .-'         
                .-'.    .-'                          .-'_           
              -'    'o-'                           o'    '-           
             /                                      '.     \             
            /       SP_TS_CAM_1           SP_TS_CAM_2 '.    \               
           /                                            v    \                
          /                                           +Ycam2  \                 
         /                                                     \                
        /                                                       \              
       /                            ^ +Zsc                       \          
      /                             |                             \       
     /                              |                              \     
    .                       +Ysc    |                               .   
    |                        <------o                               |  
    |                                 +Xsc                          |
    '                                                               '
     \                                                             /
      \                                                           /
       \                                                         /
        \                                                       /
         \                                                     /
          \   ^.                                              /
           \    '.  SP_TS_CAM_4           SP_TS_CAM_3        /
            \     '.                                        /
             \_     'o                            .o      _/
               '-. .'                          .-'  '._.-'
                 .''-._                     .-'   _.-''.
               .'      '-._                v  _.-'      '.
              v            '-._           _.-'            v
                               '-._____.-'


    +Ycam1 view (side view to camera)
    ---------------------------------
    
                              _.-'-.
                             '-.    '-.
                             o  '-.    '-.
                           32      '-._   '-.
               +Zcam1 <---------------o'-.   '-.
                                +Ycam1|   '-.   '-.
                                      |      '-.   '-.
                                      |         '-.  PLATFORM
                                      v
                                    +Xcam1 
                                     

    +Xsc view, camera orientation in XZsc plane
    -------------------------------------------
    
                   +Zsc
                    ^
       +Zcam1     o |    o  +Zcam2
             ^  45  |  45  ^
              '.    |    .'
                '.  |  .'
                  '.|.'
                    |
        +Ysc <------o +Xsc
                    |
                   .|.
                 .' | '. 
               .'   |   '.
             .'  o  |   o '.
            v  45   | 45    v     
      +Zcam4        |        +Zcam3


   These sets of keywords define the ExoMars Surface Platform Television
   cameras frames:

   \begindata

      FRAME_SP_TS_CAM_BASE             = -173920
      FRAME_-173920_NAME               = 'SP_TS_CAM_BASE'
      FRAME_-173920_CLASS              =  4
      FRAME_-173920_CLASS_ID           =  -173920
      FRAME_-173920_CENTER             =  -173
      TKFRAME_-173920_RELATIVE         = 'SP_LANDER'
      TKFRAME_-173920_SPEC             = 'ANGLES'
      TKFRAME_-173920_UNITS            = 'DEGREES'
      TKFRAME_-173920_AXES             = (   1,   2,   3  )
      TKFRAME_-173920_ANGLES           = ( 0.0, 0.0, 0.0  )

      FRAME_SP_TS_CAM_1                = -173921
      FRAME_-173921_NAME               = 'SP_TS_CAM_1'
      FRAME_-173921_CLASS              =  4
      FRAME_-173921_CLASS_ID           =  -173921
      FRAME_-173921_CENTER             =  -173911
      TKFRAME_-173921_RELATIVE         = 'SP_TS_CAM_BASE'
      TKFRAME_-173921_SPEC             = 'ANGLES'
      TKFRAME_-173921_UNITS            = 'DEGREES'
      TKFRAME_-173921_AXES             = (      1,   2,     3  )
      TKFRAME_-173921_ANGLES           = (  -45.0, 0.0, -32.0  )

      FRAME_SP_TS_CAM_2                = -173922
      FRAME_-173922_NAME               = 'SP_TS_CAM_2'
      FRAME_-173922_CLASS              =  4
      FRAME_-173922_CLASS_ID           =  -173922
      FRAME_-173922_CENTER             =  -173912
      TKFRAME_-173922_RELATIVE         = 'SP_TS_CAM_BASE'
      TKFRAME_-173922_SPEC             = 'ANGLES'
      TKFRAME_-173922_UNITS            = 'DEGREES'
      TKFRAME_-173922_AXES             = (      1,   2,     3  )
      TKFRAME_-173922_ANGLES           = ( -135.0, 0.0, -32.0  )

      FRAME_SP_TS_CAM_3                = -173923
      FRAME_-173923_NAME               = 'SP_TS_CAM_3'
      FRAME_-173923_CLASS              =  4
      FRAME_-173923_CLASS_ID           =  -173923
      FRAME_-173923_CENTER             =  -173913
      TKFRAME_-173923_RELATIVE         = 'SP_TS_CAM_BASE'
      TKFRAME_-173923_SPEC             = 'ANGLES'
      TKFRAME_-173923_UNITS            = 'DEGREES'
      TKFRAME_-173923_AXES             = (      1,   2,    3  )
      TKFRAME_-173923_ANGLES           = (  135.0, 0.0, 32.0  )

      FRAME_SP_TS_CAM_4                = -173924
      FRAME_-173924_NAME               = 'SP_TS_CAM_4'
      FRAME_-173924_CLASS              =  4
      FRAME_-173924_CLASS_ID           =  -173924
      FRAME_-173924_CENTER             =  -173914
      TKFRAME_-173924_RELATIVE         = 'SP_TS_CAM_BASE'
      TKFRAME_-173924_SPEC             = 'ANGLES'
      TKFRAME_-173924_UNITS            = 'DEGREES'
      TKFRAME_-173924_AXES             = (     1,   2,    3  )
      TKFRAME_-173924_ANGLES           = (  45.0, 0.0, 32.0  )
      
   \begintext

 
ExoMars Surface Platform NAIF ID Codes -- Definitions
===============================================================================

   This section contains name to NAIF ID mappings for the ExoMarsRSP mission.
   Once the contents of this file is loaded into the KERNEL POOL, these
   mappings become available within SPICE, making it possible to use names
   instead of ID code in the high level SPICE routine calls.

      Name                      ID         Synonyms
      ------------------------  --------   ------------------------------

      EXOMARS SURFACE PLATFORM    -173     (synonyms:
                                            EXOMARS RSP SURFACE PLATFORM,
                                            EXOMARS RSP SP,
                                            EM RSP SP)

      LARA                        -197     (synonyms:
                                            EXOMARS LARA,
                                            EXOMARS RSP LARA)

      LARA_ANT_TX1               -197001
      LARA_ANT_TX2               -197002
      LARA_ANT_RX                -197003

      SP_TS_CAM_1                -173011
      SP_TS_CAM_2                -173012
      SP_TS_CAM_3                -173013
      SP_TS_CAM_4                -173014
    
                                            
   The mappings summarized in this table are implemented by the keywords
   below.

   \begindata

      NAIF_BODY_NAME += ( 'EXOMARS RSP SURFACE PLATFORM' )
      NAIF_BODY_CODE += ( -173                           )
      
      NAIF_BODY_NAME += ( 'EM RSP SP'                    )
      NAIF_BODY_CODE += ( -173                           )

      NAIF_BODY_NAME += ( 'EXOMARS RSP SP'               )
      NAIF_BODY_CODE += ( -173                           )

      NAIF_BODY_NAME += ( 'EXOMARS SURFACE PLATFORM'     )
      NAIF_BODY_CODE += ( -173                           )

      NAIF_BODY_NAME += ( 'EXOMARS LARA'                 )
      NAIF_BODY_CODE += ( -197                           )

      NAIF_BODY_NAME += ( 'EXOMARS RSP LARA'             )
      NAIF_BODY_CODE += ( -197                           )

      NAIF_BODY_NAME += ( 'LARA'                         )
      NAIF_BODY_CODE += ( -197                           )

      NAIF_BODY_NAME += ( 'LARA_ANT_TX1'                 )
      NAIF_BODY_CODE += ( -197001                        )

      NAIF_BODY_NAME += ( 'LARA_ANT_TX2'                 )
      NAIF_BODY_CODE += ( -197002                        )

      NAIF_BODY_NAME += ( 'LARA_ANT_RX'                  )
      NAIF_BODY_CODE += ( -197003                        )

      NAIF_BODY_NAME += ( 'SP_TS_CAM_1'                  )
      NAIF_BODY_CODE += ( -173011                        )

      NAIF_BODY_NAME += ( 'SP_TS_CAM_2'                  )
      NAIF_BODY_CODE += ( -173012                        )

      NAIF_BODY_NAME += ( 'SP_TS_CAM_3'                  )
      NAIF_BODY_CODE += ( -173013                        )

      NAIF_BODY_NAME += ( 'SP_TS_CAM_4'                  )
      NAIF_BODY_CODE += ( -173014                        )

  \begintext
  
  
End of FK file.