#ifndef VISIVO_H
#define VISIVO_H

#include "visivoserver.h"
#define VV_PARAM 1000 //number of VisIVOViewer STARTING PARAMS
#define VI_PARAM 0 //number of VisIVOImporter STARTING PARAMS
#define VF_PARAM 2000 //number of VisIVOFilter STARTING PARAMS
#define NPAR 1000 //number of PARAMS for each VisIVOServer components
#define MAXCOLNAMESIZE 50;
// Define Filter Setting Code
// generic
#define VF_SET_OPERATION 2000
#define VF_SET_FILEVBT 2001
#define VF_SET_FIELD 2002
#define VF_SET_OUTCOL 2003
#define VF_SET_OUTVBT 2004
#define VF_SET_APPEND 2005
#define VF_SET_NOAPPEND 2020
#define VF_SET_LIMITS 2006
#define VF_SET_LIMITSPURGE 2007
#define VF_SET_OPERATORAND 2008
#define VF_SET_OPERATOROR 2009
#define VF_SET_RESOLUTION 2010
#define VF_SET_POINTCOLUMNS 2011
#define VF_SET_ALGORITHMTSC 2012
#define VF_SET_ALGORITHMNGP 2013
#define VF_SET_ALGORITHMCIC 2014
#define VF_SET_GRIDORIGIN 2015
#define VF_SET_GRIDSPACING 2016
#define VF_SET_BOX 2017
#define VF_SET_PERIODIC 2018
#define VF_SET_NOPERIODIC 2019
// specific
#define VF_SET_MERGELIST 2126
#define VF_SET_MERGELISTPURGE 2146
#define VF_SET_RANDOMPERC 2100
#define VF_SET_RANDOMSEED 2101
#define VF_SET_ADDIDSTART 2102
#define VF_SET_APPENDLIST 2103
#define VF_SET_APPENDLISTPURGE 2104
#define VF_SET_NEWCOLNAMES 2105
#define VF_SET_VOLUMEPERC 2106
#define VF_SET_NEWRES 2107
#define VF_SET_CUTTHRESHOLD 2108
#define VF_SET_DECIMATORSKIP 2109
#define VF_SET_EXTRACTIONGEOMETRY 2110
#define VF_SET_EXTRACTIONGEOMETRYPURGE 2111
#define VF_SET_STARTINGCELL 2112
#define VF_SET_DENSITY 2113
#define VF_SET_VOLUME 2114
#define VF_SET_NUMBIN 2115
#define VF_SET_INTERVAL 2116
#define VF_SET_INFILES 2117
#define VF_SET_CENTER 2118
#define VF_SET_RADIUS 2119
#define VF_SET_OUTVALUE 2120
#define VF_SET_INVALUE 2121
#define VF_SET_MATEXPRESSION 2122
#define VF_SET_MERGEHUGE 2123
#define VF_SET_MERGESMALL 2124
#define VF_SET_MERGEPAD 2125
#define VF_SET_NODENSITY 2127
#define VF_SET_AVG 2128
#define VF_SET_DELETECOLUMNS 2129
#define VF_SET_NUMROWS 2130
#define VF_SET_RANGEROWS 2131
#define VF_SET_WIDTH 2132
#define VF_SET_PRECISION 2133
#define VF_SET_OUT 2134
#define VF_SET_NUMCELLS 2135
#define VF_SET_NSIGMA 2136
#define VF_SET_ALLCOLUMNS 2137
#define VF_SET_VOLUMESPLIT 2138
#define VF_SET_NUMOFTABLES 2139
#define VF_SET_MAXSIZETABLE 2140
#define VF_SET_HUGESPLIT 2141
#define VF_SET_SWAPOVERRIDE 2142
#define VF_SET_VISUALSIZE 2143
#define VF_SET_WRVOTABLEFORCE 2144
#define VF_SET_HISTOGRAMBIN 2145
#define VF_SET_VISUALLIST 2147
#define VF_SET_VISUALLISTPURGE 2148
#define VF_SET_LFNOUT 2149
#define VF_SET_VO 2150
#define VF_SET_SE 2151
#define VF_SET_MRPOS 2152
#define VF_SET_MRGEOMETRY 2153
#define VF_SET_MRGEOMETRYPURGE 2154
#define VF_SET_MRBACKGROUND 2155
#define VF_SET_DIMVOX 2156
#define VF_SET_TRACKPLANEDIST 2157
#define VF_SET_INNERDIST 2158
#define VF_SET_OUTPOINTS 2159
#define VF_SET_OUTVOL 2160


// Define Importer Setting Code
#define VI_SET_FFORMAT 0
#define VI_SET_FILEPATH 999  // must be the last
#define VI_SET_OUTFILEVBT 1
#define VI_SET_VOLUME 2
#define VI_SET_USERPWD 3
#define VI_SET_BINARYHEADER 4
#define VI_SET_MISSINGVALUE 5
#define VI_SET_TEXTVALUE 6
#define VI_SET_BIGENDIAN 7
#define VI_SET_DOUBLE 8
#define VI_SET_NPOINTS 9
#define VI_SET_DATASETLIST 10
#define VI_SET_HYPERSLAB 11
#define VI_SET_VO 12
#define VI_SET_LFNOUT 13
#define VI_SET_SE 14


// Define Viewer Setting Code
#define VV_SET_CLEAN 1000
#define VV_SET_FILEVBT 1499  //must be the last parameter in args
#define VV_SET_INTERNAL 1500
#define VV_SET_EXTERNAL 1069
#define VV_SET_INTERNALFIELD 1503
#define VV_SET_INTERNALVFIELD 1504
#define VV_SET_INTERNALCOLORSCALAR 1505
#define VV_SET_FIELD 1003
#define VV_SET_COLOR 1004
#define VV_SET_COLORSCALAR 1005
#define VV_SET_BOX 1006
#define VV_SET_PALETTE 1007
#define VV_SET_AXES 1008
#define VV_SET_DEFAULTIMAGES 1009
#define VV_SET_VFIELD 1030
#define VV_SET_OUT 1031
#define VV_SET_AZIMUTH 1032
#define VV_SET_ELEVATION 1033
#define VV_SET_ZOOM 1034
#define VV_SET_CAMERA 1035
#define VV_SET_IMAGESIZE 1036
#define VV_SET_BACKCOLOR 1037
#define VV_SET_ONECOLOR 1038
#define VV_SET_COLORRANGE 1039
#define VV_SET_COLORRANGEFROM 1040
#define VV_SET_COLORRANGETO 1041
#define VV_SET_STEREO 1042
#define VV_SET_ANAGLYPHMASK 1043
#define VV_SET_ANAGLYPHSAT 1044
#define VV_SET_OPACITY 1057
#define VV_SET_OPACITYTF 1058
#define VV_SET_CAMPOS 1511
#define VV_SET_CAMFP 1512
#define VV_SET_CLIPLARGE 1513
#define VV_SET_CLIPRANGE 1514

// cycle
#define VV_SET_CYCLE 1045
#define VV_SET_CYCLEOFFSET 1046

#define VV_SET_SCALE 1047
#define VV_SET_LOGSCALE 1048
#define VV_SET_GLYPHS 1049
#define VV_SET_RADIUS 1050
#define VV_SET_HEIGHT 1051
#define VV_SET_SCALEGLYPHS 1052
#define VV_SET_RADIUSSCALAR 1053
#define VV_SET_HEIGHTSCALAR 1054
#define VV_SET_INTERNALRADIUSSCALAR 1506
#define VV_SET_INTERNALHEIGHTSCALAR 1507
#define VV_SET_SPL_INTERNALLABINTENSITY 1508
#define VV_SET_SPL_INTERNALLABCOLOR 1509
#define VV_SET_SPL_INTERNALLABHSML 1510

////
#define VV_SET_VOLUME 1020
#define VV_SET_SLICE 1021
#define VV_SET_ISOSURFACE 1022
#define VV_SET_VOLUMERENDERING 1068
#define VV_SET_COLORTABLE 1023
#define VV_SET_INTERNALVRENDERFIELD 1524
#define VV_SET_VRENDERFIELD 1024
#define VV_SET_SLICEFIELD 1025
#define VV_SET_ISOSURFIELD 1026
#define VV_SET_SLICEPLANE 1027
#define VV_SET_SLICEPOS 1028
#define VV_SET_VECTOR 1029
#define VV_SET_SHADOW 1059
#define VV_SET_ISOSURVALUE 1060
#define VV_SET_WIREFRAME 1061
#define VV_SET_ISOSMOOTH 1062
#define VV_SET_SLICEPLANEPOINT 1063
#define VV_SET_SLICEPLANENORMAL 1064
#define VV_SET_VECTORLINE 1065
#define VV_SET_VECTORSCALINGFACTOR 1066
#define VV_SET_VECTORSCALE 1067

//// SPLOTCH SECT 
#define VV_SET_SPL_INTENSITYMIN0 1105
#define VV_SET_SPL_INTENSITYMAX0 1106
#define VV_SET_SPLOTCH 1100
#define VV_SET_SPL_INTENSITYLOG0 1104

#define VV_SET_SPL_SIZEFIX0 1107
#define VV_SET_SPL_SIZEFAC0 1108
#define VV_SET_SPL_COLORISVECTOR0 1109
#define VV_SET_SPL_XRES 1110
#define VV_SET_SPL_YRES 1111
#define VV_SET_SPL_FOV 1112
#define VV_SET_SPL_GRAYABSORBTION 1114
#define VV_SET_SPL_BRIGHTNESS0 1115

#define VV_SET_SPL_COLORLOG0 1120
#define VV_SET_SPL_COLORASINH0 1120
#define VV_SET_SPL_ROLSKY_X 1121
#define VV_SET_SPL_ROLSKY_Y 1122
#define VV_SET_SPL_ROLSKY_Z 1123

//  GLITE

#define VV_SET_VO 1124
#define VV_SET_LFNOUT 1125
#define VV_SET_SE 1126




//// Error codes
#define noError 0
#define invalidParCode 1
#define invalidFFormatCode 2
#define invalidVBT 3
#define invalidPathCreation 4
#define invalidVBTMetadata 5
#define invalidPointers 6
#define invalidFilterOptions 7
#define invalidFilterOperation 8
#define invalidImporterOptions 9
#define invalidImporterOperation 10
#define invalidInternalData 11
#define invalidImage 12
#define invaldInputFile 16


#define runningThread 13
#define errorThread 14
#define successfulEndThread 15
#define undefined 17

///// Others
#define NOSET_CAM -123456789

#endif

