/*
 * Copyright 1993-2007 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO USER:
 *
 * This source code is subject to NVIDIA ownership rights under U.S. and
 * international Copyright laws.  Users and possessors of this source code
 * are hereby granted a nonexclusive, royalty-free license to use this code
 * in individual and commercial software.
 *
 * NVIDIA MAKES NO REPRESENTATION ABOUT THE SUITABILITY OF THIS SOURCE
 * CODE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY OF ANY KIND.  NVIDIA DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOURCE CODE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY, NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL,
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS,  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION,  ARISING OUT OF OR IN CONNECTION WITH THE USE
 * OR PERFORMANCE OF THIS SOURCE CODE.
 *
 * U.S. Government End Users.   This source code is a "commercial item" as
 * that term is defined at  48 C.F.R. 2.101 (OCT 1995), consisting  of
 * "commercial computer  software"  and "commercial computer software
 * documentation" as such terms are  used in 48 C.F.R. 12.212 (SEPT 1995)
 * and is provided to the U.S. Government only as a commercial end item.
 * Consistent with 48 C.F.R.12.212 and 48 C.F.R. 227.7202-1 through
 * 227.7202-4 (JUNE 1995), all U.S. Government End Users acquire the
 * source code with only those rights set forth herein.
 *
 * Any use of this source code in individual and commercial software must
 * include, in the user documentation and internal comments to the code,
 * the above Disclaimer and U.S. Government End Users Notice.
 */

/* This sample queries the properties of the CUDA devices present in the system. */

// includes, system
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

// includes, project
#include <cuda.h>

int check_device(int rank)
{
    int deviceCount;
    cudaGetDeviceCount(&deviceCount);
    if (deviceCount == 1)
    {
      cudaDeviceProp deviceProp;
      cudaGetDeviceProperties(&deviceProp, 0);
      if (deviceProp.major == 9999 && deviceProp.minor == 9999) // emulation mode
      {
        printf("Rank %d: There is no device supporting CUDA\n", rank);
        fflush(stdout);
        return 0;
      }
    }
    return deviceCount;
}

void print_device_info(int rank, int dev)
{
   cudaDeviceProp deviceProp;
   cudaGetDeviceProperties(&deviceProp, dev);
  
    printf("\nRank %d - Device %d: \"%s\"\n", rank, dev, deviceProp.name);
    printf("  Major revision number:                         %d\n",
               deviceProp.major);
    printf("  Minor revision number:                         %d\n",
               deviceProp.minor);
    printf("  Total amount of global memory:                 %u bytes\n",
               deviceProp.totalGlobalMem);
#if CUDART_VERSION >= 2000
    printf("  Number of multiprocessors:                     %d\n",
               deviceProp.multiProcessorCount);
    printf("  Number of cores:                               %d\n",
               8 * deviceProp.multiProcessorCount);
#endif
    printf("  Total amount of constant memory:               %u bytes\n",
               deviceProp.totalConstMem); 
    printf("  Total amount of shared memory per block:       %u bytes\n",
               deviceProp.sharedMemPerBlock);
    printf("  Total number of registers available per block: %d\n",
               deviceProp.regsPerBlock);
    printf("  Warp size:                                     %d\n",
               deviceProp.warpSize);
    printf("  Maximum number of threads per block:           %d\n",
               deviceProp.maxThreadsPerBlock);
    printf("  Maximum sizes of each dimension of a block:    %d x %d x %d\n",
               deviceProp.maxThreadsDim[0],
               deviceProp.maxThreadsDim[1],
               deviceProp.maxThreadsDim[2]);
    printf("  Maximum sizes of each dimension of a grid:     %d x %d x %d\n",
               deviceProp.maxGridSize[0],
               deviceProp.maxGridSize[1],
               deviceProp.maxGridSize[2]);
    printf("  Maximum memory pitch:                          %u bytes\n",
               deviceProp.memPitch);
    printf("  Texture alignment:                             %u bytes\n",
               deviceProp.textureAlignment);
    printf("  Clock rate:                                    %.2f GHz\n",
               deviceProp.clockRate * 1e-6f);
#if CUDART_VERSION >= 2000
    printf("  Concurrent copy and execution:                 %s\n",
               deviceProp.deviceOverlap ? "Yes" : "No");
#endif
    if(!deviceProp.deviceOverlap)
	printf("Device will not handle overlaps, so no speed up from streams \n");
}
