 /***************************************************************************
 *   Copyright (C) 2008 by Ugo Becciani   *
 *   ugo.becciani@oact.inaf.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef VSPOINTDISTRIBUTEOP_H
#define VSPOINTDISTRIBUTEOP_H
#include "vstableop.h"

/**
	@author Ugo Becciani <ugo.becciani@oact.inaf.it>
*/
class VSPointDistributeOp: public VSTableOp

{  
  static const unsigned int MAX_NUMBER_TO_REDUCE_ROW;
  static const unsigned int MIN_NUMBER_OF_ROW;
  unsigned int m_sampleDimensions[3];
  double m_modelBounds[6];
  double m_nullValue;
  double m_massUnity;
  unsigned int m_colList[3];	

  int m_splattedScalar;
  unsigned long long int m_numNewPts;
  bool m_useConstant;
  unsigned int m_nOfCol;
  unsigned int m_nOfRow;
  float **m_fArray;
  float **m_grid;
  float m_origin[3];
  float m_spacing[3];
  float m_constValue;
  bool m_executeDone;
  bool m_tsc;
  bool m_cic;
  bool m_ngp;
  bool setOrigin();
  bool setSpacing();
  bool m_OriginSet;
  bool m_SpacingSet;
  bool m_gridSpacing;
  bool m_avg;

  bool allocateArray(int nField);
  bool allocateArray(int nField, bool isMP);
  bool computeModelBounds();

public:
    VSPointDistributeOp();
    ~VSPointDistributeOp();
    void printHelp();
    bool execute();
    bool getOrigin(float *origin); 
    bool getSpacing(float *spacing); 
};

#endif
