/***************************************************************************
 *   Copyright (C) 2008 by Gabriella Caniglia *
 *  gabriella.caniglia@oact.inaf.it *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <cstdlib>
#include <cstring>

#include "luteditor.h"
#include "color.h"
#include "optionssetter.h"

#include "vtkLookupTable.h"


//---------------------------------------------------------------------
void SelectLookTable(VisIVOServerOptions *opt, vtkLookupTable *lut)
//---------------------------------------------------------------------
{
  int idx=opt->nColorTable;
  switch(idx)
  {
    case 0:  lutDefault(opt,lut);        break;  
    case 1:  lutDefaultStep(opt,lut);    break;  
    case 2:  lutEField(opt,lut);         break;  
    case 3:  lutGlow(opt,lut);           break;  
    case 4:  lutGray(opt,lut);           break;  
    case 5:  lutMinMax(opt,lut);         break;  
    case 6:  lutPhysicsContour(opt,lut); break;  
    case 7:  lutPureRed(opt,lut);        break;  
    case 8:  lutPureGreen(opt,lut);      break;  
    case 9:  lutPureBlue(opt,lut);       break;  
    case 10:  lutRun1(opt,lut);          break;  
    case 11: lutRun2(opt,lut);           break;  
    case 12: lutSar(opt,lut);            break;  
    case 13: lutTemperature(opt,lut);    break;  
    case 14: lutTenStep(opt,lut);        break;  
    case 15: lutVolRenGlow(opt,lut);     break;  
    case 16: lutVolRenGreen(opt,lut);    break;  
    case 17: lutVolRenRGB(opt,lut);      break;  
    case 18: lutVolRenTwoLev(opt,lut);   break;  

    case 19: lutAllYellow(opt,lut);      break;
    case 20: lutAllCyane(opt,lut);      break;
    case 21: lutAllViolet(opt,lut);      break;
    case 22: lutAllWhite(opt,lut);      break;
    case 23: lutAllBlack(opt,lut);      break;
    case 24: lutAllRed(opt,lut);      break;
    case 25: lutAllGreen(opt,lut);      break;
    case 26: lutAllBlu(opt,lut);      break;

    case -1: lutFile(opt,lut);	         break;
    default: lutDefault(opt,lut);        break;  
  }
}
//---------------------------------------------------------------------
void lutVolRenGreen(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
  //VolRenGreen
  unsigned char v[256*4] = 
  {
    0, 0, 255, 0,
    0, 1, 253, 0,
    0, 3, 252, 1,
    0, 5, 251, 1,
    0, 7, 249, 2,
    0, 9, 248, 3,
    0, 11, 247, 3,
    0, 13, 245, 4,
    0, 14, 244, 5,
    0, 16, 243, 5,
    0, 18, 241, 6,
    0, 20, 240, 6,
    0, 22, 239, 7,
    0, 24, 237, 8,
    0, 26, 236, 8,
    0, 28, 235, 9,
    0, 29, 233, 10,
    0, 31, 232, 10,
    0, 33, 231, 11,
    0, 35, 229, 11,
    0, 37, 228, 12,
    0, 39, 227, 13,
    0, 41, 225, 13,
    0, 43, 224, 14,
    0, 44, 223, 15,
    0, 46, 221, 15,
    0, 48, 220, 16,
    0, 50, 219, 16,
    0, 52, 217, 17,
    0, 54, 216, 18,
    0, 56, 215, 18,
    0, 58, 213, 19,
    0, 59, 212, 20,
    0, 61, 211, 20,
    0, 63, 209, 21,
    0, 65, 208, 21,
    0, 67, 207, 22,
    0, 69, 206, 23,
    0, 71, 204, 23,
    0, 73, 203, 24,
    0, 75, 202, 25,
    0, 76, 200, 25,
    0, 78, 199, 26,
    0, 80, 198, 26,
    0, 82, 196, 27,
    0, 84, 195, 28,
    0, 86, 194, 28,
    0, 88, 192, 29,
    0, 89, 191, 30,
    0, 91, 190, 30,
    0, 93, 188, 31,
    0, 95, 187, 31,
    0, 97, 186, 32,
    0, 99, 184, 33,
    0, 101, 183, 33,
    0, 103, 182, 34,
    0, 105, 180, 35,
    0, 106, 179, 35,
    0, 108, 178, 36,
    0, 110, 176, 36,
    0, 112, 175, 37,
    0, 114, 174, 38,
    0, 116, 172, 38,
    0, 118, 171, 39,
    0, 119, 170, 40,
    0, 121, 168, 40,
    0, 123, 167, 41,
    0, 125, 166, 41,
    0, 127, 164, 42,
    0, 129, 163, 43,
    0, 131, 162, 43,
    0, 133, 160, 44,
    0, 135, 159, 45,
    0, 136, 158, 45,
    0, 138, 157, 46,
    0, 140, 155, 46,
    0, 142, 154, 47,
    0, 144, 153, 48,
    0, 146, 151, 48,
    0, 148, 150, 49,
    0, 149, 149, 50,
    0, 151, 147, 50,
    0, 153, 146, 51,
    0, 155, 145, 51,
    0, 157, 143, 52,
    0, 159, 142, 53,
    0, 161, 141, 53,
    0, 163, 139, 54,
    0, 165, 138, 55,
    0, 166, 137, 55,
    0, 168, 135, 56,
    0, 170, 134, 56,
    0, 172, 133, 57,
    0, 174, 131, 58,
    0, 176, 130, 58,
    0, 178, 129, 59,
    0, 179, 127, 60,
    0, 181, 126, 60,
    0, 183, 125, 61,
    0, 185, 123, 61,
    0, 187, 122, 62,
    0, 189, 121, 63,
    0, 191, 119, 63,
    0, 193, 118, 64,
    0, 195, 117, 65,
    0, 196, 115, 65,
    0, 198, 114, 66,
    0, 200, 113, 66,
    0, 202, 111, 67,
    0, 204, 110, 68,
    0, 206, 109, 68,
    0, 208, 108, 69,
    0, 210, 106, 70,
    0, 211, 105, 70,
    0, 213, 104, 71,
    0, 215, 102, 71,
    0, 217, 101, 72,
    0, 219, 100, 73,
    0, 221, 98, 73,
    0, 223, 97, 74,
    0, 225, 96, 75,
    0, 226, 94, 75,
    0, 228, 93, 76,
    0, 230, 92, 76,
    0, 232, 90, 77,
    0, 234, 89, 78,
    0, 236, 88, 78,
    0, 238, 86, 79,
    0, 239, 85, 80,
    0, 241, 84, 80,
    0, 243, 82, 81,
    0, 245, 81, 81,
    0, 247, 80, 82,
    0, 249, 78, 83,
    0, 251, 77, 83,
    0, 253, 76, 84,
    0, 255, 74, 85,
    1, 254, 75, 85,
    3, 255, 76, 86,
    5, 254, 76, 86,
    7, 255, 77, 87,
    9, 255, 78, 88,
    11, 255, 78, 88,
    13, 255, 79, 89,
    15, 255, 80, 90,
    17, 255, 80, 90,
    19, 255, 81, 91,
    21, 255, 82, 91,
    22, 255, 82, 92,
    24, 255, 83, 93,
    26, 255, 84, 93,
    28, 255, 84, 94,
    30, 255, 85, 95,
    32, 255, 86, 95,
    34, 255, 86, 96,
    36, 255, 87, 96,
    38, 255, 88, 97,
    40, 255, 88, 98,
    42, 255, 89, 98,
    43, 255, 90, 99,
    45, 255, 90, 100,
    47, 255, 91, 100,
    49, 255, 92, 101,
    51, 255, 92, 101,
    53, 255, 93, 102,
    55, 255, 94, 103,
    57, 254, 94, 103,
    59, 255, 95, 104,
    61, 254, 96, 105,
    63, 255, 96, 105,
    65, 255, 97, 106,
    66, 255, 98, 106,
    68, 255, 98, 107,
    70, 255, 99, 108,
    72, 255, 100, 108,
    74, 255, 100, 109,
    76, 255, 101, 110,
    78, 255, 102, 110,
    80, 255, 102, 111,
    82, 255, 103, 111,
    84, 255, 104, 112,
    86, 255, 104, 113,
    87, 255, 105, 113,
    89, 255, 106, 114,
    91, 255, 106, 115,
    93, 255, 107, 115,
    95, 255, 108, 116,
    97, 255, 108, 117,
    99, 254, 109, 117,
    101, 255, 110, 118,
    103, 254, 110, 118,
    105, 255, 111, 119,
    107, 255, 112, 120,
    109, 255, 112, 120,
    110, 255, 113, 121,
    112, 255, 114, 122,
    114, 255, 114, 122,
    116, 255, 115, 123,
    118, 255, 116, 123,
    120, 255, 116, 124,
    122, 255, 117, 125,
    124, 255, 118, 125,
    126, 255, 118, 126,
    128, 255, 119, 127,
    130, 255, 120, 127,
    131, 255, 120, 128,
    133, 255, 121, 128,
    135, 254, 122, 129,
    137, 255, 122, 130,
    139, 254, 123, 130,
    141, 255, 124, 131,
    143, 255, 124, 132,
    145, 255, 125, 132,
    147, 255, 126, 133,
    149, 255, 126, 133,
    151, 255, 127, 134,
    153, 255, 128, 135,
    154, 255, 128, 135,
    156, 255, 129, 136,
    158, 255, 130, 137,
    160, 255, 130, 137,
    162, 255, 131, 138,
    164, 255, 132, 138,
    166, 255, 132, 139,
    168, 255, 133, 140,
    170, 255, 134, 140,
    172, 254, 134, 141,
    174, 255, 135, 142,
    175, 255, 136, 142,
    177, 255, 136, 143,
    179, 254, 137, 143,
    181, 255, 138, 144,
    183, 255, 138, 145,
    185, 255, 139, 145,
    187, 255, 140, 146,
    189, 255, 140, 147,
    191, 255, 141, 147,
    193, 255, 142, 148,
    195, 255, 142, 148,
    197, 254, 143, 149,
    198, 255, 144, 150,
    200, 254, 144, 150,
    202, 255, 145, 151,
    204, 255, 146, 152,
    206, 255, 146, 152,
    208, 255, 147, 153,
    210, 255, 148, 153,
    212, 255, 148, 154,
    214, 255, 149, 155,
    216, 254, 150, 155,
    218, 255, 150, 156,
    219, 255, 151, 157,
    221, 255, 152, 157,
    223, 255, 152, 158,
    225, 255, 153, 158,
    227, 255, 154, 159
  };
  if(opt->splotch)
  {
  	for(int i=0; i<256; i++)
  	{
    		int k = i*4; 
		opt->extPalR.push_back(v[k]/255.0);
		opt->extPalG.push_back(v[k+1]/255.0);
		opt->extPalB.push_back(v[k+2]/255.0);
		opt->extPalA.push_back(v[k+3]/255.0);
 	}
	return;	
   }
  lut->SetNumberOfTableValues(256);
  for(int i=0; i<256; i++)
  {
    int k = i*4; 
    lut->SetTableValue(i, v[k]/255.0, v[k+1]/255.0, v[k+2]/255.0, v[k+3]/255.0);
  }
};

//---------------------------------------------------------------------
void lutVolRenGlow(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
  //volrenGlow
  unsigned char v[256*4] = 
  {
    0, 0, 0, 0, 
    0, 0, 0, 1, 
    5, 0, 0, 2, 
    5, 0, 0, 3, 
    9, 0, 0, 4, 
    9, 0, 0, 5, 
    13, 0, 0, 6, 
    13, 0, 5, 7, 
    17, 0, 5, 8, 
    17, 0, 5, 9, 
    21, 0, 5, 10, 
    21, 0, 5, 11, 
    25, 0, 5, 12, 
    25, 0, 5, 13, 
    29, 0, 5, 14, 
    29, 0, 9, 15, 
    33, 0, 9, 16, 
    33, 0, 9, 17, 
    37, 0, 9, 18, 
    37, 0, 9, 19, 
    41, 0, 9, 20, 
    41, 0, 9, 21, 
    45, 0, 9, 22, 
    45, 0, 9, 23, 
    49, 0, 13, 24, 
    49, 0, 13, 25, 
    53, 0, 13, 26, 
    53, 0, 13, 27, 
    57, 0, 13, 28, 
    57, 0, 13, 29, 
    61, 0, 13, 30, 
    61, 5, 13, 31, 
    65, 5, 13, 32, 
    65, 5, 13, 33, 
    69, 5, 13, 34, 
    69, 5, 13, 35, 
    73, 5, 17, 36, 
    73, 5, 17, 37, 
    77, 5, 17, 38, 
    81, 5, 17, 39, 
    81, 5, 17, 40, 
    85, 5, 17, 41, 
    85, 5, 17, 42, 
    89, 5, 17, 43, 
    89, 9, 17, 44, 
    93, 9, 17, 45, 
    93, 9, 17, 46, 
    97, 9, 17, 47, 
    97, 9, 17, 48, 
    101, 9, 17, 49, 
    101, 9, 17, 50, 
    105, 9, 17, 51, 
    105, 9, 17, 52, 
    109, 13, 17, 53, 
    109, 13, 17, 54, 
    113, 13, 17, 55, 
    113, 13, 17, 56, 
    117, 13, 17, 57, 
    117, 13, 17, 58, 
    121, 13, 17, 59, 
    125, 13, 17, 60, 
    125, 13, 17, 61, 
    128, 17, 17, 62, 
    128, 17, 17, 63, 
    132, 17, 21, 64, 
    132, 17, 21, 65, 
    136, 17, 21, 66, 
    136, 17, 21, 67, 
    140, 17, 21, 68, 
    140, 21, 21, 69, 
    144, 21, 21, 70, 
    144, 21, 21, 71, 
    148, 21, 21, 72, 
    148, 21, 21, 73, 
    152, 25, 21, 74, 
    152, 25, 21, 75, 
    156, 25, 21, 76, 
    156, 25, 21, 77, 
    156, 25, 21, 78, 
    160, 29, 21, 79, 
    160, 29, 21, 80, 
    164, 29, 21, 81, 
    164, 29, 21, 82, 
    168, 33, 21, 83, 
    168, 33, 21, 84, 
    168, 33, 21, 85, 
    172, 33, 21, 86, 
    172, 37, 21, 87, 
    176, 37, 21, 88, 
    176, 37, 21, 89, 
    176, 37, 21, 90, 
    180, 41, 21, 91, 
    180, 41, 21, 92, 
    180, 41, 21, 93, 
    184, 45, 21, 94, 
    184, 45, 21, 95, 
    188, 45, 21, 96, 
    188, 49, 21, 97, 
    188, 49, 21, 98, 
    192, 49, 21, 99, 
    192, 53, 21, 100, 
    192, 53, 21, 101, 
    192, 53, 21, 102, 
    196, 57, 21, 103, 
    196, 57, 21, 104, 
    196, 61, 21, 105, 
    200, 61, 21, 106, 
    200, 61, 21, 107, 
    200, 65, 21, 108, 
    200, 65, 21, 109, 
    204, 69, 21, 110, 
    204, 69, 21, 111, 
    204, 69, 21, 112, 
    208, 73, 21, 113, 
    208, 73, 21, 114, 
    208, 77, 21, 115, 
    208, 77, 21, 116, 
    208, 81, 21, 117, 
    212, 81, 21, 118, 
    212, 85, 21, 119, 
    212, 85, 21, 120, 
    212, 89, 21, 121, 
    212, 89, 21, 122, 
    216, 93, 21, 123, 
    216, 93, 21, 124, 
    216, 97, 21, 125, 
    216, 97, 21, 126, 
    216, 101, 21, 127, 
    220, 101, 21, 128, 
    220, 105, 21, 129, 
    220, 105, 21, 130, 
    220, 109, 21, 131, 
    220, 109, 21, 132, 
    220, 113, 21, 133, 
    220, 113, 21, 134, 
    224, 117, 21, 135, 
    224, 117, 25, 136, 
    224, 121, 25, 137, 
    224, 121, 25, 138, 
    224, 125, 25, 139, 
    224, 125, 25, 140, 
    224, 128, 25, 141, 
    228, 128, 25, 142, 
    228, 132, 25, 143, 
    228, 132, 29, 144, 
    228, 136, 29, 145, 
    228, 136, 29, 146, 
    228, 140, 29, 147, 
    228, 140, 29, 148, 
    228, 144, 33, 149, 
    232, 144, 33, 150, 
    232, 144, 33, 151, 
    232, 148, 33, 152, 
    232, 148, 33, 153, 
    232, 152, 37, 154, 
    232, 152, 37, 155, 
    232, 156, 37, 156, 
    232, 156, 37, 157, 
    236, 160, 41, 158, 
    236, 160, 41, 159, 
    236, 160, 41, 160, 
    236, 164, 41, 161, 
    236, 164, 45, 162, 
    236, 168, 45, 163, 
    236, 168, 45, 164, 
    236, 172, 49, 165, 
    236, 172, 49, 166, 
    236, 172, 49, 167, 
    240, 176, 53, 168, 
    240, 176, 53, 169, 
    240, 180, 53, 170, 
    240, 180, 57, 171, 
    240, 180, 57, 172, 
    240, 184, 61, 173, 
    240, 184, 61, 174, 
    240, 188, 61, 175, 
    240, 188, 65, 176, 
    240, 188, 65, 177, 
    240, 192, 69, 178, 
    244, 192, 69, 179, 
    244, 192, 73, 180, 
    244, 192, 73, 181, 
    244, 192, 77, 182, 
    244, 200, 77, 183, 
    244, 200, 81, 184, 
    244, 200, 81, 185, 
    244, 204, 85, 186, 
    244, 204, 85, 187, 
    244, 204, 89, 188, 
    244, 208, 89, 189, 
    244, 208, 93, 190, 
    244, 208, 93, 191, 
    248, 212, 97, 192, 
    248, 212, 97, 193, 
    248, 212, 101, 194, 
    248, 216, 105, 195, 
    248, 216, 105, 196, 
    248, 216, 109, 197, 
    248, 220, 109, 198, 
    248, 220, 113, 199, 
    248, 220, 113, 200, 
    248, 224, 117, 201, 
    248, 224, 121, 202, 
    248, 224, 121, 203, 
    248, 224, 125, 204, 
    248, 228, 125, 205, 
    248, 228, 128, 206, 
    248, 228, 128, 207, 
    248, 228, 132, 208, 
    248, 232, 136, 209, 
    248, 232, 136, 210, 
    252, 232, 140, 211, 
    252, 232, 144, 212, 
    252, 236, 144, 213, 
    252, 236, 148, 214, 
    252, 236, 148, 215, 
    252, 236, 152, 216, 
    252, 240, 156, 217, 
    252, 240, 156, 218, 
    252, 240, 160, 219, 
    252, 240, 160, 220, 
    252, 240, 164, 221, 
    252, 240, 168, 222, 
    252, 244, 168, 223, 
    252, 244, 172, 224, 
    252, 244, 172, 225, 
    252, 244, 176, 226, 
    252, 244, 180, 227, 
    252, 244, 180, 228, 
    252, 248, 184, 229, 
    252, 248, 188, 230, 
    252, 248, 188, 231, 
    252, 248, 192, 232, 
    252, 248, 192, 233, 
    252, 248, 196, 234, 
    252, 248, 200, 235, 
    252, 248, 200, 236, 
    252, 252, 204, 237, 
    252, 252, 208, 238, 
    252, 252, 208, 239, 
    252, 252, 212, 240, 
    252, 252, 212, 241, 
    252, 252, 216, 242, 
    252, 252, 220, 243, 
    252, 252, 220, 244, 
    252, 252, 224, 245, 
    252, 252, 228, 246, 
    252, 252, 228, 247, 
    252, 252, 232, 248, 
    252, 252, 236, 249, 
    252, 252, 236, 250, 
    252, 252, 240, 251, 
    252, 252, 244, 252, 
    252, 252, 244, 253, 
    252, 252, 248, 254, 
    255, 255, 255, 255 
  };
  if(opt->splotch)
  {
  	for(int i=0; i<256; i++)
  	{
    		int k = i*4; 
		opt->extPalR.push_back(v[k]/255.0);
		opt->extPalG.push_back(v[k+1]/255.0);
		opt->extPalB.push_back(v[k+2]/255.0);
		opt->extPalA.push_back(v[k+3]/255.0);
 	}
	return;	
   }

  lut->SetNumberOfTableValues(256);
  for(int i=0; i<256; i++)
  {
    int k = i*4; 
    lut->SetTableValue(i, v[k]/255.0, v[k+1]/255.0, v[k+2]/255.0, v[k+3]/255.0);
  }
};

//---------------------------------------------------------------------
void lutTenStep(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
  //tensteps
  unsigned char v[10*3] = 
  {
    29,  0,   134,
    0,   18,  163,
    0,   74,  188,
    0,   159, 195,
    0,   201, 150,
    0,   209, 12,
    141, 217, 0,
    220, 221, 0,
    226, 138, 0,
    231, 48,  0,
  };
  if(opt->splotch)
  {
  	for(int i=0; i<10; i++)
  	{
    		int k = i*3; 
		opt->extPalR.push_back(v[k]/255.0);
		opt->extPalG.push_back(v[k+1]/255.0);
		opt->extPalB.push_back(v[k+2]/255.0);
		opt->extPalA.push_back(255/255.0);
 	}
	return;	
   }

  lut->SetNumberOfTableValues(10);
  for(int i=0; i<10; i++)
  {
    int k = i*3; 
    lut->SetTableValue(i, v[k]/255.0, v[k+1]/255.0, v[k+2]/255.0, 1);
  }
};

//---------------------------------------------------------------------
void lutTemperature(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
  //temperature
  unsigned char v[256*3] = 
  {
    255,255,255,
    251,251,253,
    249,247,255,
    246,244,253,
    242,242,255,
    239,239,253,
    237,235,255,
    233,232,255,
    230,230,253,
    228,226,255,
    225,223,253,
    221,221,255,
    219,218,253,
    216,214,255,
    212,212,255,
    209,209,255,
    207,205,255,
    205,202,253,
    202,200,255,
    198,196,253,
    195,193,255,
    193,191,253,
    189,188,255,
    186,184,255,
    184,181,255,
    181,179,255,
    177,175,253,
    175,172,255,
    172,170,253,
    168,167,255,
    165,163,255,
    163,161,255,
    160,158,255,
    156,154,253,
    154,151,255,
    151,149,253,
    149,144,255,
    145,142,253,
    142,138,255,
    140,135,255,
    137,133,255,
    133,130,255,
    130,126,253,
    128,124,255,
    124,121,253,
    121,117,255,
    119,114,255,
    116,112,255,
    112,109,255,
    110,105,253,
    107,103,255,
    105,100,253,
    102,96,255,
    98,93,253,
    96,91,255,
    93,87,255,
    89,84,253,
    86,82,255,
    84,79,253,
    80,75,255,
    77,73,253,
    75,70,255,
    72,66,255,
    68,63,255,
    66,61,255,
    66,59,253,
    68,59,251,
    70,59,249,
    70,58,249,
    72,58,247,
    73,56,246,
    73,56,244,
    75,56,244,
    77,54,242,
    77,54,240,
    79,54,239,
    79,52,237,
    80,52,237,
    82,52,235,
    84,52,233,
    84,51,232,
    86,49,232,
    86,49,230,
    87,49,228,
    89,49,228,
    91,47,226,
    91,47,225,
    93,47,223,
    93,45,221,
    96,45,221,
    96,45,219,
    98,43,218,
    98,43,216,
    100,42,214,
    100,42,214,
    103,42,212,
    103,40,211,
    105,40,209,
    105,40,209,
    107,38,207,
    107,38,205,
    110,38,205,
    110,38,202,
    112,36,202,
    112,35,200,
    114,35,198,
    114,35,198,
    117,33,196,
    117,33,195,
    119,33,193,
    119,33,193,
    121,31,191,
    121,31,189,
    124,31,188,
    124,29,186,
    126,29,186,
    126,28,184,
    128,28,182,
    128,28,181,
    130,26,181,
    131,26,179,
    133,26,177,
    133,24,175,
    135,24,175,
    135,24,174,
    137,24,172,
    138,22,170,
    140,22,170,
    140,22,168,
    142,21,167,
    142,19,165,
    144,19,163,
    145,19,163,
    147,19,161,
    147,17,160,
    149,17,158,
    149,17,158,
    151,15,156,
    153,15,154,
    154,15,154,
    154,14,151,
    156,14,151,
    156,12,149,
    158,12,147,
    160,12,147,
    161,10,145,
    161,10,144,
    163,10,142,
    165,10,142,
    167,8,137,
    168,8,135,
    172,8,131,
    174,8,128,
    175,8,126,
    179,8,121,
    181,8,119,
    182,7,116,
    186,7,112,
    188,7,110,
    191,7,107,
    193,5,103,
    195,5,100,
    198,5,96,
    200,5,93,
    202,5,91,
    205,5,86,
    207,5,84,
    209,5,80,
    212,3,77,
    214,3,75,
    216,3,72,
    219,3,68,
    221,3,65,
    223,3,61,
    226,3,59,
    228,1,56,
    230,1,52,
    232,1,49,
    235,1,45,
    237,1,42,
    239,1,40,
    242,1,36,
    244,1,33,
    246,0,29,
    249,0,26,
    249,0,26,
    249,0,26,
    249,0,26,
    251,0,26,
    251,0,24,
    251,0,24,
    251,0,24,
    251,0,24,
    251,0,24,
    251,0,24,
    251,0,22,
    253,0,22,
    253,0,22,
    253,0,22,
    253,0,22,
    253,0,22,
    253,0,21,
    253,0,21,
    253,0,21,
    255,0,21,
    255,3,21,
    255,8,21,
    255,12,21,
    255,17,21,
    255,22,21,
    255,26,22,
    255,31,22,
    255,35,22,
    255,40,22,
    255,45,22,
    255,49,22,
    255,54,22,
    255,59,22,
    255,63,22,
    255,68,22,
    255,73,22,
    255,77,24,
    255,82,24,
    255,86,24,
    255,91,24,
    255,96,24,
    255,100,24,
    255,105,24,
    255,110,24,
    255,114,24,
    255,119,24,
    255,123,24,
    255,128,26,
    255,133,26,
    255,137,24,
    255,142,24,
    255,147,24,
    255,154,22,
    255,158,22,
    255,163,22,
    255,168,21,
    255,175,21,
    255,179,19,
    255,184,19,
    255,191,19,
    255,195,17,
    255,200,17,
    255,205,17,
    255,212,17,
    255,216,15,
    255,221,15,
    255,226,15,
    255,232,14,
    255,237,14,
    255,242,12,
    255,249,12,
  };
  if(opt->splotch)
  {
  	for(int i=0; i<256; i++)
  	{
    		int k = i*3; 
		opt->extPalR.push_back(v[k]/255.0);
		opt->extPalG.push_back(v[k+1]/255.0);
		opt->extPalB.push_back(v[k+2]/255.0);
		opt->extPalA.push_back(255/255.0);
 	}
	return;	
   }
  lut->SetNumberOfTableValues(256);

  for(int i=0; i<256; i++)
  {
    int k = i*3; 
    lut->SetTableValue(i, v[k]/255.0, v[k+1]/255.0, v[k+2]/255.0, 1);
  }
  

};

//---------------------------------------------------------------------
void lutSar(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
  //sar
  unsigned char v[256*3] = 
  {
    255,255,255,
    251,251,253,
    246,246,253,
    244,246,253,
    242,242,253,
    239,239,251,
    235,237,251,
    232,232,251,
    230,232,251,
    226,228,249,
    223,226,249,
    221,223,249,
    218,219,249,
    214,219,246,
    212,214,246,
    209,214,246,
    207,212,246,
    204,209,246,
    200,207,246,
    198,205,246,
    195,204,244,
    191,202,244,
    188,198,244,
    186,198,244,
    182,195,242,
    179,195,242,
    177,193,242,
    174,189,242,
    172,188,239,
    168,186,239,
    167,186,239,
    163,186,239,
    161,184,239,
    158,181,239,
    156,179,239,
    153,181,237,
    149,177,237,
    147,177,237,
    144,175,237,
    142,174,235,
    137,175,235,
    137,174,235,
    133,174,235,
    130,172,232,
    128,170,232,
    126,170,232,
    123,168,232,
    121,170,232,
    117,168,232,
    116,167,232,
    112,168,230,
    110,167,230,
    107,167,230,
    105,167,230,
    103,167,228,
    100,165,228,
    98,165,228,
    93,163,228,
    89,163,226,
    87,163,226,
    86,165,226,
    84,165,226,
    80,163,225,
    79,165,225,
    77,165,225,
    75,163,223,
    73,165,223,
    68,163,223,
    66,163,223,
    65,167,221,
    61,167,221,
    59,165,221,
    56,168,221,
    54,168,219,
    51,168,219,
    51,168,219,
    47,170,219,
    45,168,218,
    42,168,218,
    40,172,216,
    36,172,216,
    35,172,216,
    33,172,216,
    33,174,216,
    28,175,214,
    28,174,214,
    24,175,214,
    24,175,214,
    21,179,212,
    17,179,212,
    17,179,212,
    14,181,212,
    10,184,211,
    10,182,211,
    7,186,209,
    5,186,209,
    1,186,209,
    1,188,209,
    0,191,209,
    0,193,209,
    0,195,209,
    0,200,209,
    0,200,209,
    0,204,209,
    0,207,209,
    0,211,209,
    0,211,207,
    0,211,205,
    0,212,202,
    0,212,198,
    0,212,198,
    0,212,193,
    0,212,193,
    0,212,189,
    0,212,186,
    0,214,184,
    0,214,184,
    0,214,181,
    0,214,179,
    0,214,177,
    0,214,174,
    0,214,172,
    0,216,167,
    0,216,165,
    0,216,163,
    0,216,161,
    0,216,158,
    0,216,156,
    0,216,154,
    0,218,151,
    0,218,147,
    0,218,145,
    0,219,142,
    0,219,140,
    0,219,137,
    0,219,137,
    0,219,133,
    0,219,130,
    0,219,128,
    0,221,124,
    0,221,123,
    0,221,121,
    0,221,117,
    0,221,114,
    0,221,110,
    0,221,110,
    0,223,107,
    0,223,103,
    0,223,102,
    0,223,100,
    0,223,98,
    0,223,93,
    0,223,91,
    0,225,87,
    0,225,84,
    0,225,84,
    0,226,80,
    0,226,77,
    0,226,73,
    0,226,72,
    0,226,70,
    0,226,68,
    0,226,63,
    0,228,59,
    0,228,58,
    0,228,56,
    0,228,54,
    0,228,51,
    0,228,47,
    0,228,43,
    0,230,40,
    0,230,38,
    0,230,35,
    0,230,35,
    0,230,29,
    0,230,28,
    0,230,26,
    0,232,22,
    0,232,17,
    0,232,15,
    0,232,14,
    0,232,12,
    0,232,7,
    0,232,3,
    0,232,3,
    0,232,0,
    0,232,0,
    5,235,0,
    8,235,0,
    8,235,0,
    14,235,0,
    14,235,0,
    19,235,0,
    24,235,0,
    31,237,0,
    38,237,0,
    45,237,0,
    51,237,0,
    58,237,0,
    66,237,0,
    72,237,0,
    79,239,0,
    86,239,0,
    93,239,0,
    98,239,0,
    107,239,0,
    114,239,0,
    121,239,0,
    128,239,0,
    133,239,0,
    140,239,0,
    149,242,0,
    154,242,0,
    161,242,0,
    170,242,0,
    177,242,0,
    184,242,0,
    191,242,0,
    198,244,0,
    205,244,0,
    212,244,0,
    219,244,0,
    228,244,0,
    233,244,0,
    239,244,0,
    246,242,0,
    246,235,0,
    246,226,0,
    246,221,0,
    246,214,0,
    246,205,0,
    246,198,0,
    246,193,0,
    246,186,0,
    246,179,0,
    249,174,0,
    249,168,0,
    249,160,0,
    249,153,0,
    249,144,0,
    249,137,0,
    249,131,0,
    251,124,0,
    251,119,0,
    251,112,0,
    251,103,0,
    251,96,0,
    251,89,0,
    251,82,0,
    253,77,0,
    253,70,0,
    253,61,0,
    253,56,0,
    253,47,0,
    253,40,0,
    255,33,0
  };
  if(opt->splotch)
  {
  	for(int i=0; i<256; i++)
  	{
    		int k = i*3; 
		opt->extPalR.push_back(v[k]/255.0);
		opt->extPalG.push_back(v[k+1]/255.0);
		opt->extPalB.push_back(v[k+2]/255.0);
		opt->extPalA.push_back(255/255.0);
 	}
	return;	
   }

  lut->SetNumberOfTableValues(256);
  for(int i=0; i<256; i++)
  {
    int k = i*3; 
    lut->SetTableValue(i, v[k]/255.0, v[k+1]/255.0, v[k+2]/255.0, 1);
  }
};

//---------------------------------------------------------------------
    void lutPhysicsContour(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
  //physicsContour
  unsigned char v[256*3] = 
  {
    101, 4, 255, 
    97, 4, 253, 
    92, 4, 250, 
    89, 4, 248, 
    83, 4, 245, 
    80, 4, 243, 
    76, 4, 241, 
    73, 4, 238, 
    68, 4, 236, 
    65, 2, 233, 
    62, 2, 231, 
    57, 2, 229, 
    54, 2, 226, 
    50, 2, 224, 
    48, 2, 221, 
    43, 2, 219, 
    41, 2, 217, 
    37, 2, 214, 
    35, 2, 212, 
    31, 1, 209, 
    28, 1, 207, 
    26, 1, 204, 
    22, 1, 202, 
    19, 1, 200, 
    16, 1, 197, 
    13, 1, 195, 
    12, 0, 192, 
    9, 0, 190, 
    6, 0, 188, 
    4, 0, 185, 
    1, 0, 183, 
    0, 1, 180, 
    0, 3, 178, 
    0, 6, 176, 
    0, 8, 173, 
    0, 10, 171, 
    0, 12, 168, 
    0, 13, 166, 
    0, 15, 164, 
    0, 18, 161, 
    1, 19, 159, 
    2, 22, 156, 
    3, 24, 154, 
    3, 25, 152, 
    4, 28, 149, 
    4, 29, 147, 
    5, 31, 144, 
    6, 33, 142, 
    7, 33, 140, 
    6, 35, 137, 
    7, 37, 135, 
    8, 37, 132, 
    8, 39, 130, 
    9, 40, 128, 
    19, 84, 255, 
    20, 85, 253, 
    21, 88, 250, 
    22, 91, 248, 
    22, 94, 245, 
    23, 95, 243, 
    24, 97, 241, 
    25, 100, 238, 
    25, 102, 236, 
    26, 103, 233, 
    27, 105, 231, 
    28, 107, 229, 
    29, 109, 226, 
    29, 111, 224, 
    30, 111, 221, 
    30, 113, 219, 
    29, 116, 217, 
    29, 118, 214, 
    29, 119, 212, 
    28, 121, 209, 
    28, 123, 207, 
    28, 124, 204, 
    27, 125, 202, 
    27, 126, 200, 
    27, 128, 197, 
    26, 129, 195, 
    26, 131, 192, 
    26, 132, 190, 
    25, 133, 188, 
    25, 134, 185, 
    25, 135, 183, 
    24, 136, 180, 
    24, 137, 178, 
    23, 137, 176, 
    23, 138, 173, 
    22, 138, 171, 
    22, 139, 168, 
    21, 140, 166, 
    21, 139, 164, 
    21, 140, 161, 
    20, 140, 159, 
    20, 140, 156, 
    20, 141, 154, 
    19, 140, 152, 
    19, 140, 149, 
    19, 140, 147, 
    18, 140, 144, 
    18, 140, 142, 
    18, 140, 140, 
    17, 137, 135, 
    17, 135, 131, 
    17, 132, 127, 
    16, 130, 123, 
    16, 128, 118, 
    32, 255, 232, 
    32, 253, 226, 
    31, 250, 221, 
    31, 248, 215, 
    31, 245, 209, 
    29, 243, 203, 
    29, 241, 198, 
    29, 238, 193, 
    28, 236, 187, 
    28, 233, 181, 
    28, 231, 176, 
    27, 229, 171, 
    27, 226, 167, 
    27, 224, 158, 
    26, 221, 151, 
    26, 219, 144, 
    26, 217, 138, 
    25, 214, 131, 
    25, 212, 124, 
    25, 209, 117, 
    24, 207, 111, 
    24, 204, 104, 
    23, 202, 98, 
    22, 200, 92, 
    22, 197, 86, 
    22, 195, 79, 
    21, 192, 74, 
    21, 190, 68, 
    21, 188, 63, 
    21, 185, 57, 
    20, 183, 52, 
    20, 180, 47, 
    20, 178, 42, 
    19, 176, 37, 
    19, 173, 32, 
    18, 171, 27, 
    18, 168, 23, 
    17, 166, 18, 
    21, 164, 17, 
    25, 161, 17, 
    28, 159, 17, 
    31, 156, 16, 
    35, 154, 16, 
    38, 152, 16, 
    41, 149, 15, 
    44, 147, 15, 
    47, 144, 15, 
    49, 142, 14, 
    52, 140, 14, 
    54, 137, 13, 
    57, 135, 13, 
    59, 132, 13, 
    61, 130, 13, 
    63, 128, 12, 
    133, 255, 25, 
    138, 253, 25, 
    142, 250, 24, 
    148, 248, 24, 
    152, 245, 24, 
    157, 243, 22, 
    161, 241, 22, 
    162, 238, 22, 
    164, 236, 22, 
    164, 233, 21, 
    165, 231, 21, 
    167, 229, 21, 
    167, 226, 21, 
    168, 224, 21, 
    169, 221, 20, 
    169, 219, 20, 
    170, 217, 20, 
    170, 214, 20, 
    171, 212, 19, 
    172, 209, 19, 
    172, 207, 19, 
    173, 204, 19, 
    173, 202, 18, 
    172, 200, 18, 
    173, 197, 18, 
    174, 195, 18, 
    173, 192, 17, 
    174, 190, 16, 
    173, 188, 16, 
    173, 185, 16, 
    174, 183, 16, 
    174, 180, 16, 
    174, 178, 15, 
    175, 176, 15, 
    173, 172, 15, 
    171, 167, 15, 
    168, 162, 14, 
    166, 159, 14, 
    164, 154, 14, 
    161, 149, 14, 
    159, 145, 14, 
    156, 140, 13, 
    154, 136, 13, 
    152, 132, 13, 
    149, 128, 13, 
    147, 123, 12, 
    144, 119, 12, 
    142, 115, 11, 
    140, 111, 11, 
    137, 107, 11, 
    135, 103, 11, 
    132, 99, 11, 
    130, 96, 10, 
    128, 92, 10, 
    255, 181, 20, 
    255, 178, 20, 
    255, 174, 20, 
    255, 170, 20, 
    255, 167, 20, 
    255, 164, 20, 
    255, 159, 20, 
    255, 155, 20, 
    255, 152, 20, 
    255, 148, 20, 
    255, 145, 19, 
    255, 142, 19, 
    255, 136, 19, 
    255, 133, 19, 
    255, 130, 19, 
    255, 126, 19, 
    255, 123, 19, 
    255, 119, 19, 
    255, 115, 19, 
    255, 111, 19, 
    255, 108, 19, 
    255, 105, 19, 
    255, 100, 19, 
    255, 96, 19, 
    255, 93, 19, 
    255, 89, 19, 
    255, 85, 19, 
    255, 82, 19, 
    255, 79, 18, 
    255, 74, 18, 
    255, 71, 18, 
    255, 67, 18, 
    255, 63, 18, 
    255, 60, 18, 
    255, 56, 18, 
    255, 52, 18, 
    255, 48, 18, 
    255, 45, 18, 
    255, 41, 18, 
    255, 37, 18, 
  };
  if(opt->splotch)
  {
  	for(int i=0; i<256; i++)
  	{
    		int k = i*3; 
		opt->extPalR.push_back(v[k]/255.0);
		opt->extPalG.push_back(v[k+1]/255.0);
		opt->extPalB.push_back(v[k+2]/255.0);
		opt->extPalA.push_back(1/255.0);
 	}
	return;	
   }

  lut->SetNumberOfTableValues(256);
  for(int i=0; i<256; i++)
  {
    int k = i*3; 
    lut->SetTableValue(i, v[k]/255.0, v[k+1]/255.0, v[k+2]/255.0, 1);
  }
};

//---------------------------------------------------------------------
void lutGlow(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
   //glow
  unsigned char v[256*3] = 
  {
    0, 0, 0, 
    0, 0, 0, 
    5, 0, 0, 
    5, 0, 0, 
    9, 0, 0, 
    9, 0, 0, 
    13, 0, 0, 
    13, 0, 5, 
    17, 0, 5, 
    17, 0, 5, 
    21, 0, 5, 
    21, 0, 5, 
    25, 0, 5, 
    25, 0, 5, 
    29, 0, 5, 
    29, 0, 9, 
    33, 0, 9, 
    33, 0, 9, 
    37, 0, 9, 
    37, 0, 9, 
    41, 0, 9, 
    41, 0, 9, 
    45, 0, 9, 
    45, 0, 9, 
    49, 0, 13, 
    49, 0, 13, 
    53, 0, 13, 
    53, 0, 13, 
    57, 0, 13, 
    57, 0, 13, 
    61, 0, 13, 
    61, 5, 13, 
    65, 5, 13, 
    65, 5, 13, 
    69, 5, 13, 
    69, 5, 13, 
    73, 5, 17, 
    73, 5, 17, 
    77, 5, 17, 
    81, 5, 17, 
    81, 5, 17, 
    85, 5, 17, 
    85, 5, 17, 
    89, 5, 17, 
    89, 9, 17, 
    93, 9, 17, 
    93, 9, 17, 
    97, 9, 17, 
    97, 9, 17, 
    101, 9, 17, 
    101, 9, 17, 
    105, 9, 17, 
    105, 9, 17, 
    109, 13, 17, 
    109, 13, 17, 
    113, 13, 17, 
    113, 13, 17, 
    117, 13, 17, 
    117, 13, 17, 
    121, 13, 17, 
    125, 13, 17, 
    125, 13, 17, 
    128, 17, 17, 
    128, 17, 17, 
    132, 17, 21, 
    132, 17, 21, 
    136, 17, 21, 
    136, 17, 21, 
    140, 17, 21, 
    140, 21, 21, 
    144, 21, 21, 
    144, 21, 21, 
    148, 21, 21, 
    148, 21, 21, 
    152, 25, 21, 
    152, 25, 21, 
    156, 25, 21, 
    156, 25, 21, 
    156, 25, 21, 
    160, 29, 21, 
    160, 29, 21, 
    164, 29, 21, 
    164, 29, 21, 
    168, 33, 21, 
    168, 33, 21, 
    168, 33, 21, 
    172, 33, 21, 
    172, 37, 21, 
    176, 37, 21, 
    176, 37, 21, 
    176, 37, 21, 
    180, 41, 21, 
    180, 41, 21, 
    180, 41, 21, 
    184, 45, 21, 
    184, 45, 21, 
    188, 45, 21, 
    188, 49, 21, 
    188, 49, 21, 
    192, 49, 21, 
    192, 53, 21, 
    192, 53, 21, 
    192, 53, 21, 
    196, 57, 21, 
    196, 57, 21, 
    196, 61, 21, 
    200, 61, 21, 
    200, 61, 21, 
    200, 65, 21, 
    200, 65, 21, 
    204, 69, 21, 
    204, 69, 21, 
    204, 69, 21, 
    208, 73, 21, 
    208, 73, 21, 
    208, 77, 21, 
    208, 77, 21, 
    208, 81, 21, 
    212, 81, 21, 
    212, 85, 21, 
    212, 85, 21, 
    212, 89, 21, 
    212, 89, 21, 
    216, 93, 21, 
    216, 93, 21, 
    216, 97, 21, 
    216, 97, 21, 
    216, 101, 21, 
    220, 101, 21, 
    220, 105, 21, 
    220, 105, 21, 
    220, 109, 21, 
    220, 109, 21, 
    220, 113, 21, 
    220, 113, 21, 
    224, 117, 21, 
    224, 117, 25, 
    224, 121, 25, 
    224, 121, 25, 
    224, 125, 25, 
    224, 125, 25, 
    224, 128, 25, 
    228, 128, 25, 
    228, 132, 25, 
    228, 132, 29, 
    228, 136, 29, 
    228, 136, 29, 
    228, 140, 29, 
    228, 140, 29, 
    228, 144, 33, 
    232, 144, 33, 
    232, 144, 33, 
    232, 148, 33, 
    232, 148, 33, 
    232, 152, 37, 
    232, 152, 37, 
    232, 156, 37, 
    232, 156, 37, 
    236, 160, 41, 
    236, 160, 41, 
    236, 160, 41, 
    236, 164, 41, 
    236, 164, 45, 
    236, 168, 45, 
    236, 168, 45, 
    236, 172, 49, 
    236, 172, 49, 
    236, 172, 49, 
    240, 176, 53, 
    240, 176, 53, 
    240, 180, 53, 
    240, 180, 57, 
    240, 180, 57, 
    240, 184, 61, 
    240, 184, 61, 
    240, 188, 61, 
    240, 188, 65, 
    240, 188, 65, 
    240, 192, 69, 
    244, 192, 69, 
    244, 192, 73, 
    244, 192, 73, 
    244, 192, 77, 
    244, 200, 77, 
    244, 200, 81, 
    244, 200, 81, 
    244, 204, 85, 
    244, 204, 85, 
    244, 204, 89, 
    244, 208, 89, 
    244, 208, 93, 
    244, 208, 93, 
    248, 212, 97, 
    248, 212, 97, 
    248, 212, 101, 
    248, 216, 105, 
    248, 216, 105, 
    248, 216, 109, 
    248, 220, 109, 
    248, 220, 113, 
    248, 220, 113, 
    248, 224, 117, 
    248, 224, 121, 
    248, 224, 121, 
    248, 224, 125, 
    248, 228, 125, 
    248, 228, 129, 
    248, 228, 129, 
    248, 228, 133, 
    248, 232, 137, 
    248, 232, 137, 
    252, 232, 141, 
    252, 232, 145, 
    252, 236, 145, 
    252, 236, 148, 
    252, 236, 148, 
    252, 236, 152, 
    252, 240, 156, 
    252, 240, 156, 
    252, 240, 160, 
    252, 240, 160, 
    252, 240, 164, 
    252, 240, 168, 
    252, 244, 168, 
    252, 244, 172, 
    252, 244, 172, 
    252, 244, 176, 
    252, 244, 180, 
    252, 244, 180, 
    252, 248, 184, 
    252, 248, 188, 
    252, 248, 188, 
    252, 248, 192, 
    252, 248, 192, 
    252, 248, 196, 
    252, 248, 200, 
    252, 248, 200, 
    252, 252, 204, 
    252, 252, 208, 
    252, 252, 208, 
    252, 252, 212, 
    252, 252, 212, 
    252, 252, 216, 
    252, 252, 220, 
    252, 252, 220, 
    252, 252, 224, 
    252, 252, 228, 
    252, 252, 228, 
    252, 252, 232, 
    252, 252, 236, 
    252, 252, 236, 
    252, 252, 240, 
    252, 252, 244, 
    252, 252, 244, 
    252, 252, 248, 
    252, 252, 255, 
  };
  if(opt->splotch)
  {
  	for(int i=0; i<256; i++)
  	{
    		int k = i*3; 
		opt->extPalR.push_back(v[k]/255.0);
		opt->extPalG.push_back(v[k+1]/255.0);
		opt->extPalB.push_back(v[k+2]/255.0);
		opt->extPalA.push_back(255/255.0);
 	}
	return;	
   }

  lut->SetNumberOfTableValues(256);
  for(int i=0; i<256; i++)
  {
    int k = i*3; 
    lut->SetTableValue(i, v[k]/255.0, v[k+1]/255.0, v[k+2]/255.0, 1);
  }
};


//---------------------------------------------------------------------
void lutEField(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
  //efield
  unsigned char v[256*3] = 
  {
    237,253,135,
    233,251,137,
    232,251,137,
    230,249,140,
    226,249,140,
    225,247,142,
    223,246,144,
    221,246,145,
    218,244,147,
    216,244,149,
    214,242,149,
    211,242,151,
    209,240,153,
    207,239,154,
    205,239,156,
    202,239,158,
    200,237,158,
    198,237,161,
    195,235,161,
    193,235,163,
    191,233,165,
    188,232,167,
    186,232,168,
    184,230,170,
    181,230,170,
    179,228,172,
    177,228,174,
    175,226,175,
    172,226,177,
    170,226,179,
    168,225,179,
    165,223,181,
    163,223,182,
    161,221,184,
    158,221,186,
    156,219,188,
    154,219,188,
    151,218,191,
    149,216,191,
    147,216,193,
    144,214,195,
    142,214,195,
    140,214,198,
    137,212,198,
    135,212,200,
    133,211,202,
    130,209,204,
    128,209,205,
    126,207,207,
    124,207,207,
    121,205,209,
    119,205,211,
    117,204,212,
    114,202,214,
    112,202,216,
    110,202,216,
    107,200,219,
    105,200,219,
    103,198,221,
    100,198,223,
    98,196,225,
    96,195,226,
    93,195,228,
    91,193,228,
    89,193,230,
    86,191,232,
    84,191,233,
    82,189,235,
    80,189,237,
    77,188,237,
    75,188,239,
    73,186,240,
    70,186,242,
    68,184,244,
    66,184,246,
    65,182,246,
    61,181,249,
    59,181,249,
    58,179,251,
    54,179,253,
    52,177,255,
    54,175,255,
    54,174,255,
    54,172,255,
    56,170,255,
    56,168,255,
    58,167,255,
    58,165,255,
    59,163,255,
    59,161,255,
    61,158,255,
    61,156,255,
    61,154,255,
    63,154,255,
    63,151,255,
    63,149,255,
    65,147,255,
    66,145,255,
    66,144,255,
    66,142,255,
    68,140,255,
    68,140,255,
    70,137,255,
    70,135,255,
    70,135,255,
    72,133,255,
    73,131,255,
    73,130,255,
    73,128,255,
    75,126,255,
    75,124,255,
    75,124,255,
    77,121,255,
    77,121,255,
    79,119,255,
    79,117,255,
    79,117,255,
    80,114,255,
    82,114,255,
    82,112,255,
    82,110,255,
    84,110,255,
    84,107,255,
    84,107,255,
    86,105,255,
    86,105,255,
    87,103,255,
    87,102,255,
    89,100,255,
    89,100,255,
    91,98,255,
    91,96,255,
    89,94,255,
    89,91,255,
    87,89,255,
    89,86,255,
    89,86,255,
    89,84,255,
    91,84,255,
    91,82,255,
    93,82,255,
    93,80,255,
    94,79,255,
    96,79,255,
    98,77,255,
    98,77,255,
    100,75,255,
    100,75,255,
    102,73,255,
    103,73,255,
    105,72,255,
    105,70,255,
    107,70,255,
    107,68,255,
    110,68,255,
    110,66,255,
    112,65,255,
    114,63,255,
    114,63,255,
    117,61,255,
    117,61,255,
    119,59,255,
    121,59,255,
    123,58,255,
    124,56,255,
    126,56,255,
    128,54,255,
    128,54,255,
    130,52,255,
    131,52,253,
    133,52,253,
    135,51,253,
    137,49,253,
    137,49,253,
    138,49,253,
    140,47,253,
    142,47,253,
    144,47,251,
    144,45,251,
    147,45,251,
    147,45,251,
    149,45,251,
    151,43,251,
    153,42,251,
    154,42,251,
    156,42,251,
    156,40,249,
    158,40,249,
    160,40,249,
    161,38,249,
    163,38,249,
    165,38,249,
    167,36,249,
    168,36,249,
    170,35,247,
    170,35,247,
    172,35,247,
    175,33,247,
    175,33,246,
    177,33,246,
    179,31,246,
    181,31,246,
    182,31,246,
    184,29,246,
    186,29,246,
    188,28,246,
    189,28,246,
    191,28,244,
    193,26,244,
    195,26,244,
    195,26,244,
    198,26,244,
    200,24,244,
    202,24,244,
    202,24,244,
    205,22,242,
    207,22,242,
    209,22,242,
    209,21,242,
    212,21,242,
    214,19,242,
    216,19,242,
    218,19,242,
    219,17,242,
    221,17,240,
    223,17,240,
    225,15,240,
    226,15,240,
    228,15,239,
    230,15,239,
    232,14,239,
    233,12,239,
    235,12,239,
    237,12,239,
    239,12,237,
    239,10,235,
    239,10,232,
    237,10,230,
    237,8,228,
    237,8,226,
    237,8,223,
    237,8,221,
    237,7,219,
    237,5,216,
    237,5,214,
    235,5,212,
    235,5,209,
    235,3,207,
    235,3,204,
    235,3,202,
    235,1,200,
    235,1,196,
    235,1,195,
    235,1,191,
    233,0,189,
    233,0,186,
  };
  if(opt->splotch)
  {
  	for(int i=0; i<256; i++)
  	{
    		int k = i*3; 
		opt->extPalR.push_back(v[k]/255.0);
		opt->extPalG.push_back(v[k+1]/255.0);
		opt->extPalB.push_back(v[k+2]/255.0);
		opt->extPalA.push_back(255/255.0);
 	}
	return;	
   }

  lut->SetNumberOfTableValues(256);
  for(int i=0; i<256; i++)
  {
    int k = i*3; 
    lut->SetTableValue(i, v[k]/255.0, v[k+1]/255.0, v[k+2]/255.0, 1);
  }
};


//---------------------------------------------------------------------
void lutDefault(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
  Color c;
    
  if(!opt->splotch)
	lut->SetNumberOfTableValues(256);
  for(int i=0; i<256; i++)
  {
    int h = (i*240.0)/255.0;
    c.setHSV(h,255,255);
    if(opt->splotch)
    {
	opt->extPalR.push_back(c.m_red/255.0);
	opt->extPalG.push_back(c.m_green/255.0);
	opt->extPalB.push_back(c.m_blue/255.0);
	opt->extPalA.push_back(255/255.0);
    } else
	lut->SetTableValue(i, c.m_red/255.0, c.m_green/255.0, c.m_blue/255.0, 1);
  }    
    
};
//---------------------------------------------------------------------
void lutMinMax(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
  Color c;
    
      if(!opt->splotch)
	lut->SetNumberOfTableValues(256);
  int i;
  for(i=0; i<128; i++)
  {
    int h = (i*240.0)/255.0;
    c.setHSV(h,255,255);
    if(opt->splotch)
    {
	opt->extPalR.push_back(c.m_red/255.0);
	opt->extPalG.push_back(c.m_green/255.0);
	opt->extPalB.push_back(c.m_blue/255.0);
	opt->extPalA.push_back((128-i)/255.0);
    } else
       lut->SetTableValue(i, c.m_red/255.0, c.m_green/255.0, c.m_blue/255.0, (128-i)/128.0);
  }
  for(i=128; i<256; i++)
  {
    int h = (i*240.0)/255.0;
    c.setHSV(h,255,255);
    if(opt->splotch)
    {
	opt->extPalR.push_back(c.m_red/255.0);
	opt->extPalG.push_back(c.m_green/255.0);
	opt->extPalB.push_back(c.m_blue/255.0);
	opt->extPalA.push_back((128-i)/255.0);
    } else
      lut->SetTableValue(i, c.m_red/255.0, c.m_green/255.0, c.m_blue/255.0, (i-128)/128.0);
  }
};
//---------------------------------------------------------------------
void lutDefaultStep(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
  lutDefault(opt,lut);
  
  Color c(128,128,128);
    
  for(int i=0; i<256; i+=16)
  {
    if(opt->splotch)
    {
	opt->extPalR.push_back(c.m_red/255.0);
	opt->extPalG.push_back(c.m_green/255.0);
	opt->extPalB.push_back(c.m_blue/255.0);
	opt->extPalA.push_back(255/255.0);
    } else
    lut->SetTableValue(i, c.m_red/255.0, c.m_green/255.0, c.m_blue/255.0, 1);
  }
};
//---------------------------------------------------------------------
void lutGray(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
      if(!opt->splotch)
	lut->SetNumberOfTableValues(128);
  for(int i=0; i<128; i++)
  {
     if(opt->splotch)
    {
	opt->extPalR.push_back(i*2/255.0);
	opt->extPalG.push_back(i*2/255.0);
	opt->extPalB.push_back(i*2/255.0);
	opt->extPalA.push_back(255/255.0);
    } else
   lut->SetTableValue(i, i/128.0, i/128.0, i/128.0, 1);
  }
};
//---------------------------------------------------------------------
void lutPureRed(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
      if(!opt->splotch)
	lut->SetNumberOfTableValues(128);
  for(int i=0; i<128; i++)
  {
     if(opt->splotch)
    {
	opt->extPalR.push_back(i*2/255.0);
	opt->extPalG.push_back(0/255.0);
	opt->extPalB.push_back(0/255.0);
	opt->extPalA.push_back(255/255.0);
    } else
      lut->SetTableValue(i, i/128.0, 0, 0, 1);
  }
};
//---------------------------------------------------------------------
void lutPureGreen(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
    if(!opt->splotch)
	lut->SetNumberOfTableValues(128);
  for(int i=0; i<128; i++)
  {
     if(opt->splotch)
    {
	opt->extPalR.push_back(0/255.0);
	opt->extPalG.push_back(i*2/255.0);
	opt->extPalB.push_back(0/255.0);
	opt->extPalA.push_back(255/255.0);
    } else
      lut->SetTableValue(i, 0, i/128.0, 0, 1);
  }
};
//---------------------------------------------------------------------
void lutPureBlue(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
    if(!opt->splotch)
	lut->SetNumberOfTableValues(128);
  for(int i=0; i<128; i++)
  {
     if(opt->splotch)
    {
	opt->extPalR.push_back(0/255.0);
	opt->extPalG.push_back(0/255.0);
	opt->extPalB.push_back(i*2/255.0);
	opt->extPalA.push_back(255/255.0);
    } else
	lut->SetTableValue(i, 0, 0, i/128.0, 1);
  }
};

//---------------------------------------------------------------------
void lutAllYellow(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
      if(!opt->splotch)
	lut->SetNumberOfTableValues(1);
  for(int i=0; i<1; i++)
  {
     if(opt->splotch)
    {
	opt->extPalR.push_back(i*2/255.0);
	opt->extPalG.push_back(i*2/255.0);
	opt->extPalB.push_back(0/255.0);
	opt->extPalA.push_back(255/255.0);
    } else
      lut->SetTableValue(i, 1, 1, 0, 1);
  }
};
//---------------------------------------------------------------------
void lutAllCyane(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
      if(!opt->splotch)
	lut->SetNumberOfTableValues(1);
  for(int i=0; i<1; i++)
  {
     if(opt->splotch)
    {
	opt->extPalR.push_back(0/255.0);
	opt->extPalG.push_back(i*2/255.0);
	opt->extPalB.push_back(i*2/255.0);
	opt->extPalA.push_back(255/255.0);
    } else
      lut->SetTableValue(i, 0, 1, 1, 1);
  }

}
//---------------------------------------------------------------------
void lutAllViolet(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
      if(!opt->splotch)
	lut->SetNumberOfTableValues(1);
  for(int i=0; i<1; i++)
  {
     if(opt->splotch)
    {
	opt->extPalR.push_back(i*2/255.0);
	opt->extPalG.push_back(0/255.0);
	opt->extPalB.push_back(i*2/255.0);
	opt->extPalA.push_back(255/255.0);
    } else
      lut->SetTableValue(i, 1, 0, 1, 1);
  }

}
//---------------------------------------------------------------------
void lutAllWhite(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
      if(!opt->splotch)
	lut->SetNumberOfTableValues(1);
  for(int i=0; i<1; i++)
  {
     if(opt->splotch)
    {
	opt->extPalR.push_back(i*2/255.0);
	opt->extPalG.push_back(i*2/255.0);
	opt->extPalB.push_back(i*2/255.0);
	opt->extPalA.push_back(255/255.0);
    } else
      lut->SetTableValue(i, 1, 1, 1, 1);
  }

}
//---------------------------------------------------------------------
void lutAllBlack(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
      if(!opt->splotch)
	lut->SetNumberOfTableValues(1);
  for(int i=0; i<1; i++)
  {
     if(opt->splotch)
    {
	opt->extPalR.push_back(0/255.0);
	opt->extPalG.push_back(0/255.0);
	opt->extPalB.push_back(0/255.0);
	opt->extPalA.push_back(255/255.0);
    } else
      lut->SetTableValue(i, 0, 0, 0, 1);
  }

}
//---------------------------------------------------------------------
void lutAllRed(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
      if(!opt->splotch)
	lut->SetNumberOfTableValues(1);
  for(int i=0; i<1; i++)
  {
     if(opt->splotch)
    {
	opt->extPalR.push_back(i*2/255.0);
	opt->extPalG.push_back(0.);
	opt->extPalB.push_back(0.);
	opt->extPalA.push_back(255/255.0);
    } else
      lut->SetTableValue(i, 1, 0, 0, 1);
  }

}
//---------------------------------------------------------------------
void lutAllGreen(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
      if(!opt->splotch)
	lut->SetNumberOfTableValues(1);
  for(int i=0; i<1; i++)
  {
     if(opt->splotch)
    {
	opt->extPalR.push_back(0.);
	opt->extPalG.push_back(i*2/255.0);
	opt->extPalB.push_back(0.);
	opt->extPalA.push_back(255/255.0);
    } else
      lut->SetTableValue(i, 0, 1, 0, 1);
  }

}
//---------------------------------------------------------------------
void lutAllBlu(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
      if(!opt->splotch)
	lut->SetNumberOfTableValues(1);
  for(int i=0; i<1; i++)
  {
     if(opt->splotch)
    {
	opt->extPalR.push_back(0.);
	opt->extPalG.push_back(0.);
	opt->extPalB.push_back(i*2/255.0);
	opt->extPalA.push_back(255/255.0);
    } else
      lut->SetTableValue(i, 0, 0, 1, 1);
  }
}


//---------------------------------------------------------------------
void lutRun1(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
  //Run1
  unsigned char v[256*4] = 
  {
    0,255,0,0,
    64,198,255,0,
    128,3,255,233,
    192,78,47,255,
    1,255,4,0,
    65,193,255,0,
    129,4,255,238,
    193,80,45,255,
    2,255,9,0,
    66,189,255,0,
    130,5,255,243,
    194,82,43,255,
    3,255,14,0,
    67,182,255,0,
    131,6,255,248,
    195,85,41,255,
    4,255,19,0,
    68,175,255,0,
    132,7,255,253,
    196,87,39,255,
    5,255,24,0,
    69,168,255,0,
    133,8,252,255,
    197,90,37,255,
    6,255,29,0,
    70,161,255,0,
    134,9,247,255,
    198,93,35,255,
    7,255,34,0,
    71,154,255,0,
    135,10,242,255,
    199,96,33,255,
    8,255,38,0,
    72,147,255,0,
    136,10,238,255,
    200,98,31,255,
    9,255,43,0,
    73,140,255,0,
    137,11,233,255,
    201,101,29,255,
    10,255,48,0,
    74,133,255,0,
    138,12,228,255,
    202,104,27,255,
    11,255,53,0,
    75,126,255,0,
    139,13,224,255,
    203,108,25,255,
    12,255,58,0,
    76,119,255,0,
    140,14,219,255,
    204,111,23,255,
    13,255,63,0,
    77,112,255,0,
    141,15,215,255,
    205,114,21,255,
    14,255,68,0,
    78,105,255,0,
    142,16,210,255,
    206,117,19,255,
    15,255,72,0,
    79,98,255,0,
    143,17,206,255,
    207,121,17,255,
    16,255,77,0,
    80,91,255,0,
    144,18,202,255,
    208,124,15,255,
    17,255,82,0,
    81,84,255,0,
    145,19,197,255,
    209,128,13,255,
    18,255,87,0,
    82,77,255,0,
    146,20,193,255,
    210,131,11,255,
    19,255,92,0,
    83,70,255,0,
    147,20,189,255,
    211,135,9,255,
    20,255,97,0,
    84,64,255,0,
    148,21,185,255,
    212,139,7,255,
    21,255,102,0,
    85,57,255,0,
    149,22,180,255,
    213,143,5,255,
    22,255,106,0,
    86,50,255,0,
    150,23,176,255,
    214,147,3,255,
    23,255,111,0,
    87,43,255,0,
    151,24,172,255,
    215,151,1,255,
    24,255,116,0,
    88,36,255,0,
    152,25,168,255,
    216,155,0,255,
    25,255,121,0,
    89,29,255,0,
    153,26,164,255,
    217,159,0,255,
    26,255,126,0,
    90,22,255,0,
    154,27,160,255,
    218,163,0,255,
    27,255,131,0,
    91,15,255,0,
    155,28,156,255,
    219,167,0,255,
    28,255,136,0,
    92,8,255,0,
    156,29,152,255,
    220,172,0,255,
    29,255,141,0,
    93,1,255,0,
    157,30,148,255,
    221,176,0,255,
    30,255,145,0,
    94,0,255,5,
    158,30,144,255,
    222,180,0,255,
    31,255,150,0,
    95,0,255,12,
    159,31,140,255,
    223,184,0,255,
    32,255,155,0,
    96,0,255,19,
    160,32,136,255,
    224,188,0,255,
    33,255,160,0,
    97,0,255,26,
    161,33,133,255,
    225,192,0,255,
    34,255,165,0,
    98,0,255,33,
    162,34,129,255,
    226,197,0,255,
    35,255,170,0,
    99,0,255,40,
    163,35,125,255,
    227,201,0,255,
    36,255,175,0,
    100,0,255,47,
    164,36,122,255,
    228,205,0,255,
    37,255,179,0,
    101,0,255,54,
    165,37,118,255,
    229,209,0,255,
    38,255,184,0,
    102,0,255,60,
    166,38,114,255,
    230,213,0,255,
    39,255,189,0,
    103,0,255,67,
    167,39,111,255,
    231,217,0,255,
    40,255,194,0,
    104,0,255,74,
    168,40,107,255,
    232,222,0,255,
    41,255,199,0,
    105,0,255,81,
    169,40,104,255,
    233,226,0,255,
    42,255,204,0,
    106,0,255,88,
    170,41,100,255,
    234,230,0,255,
    43,255,209,0,
    107,0,255,95,
    171,42,97,255,
    235,234,0,255,
    44,255,213,0,
    108,0,255,102,
    172,43,93,255,
    236,238,0,255,
    45,255,218,0,
    109,0,255,109,
    173,44,90,255,
    237,242,0,255,
    46,255,223,0,
    110,0,255,116,
    174,45,87,255,
    238,247,0,255,
    47,255,228,0,
    111,0,255,123,
    175,46,84,255,
    239,251,0,255,
    48,255,233,0,
    112,0,255,130,
    176,47,80,255,
    240,255,0,254,
    49,255,238,0,
    113,0,255,137,
    177,48,77,255,
    241,255,0,250,
    50,255,243,0,
    114,0,255,144,
    178,49,74,255,
    242,255,0,246,
    51,255,248,0,
    115,0,255,151,
    179,50,71,255,
    243,255,0,242,
    52,255,252,0,
    116,0,255,158,
    180,50,68,255,
    244,255,0,237,
    53,252,255,0,
    117,0,255,165,
    181,53,66,255,
    245,255,0,233,
    54,247,255,0,
    118,0,255,172,
    182,55,64,255,
    246,255,0,229,
    55,242,255,0,
    119,0,255,178,
    183,57,62,255,
    247,255,0,225,
    56,237,255,0,
    120,0,255,185,
    184,59,60,255,
    248,255,0,221,
    57,232,255,0,
    121,0,255,192,
    185,63,61,255,
    249,255,0,217,
    58,227,255,0,
    122,0,255,199,
    186,65,59,255,
    250,255,0,212,
    59,223,255,0,
    123,0,255,206,
    187,67,57,255,
    251,255,0,208,
    60,218,255,0,
    124,0,255,213,
    188,69,55,255,
    252,255,0,204,
    61,213,255,0,
    125,0,255,218,
    189,71,53,255,
    253,255,0,200,
    62,208,255,0,
    126,1,255,223,
    190,73,51,255,
    254,255,0,196,
    63,203,255,0,
    127,2,255,228,
    191,75,49,255,
    255,255,0,191
  };
  if(opt->splotch)
  {
  	for(int i=0; i<256; i++)
  	{
    		int k = i*4; 
		opt->extPalR.push_back(v[k]/255.0);
		opt->extPalG.push_back(v[k+1]/255.0);
		opt->extPalB.push_back(v[k+2]/255.0);
		opt->extPalA.push_back(v[k+3]/255.0);
 	}
	return;	
   }

  lut->SetNumberOfTableValues(256);
  for(int i=0; i<256; i++)
  {
    int k = i*4; 
    lut->SetTableValue(i, v[k]/255.0, v[k+1]/255.0, v[k+2]/255.0, v[k+3]/255.0);
  }
};
//---------------------------------------------------------------------
void lutRun2(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
  //Run2
  unsigned char v[256*4] = 
  {
    0,255,89,89,
    64,255,151,151,
    128,255,255,255,
    192,130,142,255,
    1,255,90,90,
    65,255,153,153,
    129,253,253,255,
    193,128,141,255,
    2,255,91,91,
    66,255,154,154,
    130,251,251,255,
    194,127,140,255,
    3,255,92,92,
    67,255,156,156,
    131,249,249,255,
    195,126,139,255,
    4,255,93,93,
    68,255,157,157,
    132,247,247,255,
    196,125,138,255,
    5,255,94,94,
    69,255,159,159,
    133,245,246,255,
    197,124,137,255,
    6,255,95,95,
    70,255,161,161,
    134,243,244,255,
    198,123,136,255,
    7,255,96,96,
    71,255,162,162,
    135,241,242,255,
    199,121,135,255,
    8,255,97,97,
    72,255,164,164,
    136,239,240,255,
    200,120,134,255,
    9,255,97,97,
    73,255,165,165,
    137,237,239,255,
    201,119,133,255,
    10,255,98,98,
    74,255,167,167,
    138,235,237,255,
    202,118,132,255,
    11,255,99,99,
    75,255,169,169,
    139,233,235,255,
    203,117,130,255,
    12,255,100,100,
    76,255,170,170,
    140,231,233,255,
    204,116,129,255,
    13,255,101,101,
    77,255,172,172,
    141,229,232,255,
    205,114,128,255,
    14,255,102,102,
    78,255,174,174,
    142,227,230,255,
    206,113,127,255,
    15,255,103,103,
    79,255,175,175,
    143,225,228,255,
    207,112,126,255,
    16,255,104,104,
    80,255,177,177,
    144,223,226,255,
    208,111,125,255,
    17,255,105,105,
    81,255,178,178,
    145,221,224,255,
    209,110,124,255,
    18,255,106,106,
    82,255,180,180,
    146,219,223,255,
    210,108,123,255,
    19,255,107,107,
    83,255,182,182,
    147,217,221,255,
    211,107,122,255,
    20,255,108,108,
    84,255,183,183,
    148,215,219,255,
    212,106,121,255,
    21,255,109,109,
    85,255,185,185,
    149,213,217,255,
    213,105,120,255,
    22,255,110,110,
    86,255,187,187,
    150,211,216,255,
    214,104,119,255,
    23,255,111,111,
    87,255,188,188,
    151,209,214,255,
    215,103,118,255,
    24,255,112,112,
    88,255,190,190,
    152,207,212,255,
    216,101,117,255,
    25,255,113,113,
    89,255,191,191,
    153,205,210,255,
    217,100,116,255,
    26,255,114,114,
    90,255,193,193,
    154,203,209,255,
    218,99,115,255,
    27,255,115,115,
    91,255,195,195,
    155,201,207,255,
    219,98,114,255,
    28,255,116,116,
    92,255,196,196,
    156,200,205,255,
    220,97,112,255,
    29,255,117,117,
    93,255,198,198,
    157,198,203,255,
    221,96,111,255,
    30,255,118,118,
    94,255,199,199,
    158,196,201,255,
    222,94,110,255,
    31,255,119,119,
    95,255,201,201,
    159,194,200,255,
    223,93,109,255,
    32,255,120,120,
    96,255,203,203,
    160,192,198,255,
    224,92,108,255,
    33,255,121,121,
    97,255,204,204,
    161,190,196,255,
    225,91,107,255,
    34,255,122,122,
    98,255,206,206,
    162,188,194,255,
    226,90,106,255,
    35,255,123,123,
    99,255,208,208,
    163,186,193,255,
    227,88,105,255,
    36,255,124,124,
    100,255,209,209,
    164,184,191,255,
    228,87,104,255,
    37,255,125,125,
    101,255,211,211,
    165,182,189,255,
    229,86,103,255,
    38,255,126,126,
    102,255,212,212,
    166,180,187,255,
    230,85,102,255,
    39,255,127,127,
    103,255,214,214,
    167,178,186,255,
    231,84,101,255,
    40,255,128,128,
    104,255,216,216,
    168,176,184,255,
    232,83,100,255,
    41,255,129,129,
    105,255,217,217,
    169,174,182,255,
    233,81,99,255,
    42,255,130,130,
    106,255,219,219,
    170,172,180,255,
    234,80,98,255,
    43,255,131,131,
    107,255,221,221,
    171,170,178,255,
    235,79,97,255,
    44,255,131,131,
    108,255,222,222,
    172,168,177,255,
    236,78,96,255,
    45,255,132,132,
    109,255,224,224,
    173,166,175,255,
    237,77,95,255,
    46,255,133,133,
    110,255,225,225,
    174,164,173,255,
    238,76,93,255,
    47,255,134,134,
    111,255,227,227,
    175,162,171,255,
    239,74,92,255,
    48,255,135,135,
    112,255,229,229,
    176,160,170,255,
    240,73,91,255,
    49,255,136,136,
    113,255,230,230,
    177,158,168,255,
    241,72,90,255,
    50,255,137,137,
    114,255,232,232,
    178,156,166,255,
    242,71,89,255,
    51,255,138,138,
    115,255,233,233,
    179,154,164,255,
    243,70,88,255,
    52,255,139,139,
    116,255,235,235,
    180,152,163,255,
    244,69,87,255,
    53,255,140,140,
    117,255,237,237,
    181,150,161,255,
    245,67,86,255,
    54,255,141,141,
    118,255,238,238,
    182,148,159,255,
    246,66,85,255,
    55,255,142,142,
    119,255,240,240,
    183,146,157,255,
    247,65,84,255,
    56,255,143,143,
    120,255,242,242,
    184,145,156,255,
    248,64,83,255,
    57,255,144,144,
    121,255,243,243,
    185,143,154,255,
    249,63,82,255,
    58,255,145,145,
    122,255,245,245,
    186,141,152,255,
    250,61,81,255,
    59,255,146,146,
    123,255,246,246,
    187,139,150,255,
    251,60,80,255,
    60,255,147,147,
    124,255,248,248,
    188,137,148,255,
    252,59,79,255,
    61,255,148,148,
    125,255,250,250,
    189,135,147,255,
    253,58,78,255,
    62,255,149,149,
    126,255,251,251,
    190,133,145,255,
    254,57,77,255,
    63,255,150,150,
    127,255,253,253,
    191,131,143,255,
    255,56,75,255
  };
  if(opt->splotch)
  {
  	for(int i=0; i<256; i++)
  	{
    		int k = i*4; 
		opt->extPalR.push_back(v[k]/255.0);
		opt->extPalG.push_back(v[k+1]/255.0);
		opt->extPalB.push_back(v[k+2]/255.0);
		opt->extPalA.push_back(v[k+3]/255.0);
 	}
	return;	
   }

  lut->SetNumberOfTableValues(256);
  for(int i=0; i<256; i++)
  {
    int k = i*4; 
    lut->SetTableValue(i, v[k]/255.0, v[k+1]/255.0, v[k+2]/255.0, v[k+3]/255.0);
  }
};

//---------------------------------------------------------------------
void lutVolRenRGB(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
  //Run2
  unsigned char v[4*4] = 
  {
    128,128,128,0,
    255,0,0,50,
    0,255,0,100,
    0,0,255,150,
  };
  if(opt->splotch)
  {
  	for(int i=0; i<4; i++)
  	{
    		int k = i*4; 
		opt->extPalR.push_back(v[k]/255.0);
		opt->extPalG.push_back(v[k+1]/255.0);
		opt->extPalB.push_back(v[k+2]/255.0);
		opt->extPalA.push_back(v[k+3]/255.0);
 	}
	return;	
   }

  lut->SetNumberOfTableValues(4);
  for(int i=0; i<4; i++)
  {
    int k = i*4; 
    lut->SetTableValue(i, v[k]/255.0, v[k+1]/255.0, v[k+2]/255.0, v[k+3]/255.0);
  }
};

//---------------------------------------------------------------------
void lutVolRenTwoLev(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
  //Run2
  unsigned char v[8*4] = 
  {
    128,128,128,0,
    128,128,128,0,

    255,255,0,50,

    128,128,128,0,
    128,128,128,0,

    255,50,0,100,

    128,128,128,0,
    128,128,128,0,
  };
  if(opt->splotch)
  {
  	for(int i=0; i<8; i++)
  	{
    		int k = i*4; 
		opt->extPalR.push_back(v[k]/255.0);
		opt->extPalG.push_back(v[k+1]/255.0);
		opt->extPalB.push_back(v[k+2]/255.0);
		opt->extPalA.push_back(v[k+3]/255.0);
 	}
	return;	
   }

  lut->SetNumberOfTableValues(8);
  for(int i=0; i<8; i++)
  {
    int k = i*4; 
    lut->SetTableValue(i, v[k]/255.0, v[k+1]/255.0, v[k+2]/255.0, v[k+3]/255.0);
  }
};
//---------------------------------------------------------------------
void lutFile(VisIVOServerOptions *opt,vtkLookupTable *lut)
//---------------------------------------------------------------------
{
  //External Palette
   opt->colorIsFile=true;
   if(opt->splotch)
  	return;
   int maxIdPalette=opt->extPalId[opt->extPalId.size()-1]+1;
   lut->SetNumberOfTableValues(maxIdPalette);
   int lastPalId=-1;
   double lastPalR=0.0;
   double lastPalG=0.0;
   double lastPalB=0.0;
   double lastPalA=0.0;
   double curPalR=0.0;
   double curPalG=0.0;
   double curPalB=0.0;
   double curPalA=0.0;

   for(int i=0; i<opt->extPalId.size(); i++)
   {
	int steps=opt->extPalId[i]-lastPalId;
	for(int j=0;j<steps;j++)
	{
	  lastPalId++;
	  curPalR=((j+1)*((opt->extPalR[i]-lastPalR)/steps))+lastPalR;
	  curPalG=((j+1)*((opt->extPalG[i]-lastPalG)/steps))+lastPalG;
	  curPalB=((j+1)*((opt->extPalB[i]-lastPalB)/steps))+lastPalB;
	  curPalA=((j+1)*((opt->extPalA[i]-lastPalA)/steps))+lastPalA;
	  lut->SetTableValue(lastPalId,curPalR,curPalG,curPalB,curPalA);
	}  
	lastPalR=curPalR;  
	lastPalG=curPalG;  
	lastPalB=curPalB;  
	lastPalA=curPalA;  
    }	
   
}
